'
' JOY-PAD MOTION DETECTION Ver 0.1 beta 97-2-24

'
'  Copyright (c) Jaws-V soft, 1997.
'
' This is just basic idea how to detect joy-pad motion.
' Algorithm : store joypad direction into buffer then check motion...
' Real useful routine will be very different and complex!
' It does check for charging, but I didn't make Sonic Boom motion                                    
' It does not calculate two-in-one, chain, super cancel, double-scoop motion.
' but It has little buffer for special attacks. you can input second special
'  attack just before first special attack ends..
'
' It detects 3 types of hadoken motion.(SMOOTH to ROUGH)
' It detects 5 types of shoryuken motion.(SMOOTH to ROUGH)
'
' It still does not detect some types of hadoken or shoryuken motion.
' for example : F DB D DF + P (I DID NOT CHECK DOWN+BACK..
'                              USER MIGHT USE SAMURAI-SPIRIT STYLE
'                              OF MOTION...)
'
' hmmm... I wonder where Cindy's animation came from... he he he.
'
' send e-mail to
'  changev@aol.com
'
' Visit the JAWS-V soft homepage
'  http://members.aol.com/changev/index.htm
'

DEFINT A-Z

DECLARE SUB CALSTICK ()
DECLARE SUB DELAY (P)
DECLARE SUB DRAWMSXFONT (X, Y, C1, C2, S, S$)
DECLARE SUB FADE (P)
DECLARE SUB INITGRAPHIC ()
DECLARE SUB INITMAINVARIABLE ()
DECLARE SUB INITSTICK ()
DECLARE SUB LOADSCREEN (S$, P)
DECLARE SUB MAIN ()
DECLARE SUB MSXCOLOR ()
DECLARE SUB PSETARROW (X, Y, N, P)
DECLARE SUB PSETKEN (X, Y, N, P)
DECLARE SUB PSETSTICK (X, Y, N, c, P)
DECLARE SUB TPSETHADOKEN (X, Y, N, P)

DECLARE FUNCTION BUTTON (P)
DECLARE FUNCTION JOYPAD ()

CONST FALSE = 0
CONST TRUE = NOT FALSE

CONST DRIVE$ = ""
CONST DATAPATH$ = ""
CONST GRAPHICPATH$ = ""
CONST FONTNAME$ = "MSXFONT.FNT"

CONST VISPAGE = 0
CONST WORKPAGE = 6
CONST BACKGROUNDPAGE = 6
CONST AUXPAGE = 7

CONST COLOR2BLACK = 0
CONST BLACK2COLOR = 1

COMMON SHARED STICKU, STICKD, STICKL, STICKR
COMMON SHARED FOUNDSTICK, CALIBRATEDSTICK, STICKON

REDIM SHARED NEWFONT$(32 TO 126)
REDIM SHARED DIFF(8, 8)
REDIM SHARED KENPTN(22, 3)

REDIM SHARED FMVMASK(541), FMVDATA(541)

FOR J = 1 TO 8: FOR I = 1 TO 8: READ DIFF(I, J): NEXT: NEXT
DATA 0,1,2,3,4,3,2,1,1,0,1,2,3,4,3,2,2,1,0,1,2,3,4,3,3,2,1,0,1,2,3,4
DATA 4,3,2,1,0,1,2,3,3,4,3,2,1,0,1,2,2,3,4,3,2,1,0,1,1,2,3,4,3,2,1,0

FOR J = 0 TO 3: FOR I = 0 TO 22: READ KENPTN(I, J): NEXT: NEXT
DATA 14,00,15,15,16,17,18,18,18,18,18,18,18,15,00,00,00,00,00,00,00,00,00
DATA 22,00,10,10,11,11,11,11,11,12,12,13,13,13,14,14,14,14,14,14,15,15,00
DATA 22,00,01,01,02,02,02,02,03,03,04,04,05,05,06,06,07,07,08,08,09,09,00
DATA 22,20,21,21,22,22,23,23,24,24,25,25,25,25,25,26,26,27,28,29,29,00,00

'- main -
INITGRAPHIC
INITMAINVARIABLE

MAIN

SYSTEM

FUNCTION BUTTON (P)

 RESULT = 0
 IF FOUNDSTICK THEN RESULT = (INP(&H201) AND (2 ^ (3 + P))) = 0
 BUTTON = RESULT

END FUNCTION

SUB CALSTICK

 IF FOUNDSTICK THEN
    '- initialize -
    QUIT = FALSE

    STICKMINX = &H7FFF
    STICKMINY = &H7FFF
    STICKMAXX = &HFFFF8000
    STICKMAXY = &HFFFF8000

    FADE COLOR2BLACK
    CLS
    PSETSTICK 50, 50, -1, 3, AUXPAGE

    SCREEN , , AUXPAGE, VISPAGE
    LOCATE 5, 9: PRINT "JOY PAD CALIBRATION"
    LOCATE 7, 15: PRINT "press all eight "
    LOCATE 8, 15: PRINT "direction of the "
    LOCATE 9, 15: PRINT "joy pad then"
    LOCATE 10, 15: PRINT "press button 1 "
    LOCATE 11, 15: PRINT "or press [ESC]"
    LOCATE 12, 15: PRINT "key to cancel"
   
    SCREEN , , VISPAGE, VISPAGE

    PCOPY AUXPAGE, VISPAGE

    FADE BLACK2COLOR

    '- main -
    DO
       STICKY = 0
       STICKX = 0
       DUMMY = 0

       '- get key baord -
       KEY$ = INKEY$: DUMMY = RND(1)
       IF KEY$ = CHR$(27) THEN QUIT = TRUE

       '- get button(s) -
       TR = BUTTON(1) OR BUTTON(2)

       '- calculate Min,Max stick value -
       OUT &H201, 0
       DO
          STICKDATA = INP(&H201)
          IF (STICKDATA AND 1) THEN STICKX = STICKX + 1 ELSE DUMMY = DUMMY + 1
          IF (STICKDATA AND 2) THEN STICKY = STICKY + 1 ELSE DUMMY = DUMMY + 1
       LOOP UNTIL ((STICKDATA AND &H1) OR (STICKDATA AND &H2)) = 0

       IF STICKX < STICKMINX THEN STICKMINX = STICKX
       IF STICKX > STICKMAXX THEN STICKMAXX = STICKX
       IF STICKY < STICKMINY THEN STICKMINY = STICKY
       IF STICKY > STICKMAXY THEN STICKMAXY = STICKY

       STICKCENX = (STICKMAXX + STICKMINX) \ 2
       STICKCENY = (STICKMAXY + STICKMINY) \ 2

       '- calculate Max, Min range -
       STICKU = STICKCENY - ((STICKCENY - STICKMINY) * .7)
       STICKD = ((STICKMAXY - STICKCENY) * .7) + STICKCENY
       STICKL = STICKCENX - ((STICKCENX - STICKMINX) * .7)
       STICKR = ((STICKMAXX - STICKCENX) * .7) + STICKCENX

       '- output -
       ANGLE = 0
       IF STICKY <= STICKU THEN ANGLE = 1
       IF STICKX >= STICKR THEN ANGLE = 3
       IF STICKY >= STICKD THEN ANGLE = 5
       IF STICKX <= STICKL THEN ANGLE = 7
       IF STICKY <= STICKU AND STICKX >= STICKR THEN ANGLE = 2
       IF STICKX >= STICKR AND STICKY >= STICKD THEN ANGLE = 4
       IF STICKX <= STICKL AND STICKY >= STICKD THEN ANGLE = 6
       IF STICKY <= STICKL AND STICKX <= STICKL THEN ANGLE = 8
   
       PSETSTICK 50, 50, ANGLE, 3, AUXPAGE
       SCREEN , , VISPAGE, VISPAGE
       PCOPY AUXPAGE, VISPAGE

    LOOP UNTIL TR OR QUIT
    CALIBRATEDSTICK = (NOT QUIT)

 END IF

END SUB

SUB DELAY (P)

 STATIC OLDSPEED!
 FOR I = 1 TO P
   DO
     SPEED! = TIMER
   LOOP UNTIL SPEED! <> OLDSPEED!
   OLDSPEED! = SPEED!
 NEXT

END SUB

SUB DRAWMSXFONT (X, Y, C1, C2, S, S$)

 DRAW "BM" + STR$(X) + "," + STR$(Y)
 FOR I = 1 TO LEN(S$)
   IF C2 THEN '- erase back ground -
     DRAW "C" + STR$(C2) + "NR6DNR6DNR6DNR6DNR6DNR6DNR6DNR6U7"
   END IF
   IF C1 THEN '- write text -
     DRAW "C" + STR$(C1) + NEWFONT$(ASC(MID$(S$, I, 1))) + "BR" + STR$(S)
   END IF
 NEXT

END SUB

SUB FADE (P)

 FADESTEP = (8 \ 1) - 1
 SELECT CASE P
 CASE IS = 0   '- fade color to black -
   FOR J = 0 TO FADESTEP
     OUT &H3C8, 0
     FOR I = 0 TO 23
       VALUE1 = VAL(MID$("250009270918451800000000000000006363545509544563", I * 2 + 1, 2))
       OUT &H3C9, VALUE1 - (VALUE1 / FADESTEP * J)
       VALUE1 = VAL(MID$("260054630927095400000000000000000921545436184563", I * 2 + 1, 2))
       OUT &H3C9, VALUE1 - (VALUE1 / FADESTEP * J)
       VALUE1 = VAL(MID$("270009276363096300000000000000000921093609454563", I * 2 + 1, 2))
       OUT &H3C9, VALUE1 - (VALUE1 / FADESTEP * J)
     NEXT
     DELAY (1)
   NEXT

 CASE IS = 1   '- fade black to color -
   FOR J = FADESTEP TO 0 STEP -1
     OUT &H3C8, 0
     FOR I = 0 TO 23
       VALUE1 = VAL(MID$("250009270918451800000000000000006363545509544563", I * 2 + 1, 2))
       OUT &H3C9, VALUE1 - (VALUE1 / FADESTEP * J)
       VALUE1 = VAL(MID$("260054630927095400000000000000000921545436184563", I * 2 + 1, 2))
       OUT &H3C9, VALUE1 - (VALUE1 / FADESTEP * J)
       VALUE1 = VAL(MID$("270009276363096300000000000000000921093609454563", I * 2 + 1, 2))
       OUT &H3C9, VALUE1 - (VALUE1 / FADESTEP * J)
     NEXT
     DELAY (1)
   NEXT
 END SELECT

END SUB

SUB INITGRAPHIC

 SCREEN 7, , VISPAGE, VISPAGE
 CLS

 '- set color -
 PRINT "SET NEW COLOR"
 MSXCOLOR

 '- load graphics -
 PRINT "LOAD GRAPHIC(s)"
 LOADSCREEN "KEN4", 1
 LOADSCREEN "ARROW", 2
 LOADSCREEN "STICK", 3

END SUB

SUB INITMAINVARIABLE

 '---< load font data >---
 PRINT "SET NEW FONT"
 OPEN DRIVE$ + DATAPATH$ + FONTNAME$ FOR INPUT AS #1
 FOR I = 32 TO 126
    LINE INPUT #1, NEWFONT$(I)
 NEXT
 CLOSE #1

 '---< reset timer >---
 DELAY 1

 '---< initialize, check stick >---
 RANDOMIZE TIMER
 DEBUG = FALSE

 FOUNDSTICK = FALSE
 CALIBRATEDSTICK = FALSE

 INITSTICK
 STICKON = FOUNDSTICK
 CALSTICK

 FADE COLOR2BLACK
 CLS

END SUB

SUB INITSTICK

 '- initialize -
 COUNTER = 0
 OUT &H201, 0

 '- main -
 DO
    STICKDATA = INP(&H201)
    COUNTER = COUNTER + (1 AND STICKDATA)
 LOOP WHILE (COUNTER < 32767) AND (STICKDATA AND 1)
 FOUNDSTICK = (COUNTER <> 32767)

END SUB

FUNCTION JOYPAD

 '- initialize
 ANGLE = 0

 '- main -
 IF FOUNDSTICK AND CALIBRATEDSTICK THEN
    STICKY = 0: STICKX = 0: DUMMY = 0

    '- calculate stick value -
    OUT &H201, 0
    DO
       STICKDATA = INP(&H201)
       IF STICKDATA AND 1 THEN STICKX = STICKX + 1 ELSE DUMMY = DUMMY + 1
       IF STICKDATA AND 2 THEN STICKY = STICKY + 1 ELSE DUMMY = DUMMY + 1
    LOOP UNTIL ((STICKDATA AND &H1) OR (STICKDATA AND &H2)) = 0

    '- calculate direction (MSX style) -
    ANGLE = 0
    IF STICKY <= STICKU THEN ANGLE = 1
    IF STICKX >= STICKR THEN ANGLE = 3
    IF STICKY >= STICKD THEN ANGLE = 5
    IF STICKX <= STICKL THEN ANGLE = 7
    IF STICKY <= STICKU AND STICKX >= STICKR THEN ANGLE = 2
    IF STICKX >= STICKR AND STICKY >= STICKD THEN ANGLE = 4
    IF STICKX <= STICKL AND STICKY >= STICKD THEN ANGLE = 6
    IF STICKY <= STICKL AND STICKX <= STICKL THEN ANGLE = 8
 END IF

 '- update stick (MSX style) -
 JOYPAD = ANGLE

END FUNCTION

SUB LOADSCREEN (S$, P)
'---------------------------------------------------------------------------'
' S$ = FILENAME (6letters, 2identifier, and 'JSV'extension)                 '
' P  = PAGE (0 - 7)                                                         '
'---------------------------------------------------------------------------'

 TEMP$ = RIGHT$(S$, 6)                    'filename : 6letter + 2code

 DEF SEG = &HA000 + (&H200 * (P MOD 8))   'select page

 OUT &H3C4, &H2                           'Sequencer register
                                          '(The color plane write
                                          'enable register)
 FOR I = 0 TO 3
    OUT &H3C5, 2 ^ I                      'select plane I for writing
    BLOAD GRAPHICPATH$ + TEMP$ + "-" + LTRIM$(STR$(I)) + ".JSV", 0
 NEXT

 OUT &H3C5, &HF                           'set all plane for other functions

 DEF SEG

END SUB

SUB MAIN

 SCREEN , , BACKGROUNDPAGE, VISPAGE
 LINE (0, 0)-(319, 199), 14, BF
 LINE (0, 129)-(319, 129), 3, B
 LINE (0, 130)-(319, 131), 2, B
 LINE (0, 132)-(319, 132), 12, B

 PSETSTICK 10, 140, 0, 0, BACKGROUNDPAGE

 DRAWMSXFONT 8 * 1, 8 * 1, 1, 0, 0, "JOY-PAD MOTION DETECTION Ver 0.1 beta 97-2-24"
 DRAWMSXFONT 8 * 5, 8 * 2, 1, 0, 1, "Copyright (c) Jaws-V soft, 1997."

 DRAWMSXFONT 8 * 8, 8 * 18, 1, 0, 1, " KEY LIST FOR NON-JOYPAD USER"
 DRAWMSXFONT 8 * 8, 8 * 19, 1, 0, 1, "0:PUNCH"
 DRAWMSXFONT 8 * 8, 8 * 20, 1, 0, 1, "1:OVERHEAD KICK"
 DRAWMSXFONT 8 * 8, 8 * 21, 1, 0, 1, "2:HADOKEN   ( D DF F + PUNCH )"
 DRAWMSXFONT 8 * 8, 8 * 22, 1, 0, 1, "3:SHORYUKEN ( F D DF + PUNCH )"

'DRAWMSXFONT 8 * 1, 8 * 24, 1, 0, 1, "YOU CAN NOT USE THESE GRAPHICS IN YOUR GAME!"

 PCOPY BACKGROUNDPAGE, AUXPAGE
 PSETKEN 100, 100, 0, AUXPAGE

 SCREEN , , VISPAGE, VISPAGE
 PCOPY AUXPAGE, VISPAGE
 FADE 1

 KENX = 100
 KENY = 100

 BUFFER$ = ""
 S = 0
 CONTROL = TRUE
 ACTION = -1

 DO
   OLDS = S
   S = JOYPAD
   S$ = INKEY$

   IF CONTROL THEN
     IF S <> (OLDS MOD 10) THEN      '- new dir -
       HOLD = 0
       CHARGE = 0
     ELSE
       HOLD = HOLD + 1
       IF HOLD MOD 5 = 0 THEN CHARGE = CHARGE + 1 + (CHARGE = 3)
     END IF

     S = S + CHARGE * 10

     IF S <> OLDS AND S <> 0 THEN       '- update buffer -
       ' 3-5
       IF (S = 3 AND RIGHT$(BUFFER$, 1) = "5") OR (S = 5 AND RIGHT$(BUFFER$, 1) = "3") THEN
         BUFFER$ = RIGHT$(BUFFER$ + "04", 30)
       END IF
       ' 5-7
       IF (S = 5 AND RIGHT$(BUFFER$, 1) = "7") OR (S = 7 AND RIGHT$(BUFFER$, 1) = "5") THEN
         BUFFER$ = RIGHT$(BUFFER$ + "06", 30)
       END IF
       BUFFER$ = RIGHT$(BUFFER$ + RIGHT$("0" + LTRIM$(STR$(S)), 2), 30)
     END IF

     IF BUTTON(1) = 0 THEN HOLDBUTTON = FALSE
  
     IF BUTTON(1) AND NOT HOLDBUTTON THEN
       HOLDBUTTON = TRUE

       BUFFER$ = RIGHT$(BUFFER$ + " P", 30)
       IF (RIGHT$(BUFFER$, 9 + 2) = "304050403 P") THEN     '- shoryuken #1 -
         SHORYUKEN = SHORYUKEN + 1 + (SHORYUKEN = 1)
       ELSEIF (RIGHT$(BUFFER$, 7 + 2) = "3040504 P") THEN   '- shoryuken #2 -
         SHORYUKEN = SHORYUKEN + 1 + (SHORYUKEN = 1)
       ELSEIF (RIGHT$(BUFFER$, 7 + 2) = "4050403 P") THEN   '- shoryuken #3 -
         SHORYUKEN = SHORYUKEN + 1 + (SHORYUKEN = 1)
       ELSEIF (RIGHT$(BUFFER$, 5 + 2) = "40504 P") THEN     '- shoryuken #4 -
         SHORYUKEN = SHORYUKEN + 1 + (SHORYUKEN = 1)
       ELSEIF (RIGHT$(BUFFER$, 5 + 2) = "30403 P") THEN     '- shoryuken #5 -
         SHORYUKEN = SHORYUKEN + 1 + (SHORYUKEN = 1)
       ELSEIF (RIGHT$(BUFFER$, 5 + 2) = "50403 P") THEN     '- hadoken #1 -
         IF HADO THEN PUNCH = 1 ELSE HADOKEN = HADOKEN + 1 + (HADOKEN = 1)
       ELSEIF (RIGHT$(BUFFER$, 3 + 2) = "403 P") THEN       '- hadoken #2 -
         IF HADO THEN PUNCH = 1 ELSE HADOKEN = HADOKEN + 1 + (HADOKEN = 1)
       ELSEIF (RIGHT$(BUFFER$, 3 + 2) = "504 P") THEN       '- hadoken #3 -
         IF HADO THEN PUNCH = 1 ELSE HADOKEN = HADOKEN + 1 + (HADOKEN = 1)
       ELSE                                                 '- xxx = punch -
         PUNCH = 1
       END IF
     END IF
   END IF
                   
   IF (BUTTON(2) OR BUTTON(3)) AND NOT HOLDBUTTON THEN
     HOLDBUTTON = TRUE
     KICK = 1
     BUFFER$ = RIGHT$(BUFFER$ + " K", 30)
   END IF

   IF S$ = "0" THEN PUNCH = 1
   IF S$ = "1" THEN KICK = 1
   IF S$ = "2" THEN IF HADO THEN PUNCH = 1 ELSE HADOKEN = HADOKEN + 1 + (HADOKEN = 1)
   IF S$ = "3" THEN SHORYUKEN = SHORYUKEN + 1 + (SHORYUKEN = 1)

   IF HADO THEN HADOKEN = 0

   IF ACTION = -1 THEN
     IF SHORYUKEN <> 0 THEN
       SHORYUKEN = SHORYUKEN - 1
       CONTROL = FALSE
       ACTION = 2
       ACTIONPTN = 0
       PUNCH = 0
     ELSEIF HADOKEN <> 0 AND NOT HADO THEN  'while wave is not on screen
       HADOKEN = HADOKEN - 1
       CONTROL = FALSE
       ACTION = 1
       ACTIONPTN = 0
       PUNCH = 0
     ELSEIF PUNCH <> 0 THEN
       PUNCH = 0
       CONTROL = FALSE
       ACTION = 0
       ACTIONPTN = 0
     ELSEIF KICK <> 0 THEN
       KICK = 0
       CONTROL = FALSE
       ACTION = 3
       ACTIONPTN = 0
     END IF
   END IF

   PCOPY BACKGROUNDPAGE, AUXPAGE
   PSETKEN KENX, KENY, 0, AUXPAGE
 
   IF ACTION <> -1 THEN
     ACTIONPTN = ACTIONPTN + 1
   
     IF ACTIONPTN = 12 AND ACTION = 1 THEN '- hadoken (wave) -
       HADO = TRUE
       HADOX = KENX + 11
       HADOY = KENY + 15
       HADOPTN = 0
       HADOTIMER = 30
     END IF
   
     PCOPY BACKGROUNDPAGE, AUXPAGE
     PSETKEN KENX, KENY, KENPTN(ACTIONPTN, ACTION), AUXPAGE
   
     IF ACTIONPTN >= KENPTN(0, ACTION) - 8 THEN CONTROL = TRUE
     IF ACTIONPTN >= KENPTN(0, ACTION) THEN
       ACTION = -1
       ACTIONPTN = 0
     END IF

   END IF
   
   IF HADO THEN
     HADOTIMER = HADOTIMER - 1
     IF HADOTIMER <= 0 THEN HADO = FALSE
     HADOX = HADOX + 4
     HADOPTN = (HADOPTN + 1) MOD 2
     TPSETHADOKEN HADOX, HADOY, HADOPTN, AUXPAGE
   END IF
 
   PSETSTICK 10, 140, (S MOD 10), (S \ 10), AUXPAGE
 
   SCREEN , , VISPAGE, VISPAGE
   PCOPY AUXPAGE, VISPAGE

   DELAY 1

 LOOP UNTIL S$ = CHR$(27)

 FADE 0
 CLS
 FADE 1

END SUB

SUB MSXCOLOR

 '- set NEW color -
 OUT &H3C8, 0
 FOR I = 0 TO 23
   OUT &H3C9, VAL(MID$("250009270918451800000000000000006363545509544563", I * 2 + 1, 2))
   OUT &H3C9, VAL(MID$("260054630927095400000000000000000921545436184563", I * 2 + 1, 2))
   OUT &H3C9, VAL(MID$("270009276363096300000000000000000921093609454563", I * 2 + 1, 2))
 NEXT

END SUB

SUB PSETARROW (X, Y, N, P)

 SCREEN , , 2, VISPAGE
 XX = (N MOD 9)
 YY = (N \ 9)
 GET (XX * 12 + 1, YY * 12 + 1)-(XX * 12 + 11, YY * 12 + 11), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVDATA, PSET

END SUB

SUB PSETKEN (X, Y, N, P)

 SCREEN , , 1, VISPAGE
 XX = (N MOD 10)
 YY = (N \ 10)
 GET (XX * 23 + 1, YY * 34 + 1)-(XX * 23 + 22, YY * 34 + 33), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVDATA, PSET

END SUB

SUB PSETSTICK (X, Y, N, c, P)

 SCREEN , , 3, VISPAGE
 GET (1, 1)-(1 + 44, 1 + 44), FMVDATA
 SCREEN , , P, VISPAGE
 LINE (X, Y)-(X + 46, Y + 46), 15, B
 PUT (X + 1, Y + 1), FMVDATA, PSET

 SELECT CASE N
 CASE IS = 0: PSETARROW X + 17 + 1, Y + 17 + 1, 9, P
 CASE IS = 1: PSETARROW X + 17 + 1, Y + 0 + 1, 10 + c * 9, P
 CASE IS = 2: PSETARROW X + 28 + 1, Y + 6 + 1, 11 + c * 9, P
 CASE IS = 3: PSETARROW X + 34 + 1, Y + 17 + 1, 12 + c * 9, P
 CASE IS = 4: PSETARROW X + 28 + 1, Y + 28 + 1, 13 + c * 9, P
 CASE IS = 5: PSETARROW X + 17 + 1, Y + 34 + 1, 14 + c * 9, P
 CASE IS = 6: PSETARROW X + 6 + 1, Y + 28 + 1, 15 + c * 9, P
 CASE IS = 7: PSETARROW X + 0 + 1, Y + 17 + 1, 16 + c * 9, P
 CASE IS = 8: PSETARROW X + 6 + 1, Y + 6 + 1, 17 + c * 9, P
 END SELECT

END SUB

SUB TPSETHADOKEN (X, Y, N, P)

 XXX = 47
 SCREEN , , 1, VISPAGE
 GET (0 * 13 + 161 + XXX, N * 12 + 35)-(0 * 13 + 172 + XXX, N * 12 + 45), FMVDATA
 GET (1 * 13 + 161 + XXX, N * 12 + 35)-(1 * 13 + 172 + XXX, N * 12 + 45), FMVMASK
 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVMASK, AND
 PUT (X, Y), FMVDATA, OR

END SUB

