'
' PARALLAX SCROLL DEMO for MODE 07
'
' Copyright (c) Jaws-V soft, 1997.
'
' This demo uses MSX palette.
' It is pretty slow, because It calculates plane/shift while scrolling.
' (4 times more work[memory copy] than screen 13)
'
' send comment to: CHANGE V@aol.com
'

DEFINT A-Z

DECLARE SUB ChangeVCopy (SSEG, SPTR, TSEG, TPTR, size)
DECLARE SUB InitCode ()
DECLARE SUB InitGlobal ()
DECLARE SUB InitGraphic ()
DECLARE SUB LoadScreen (S$, p)
DECLARE SUB Scroll ()

CONST FALSE = 0
CONST TRUE = NOT FALSE

CONST VISPAGE = 0
CONST TXT1PAGE = 1
CONST TXT2PAGE = 2
CONST TXT3PAGE = 3
CONST AUXPAGE = 7

TYPE PARALLAXTYPE
  YINCSEG  AS INTEGER ' next line of texture map
  BASESEG  AS INTEGER ' texture map address
  SHIFTPTR AS INTEGER ' shift pointer
  BLOCKPTR AS INTEGER ' block pointer
  MAXSHIFT AS INTEGER ' number of shift
  MAXBLOCK AS INTEGER ' number of block
  OFFY     AS INTEGER ' texture map y offset
  MAXY     AS INTEGER ' texture map height
END TYPE

DIM SHARED CodeIsInitialized
DIM SHARED ScrollCode(9)
DIM SHARED EXPTABLE(0 TO 7)
DIM SHARED YSEG(0 TO 47), YOFF(0 TO 47)
DIM SHARED TXTMAP(0 TO 2) AS PARALLAXTYPE

InitGlobal
InitCode
InitGraphic

DO
  Scroll
  WAIT &H3DA, 8
  PCOPY 7, 0
LOOP UNTIL INKEY$ = CHR$(27)

SYSTEM

SUB ChangeVCopy (SSEG, SPTR, TSEG, TPTR, size)

 IF CodeIsInitialized THEN
   DEF SEG = VARSEG(ScrollCode(0))
   OUT &H3CE, 4: OUT &H3CF, 0: OUT &H3C4, 2: OUT &H3C5, 1 'select plane #1
   CALL ABSOLUTE(BYVAL SSEG, BYVAL SPTR, BYVAL TSEG, BYVAL TPTR, BYVAL size, VARPTR(ScrollCode(0)))
   OUT &H3CE, 4: OUT &H3CF, 1: OUT &H3C4, 2: OUT &H3C5, 2 'select plane #2
   CALL ABSOLUTE(BYVAL SSEG, BYVAL SPTR, BYVAL TSEG, BYVAL TPTR, BYVAL size, VARPTR(ScrollCode(0)))
   OUT &H3CE, 4: OUT &H3CF, 2: OUT &H3C4, 2: OUT &H3C5, 4 'select plane #3
   CALL ABSOLUTE(BYVAL SSEG, BYVAL SPTR, BYVAL TSEG, BYVAL TPTR, BYVAL size, VARPTR(ScrollCode(0)))
   OUT &H3CE, 4: OUT &H3CF, 3: OUT &H3C4, 2: OUT &H3C5, 8 'select plane #4
   CALL ABSOLUTE(BYVAL SSEG, BYVAL SPTR, BYVAL TSEG, BYVAL TPTR, BYVAL size, VARPTR(ScrollCode(0)))
   OUT &H3C5, &HF 'reset
   DEF SEG
 ELSE
   CLS : PRINT "Fatal Error": END
 END IF

END SUB

SUB InitCode

 ScrollCode$ = "1E5589E58B4E08C47E0AC5760EF3A55D1FCA0800"
 DEF SEG = VARSEG(ScrollCode(0))
 FOR I = 0 TO 19
   POKE VARPTR(ScrollCode(0)) + I, VAL("&H" + MID$(ScrollCode$, I * 2 + 1, 2))
 NEXT
 DEF SEG
 CodeIsInitialized = TRUE

END SUB

SUB InitGlobal

 '- initialize global table -
 FOR I = 0 TO 7
   EXPTABLE(I) = 2 ^ I
 NEXT

 FOR I = 0 TO 47
   YSEG(I) = &H17C + (I \ 2) * 5
   YOFF(I) = (I MOD 2) * &H28
 NEXT

 TXTMAP(0).YINCSEG = &H28
 TXTMAP(0).BASESEG = &HA200
 TXTMAP(0).SHIFTPTR = 0
 TXTMAP(0).BLOCKPTR = 0
 TXTMAP(0).MAXSHIFT = 8
 TXTMAP(0).MAXBLOCK = 4
 TXTMAP(0).OFFY = 0
 TXTMAP(0).MAXY = 7

 TXTMAP(1).YINCSEG = &H14
 TXTMAP(1).BASESEG = &HA400
 TXTMAP(1).SHIFTPTR = 0
 TXTMAP(1).BLOCKPTR = 0
 TXTMAP(1).MAXSHIFT = 4
 TXTMAP(1).MAXBLOCK = 8
 TXTMAP(1).OFFY = 8
 TXTMAP(1).MAXY = 15

 TXTMAP(2).YINCSEG = &HA
 TXTMAP(2).BASESEG = &HA600
 TXTMAP(2).SHIFTPTR = 0
 TXTMAP(2).BLOCKPTR = 0
 TXTMAP(2).MAXSHIFT = 2
 TXTMAP(2).MAXBLOCK = 12
 TXTMAP(2).OFFY = 24
 TXTMAP(2).MAXY = 23

END SUB

SUB InitGraphic

 SCREEN 7
 LoadScreen "bg1", 1
 LoadScreen "bg2", 2
 LoadScreen "bg3", 3

 SCREEN , , 7, 0
 LINE (0, 0)-(319, 199), 7, BF
 LOCATE 1, 1: PRINT " SIMPLE PARALLAX LINESCROLL TEST -SYNC- ";
 LOCATE 2, 1: PRINT " (pretty slow... not good for shooter)  ";
 LOCATE 3, 1: PRINT "       PRESS [ESC] KEY TO QUIT          ";
'LOCATE 4, 1: PRINT " send any comment to: CHANGEV@aol.com   ";

 SCREEN , , 0, 0

END SUB

SUB LoadScreen (S$, p)
'---------------------------------------------------------------------------'
' S$ = FILENAME (6letters, 2identifier, and 'JSV'extension)                 '
' P  = PAGE (0 - 7)                                                         '
'---------------------------------------------------------------------------'

 TEMP$ = LTRIM$(RTRIM$(LEFT$(S$, 6)))     'filename : 6letter + 2code

 DEF SEG = &HA000 + (&H200 * (p MOD 8))   'select page

 OUT &H3C4, &H2                           'Sequencer register
                                          '(The color plane write
                                          'enable register)
 FOR I = 0 TO 3
    OUT &H3C5, 2 ^ I                      'select plane I for writing
    BLOAD GRAPHICPATH$ + TEMP$ + "-" + LTRIM$(STR$(I)) + ".JSV", 0
 NEXT

 OUT &H3C5, &HF                           'set all plane for other functions

 DEF SEG

'-< load palette >-
 OPEN GRAPHICPATH$ + TEMP$ + "-P.JSV" FOR INPUT AS #1
 INPUT #1, PAL$
 CLOSE #1

 OUT &H3C8, 0
 FOR I = 0 TO 7
    OUT &H3C9, VAL("&H" + MID$(PAL$, I * 6 + 1, 2)) \ 4
    OUT &H3C9, VAL("&H" + MID$(PAL$, I * 6 + 3, 2)) \ 4
    OUT &H3C9, VAL("&H" + MID$(PAL$, I * 6 + 5, 2)) \ 4
 NEXT

 OUT &H3C8, 16
 FOR I = 8 TO 15
    OUT &H3C9, VAL("&H" + MID$(PAL$, I * 6 + 1, 2)) \ 4
    OUT &H3C9, VAL("&H" + MID$(PAL$, I * 6 + 3, 2)) \ 4
    OUT &H3C9, VAL("&H" + MID$(PAL$, I * 6 + 5, 2)) \ 4
 NEXT


END SUB

SUB Scroll

 TARGETSEG = &HAE00 ' 7 page
 TARGETOFF = 0
 SOURCEOFF = 0

 SOURCESEG = TXTMAP(0).BASESEG
 TXTMAP(0).SHIFTPTR = (TXTMAP(0).SHIFTPTR + 1) MOD TXTMAP(0).MAXSHIFT
 IF (TXTMAP(0).SHIFTPTR = 0) THEN TXTMAP(0).BLOCKPTR = (TXTMAP(0).BLOCKPTR + 1) MOD TXTMAP(0).MAXBLOCK
 FOR I = 0 TO TXTMAP(0).MAXY
   ChangeVCopy SOURCESEG + TXTMAP(0).YINCSEG * I, SOURCEOFF + TXTMAP(0).SHIFTPTR * 80 + TXTMAP(0).BLOCKPTR, TARGETSEG + YSEG(I + TXTMAP(0).OFFY), TARGETOFF + YOFF(I + TXTMAP(0).OFFY), 20
 NEXT

 SOURCESEG = TXTMAP(1).BASESEG
 TXTMAP(1).SHIFTPTR = (TXTMAP(1).SHIFTPTR + 1) MOD TXTMAP(1).MAXSHIFT
 IF (TXTMAP(1).SHIFTPTR = 0) THEN TXTMAP(1).BLOCKPTR = (TXTMAP(1).BLOCKPTR + 1) MOD TXTMAP(1).MAXBLOCK
 FOR I = 0 TO TXTMAP(1).MAXY
   ChangeVCopy SOURCESEG + TXTMAP(1).YINCSEG * I, SOURCEOFF + TXTMAP(1).SHIFTPTR * 80 + TXTMAP(1).BLOCKPTR, TARGETSEG + YSEG(I + TXTMAP(1).OFFY), TARGETOFF + YOFF(I + TXTMAP(1).OFFY), 20
 NEXT

 SOURCESEG = TXTMAP(2).BASESEG
 TXTMAP(2).SHIFTPTR = (TXTMAP(2).SHIFTPTR + 1) MOD TXTMAP(2).MAXSHIFT
 IF (TXTMAP(2).SHIFTPTR = 0) THEN TXTMAP(2).BLOCKPTR = (TXTMAP(2).BLOCKPTR + 1) MOD TXTMAP(2).MAXBLOCK
 FOR I = 0 TO TXTMAP(2).MAXY
   ChangeVCopy SOURCESEG + TXTMAP(2).YINCSEG * I, SOURCEOFF + TXTMAP(2).SHIFTPTR * 80 + TXTMAP(2).BLOCKPTR, TARGETSEG + YSEG(I + TXTMAP(2).OFFY), TARGETOFF + YOFF(I + TXTMAP(2).OFFY), 20
 NEXT

END SUB

