' Mini RPG III Ver 1.3
' Copyright (c) Jaws-V soft, 1997.
'
' send comment to: CHANGEV@aol.com
'
'  finished(unoptimized) 8-13-97 WED, 10:51pm
'
'  - updated & optimized(for size of code) -
'
'  1st optimized       : 8-31-97 SUN 02:06am
'  last-minute-update  : 8-31-97 SUN 10:50pm
'  2nd optimized       : 8-31-97 SUN 11:28pm
'  3rd optimized       : 9-22-97 MON 02:45pm

DEFINT A-Z

DECLARE SUB BATTLE (ENEMYNUM, BATTLERESULT)
DECLARE SUB BATTLEMENU (CHOICE, SIDE)
DECLARE SUB BTLOFF (N)
DECLARE SUB BTLON ()
DECLARE SUB CHECKEVENT (GROUND, BATTLERESULT)
DECLARE SUB CHV (N)
DECLARE SUB CHVACTION (N, ENEMYNUM)
DECLARE SUB CLEARBUFFER ()
DECLARE SUB CLOUD (X, Y, N, P)
DECLARE SUB CLRSCR (P)
DECLARE SUB COPYPANEL (N, PATCH)
DECLARE SUB DELAY (P)
DECLARE SUB DEMO1 ()
DECLARE SUB DEMO2 ()
DECLARE SUB DRAWBATTLEINFO (ENEMYNUM)
DECLARE SUB DRAWFONT (X, Y, C1, C2, S, S$)
DECLARE SUB DRAWFRAME (N)
DECLARE SUB DRAWMAINMENU (N, P)
DECLARE SUB DRAWMAP ()
DECLARE SUB DRAWSCRIPT (X, Y, N, L)
DECLARE SUB DRAWSTATUS (X, Y, N, SIDE, P)
DECLARE SUB DRAWSUBMENU (N)
DECLARE SUB ENEMYATTACK (CHOICE, ENEMYNUM, BATTLERESULT)
DECLARE SUB EVENTBATTLE (N, BATTLERESULT)
DECLARE SUB EVENTOPEN (N)
DECLARE SUB FADE (P)
DECLARE SUB FIRSTATTACK (ENEMYNUM, SIDE)
DECLARE SUB GETKEY (KEY$)
DECLARE SUB INITDATA ()
DECLARE SUB INITENEMYDATA (N)
DECLARE SUB INITFILE ()
DECLARE SUB INITGRAPHIC ()
DECLARE SUB INITMAINVARIABLE ()
DECLARE SUB INTRO ()
DECLARE SUB LOADDATA ()
DECLARE SUB LOADMAP ()
DECLARE SUB LOADSCREEN (S$, P)
DECLARE SUB LOADTITLEGRP ()
DECLARE SUB LOGO ()
DECLARE SUB MAIN (EXITRESULT)
DECLARE SUB MAPOFF ()
DECLARE SUB MAPON ()
DECLARE SUB MIDDEMO (N)
DECLARE SUB MIDMESSAGE (MSG$)
DECLARE SUB NEWCOLOR ()
DECLARE SUB NUMBERFX (X, Y, NUM, PTN, P)
DECLARE SUB PSETCHAR (X, Y, N, SOURCEPAGE, TARGETPAGE)
DECLARE SUB PSETCHV (N, P)
DECLARE SUB PSETCURSOR (X, Y, N, P)
DECLARE SUB PSETFLAG (N)
DECLARE SUB PSETHEAD (N, P)
DECLARE SUB PSETJSVSOFT (N, P)
DECLARE SUB PSETNAME (X, Y, N, P)
DECLARE SUB PSETPANEL (N, L, P)
DECLARE SUB PSETPATCH (X, Y, N, P)
DECLARE SUB PSETSTAFF (STAFF, N, P)
DECLARE SUB RAINBOWFX ()
DECLARE SUB RANDOMBATTLE (RESULT)
DECLARE SUB ROMACTION (N)
DECLARE SUB ROMATTACK (ENEMYNUM, BATTLERESULT)
DECLARE SUB SAVEDATA ()
DECLARE SUB SCROLLTEXT (X, Y)
DECLARE SUB SETROMPOS (N)
DECLARE SUB STATUSFX (N)
DECLARE SUB SUBMENU (RESULT)
DECLARE SUB SWAPTURN (CHOICE, ENEMYNUM, SIDE)
DECLARE SUB TALK (N)
DECLARE SUB TITLE ()
DECLARE SUB TITLEFX ()
DECLARE SUB TITLEOPEN (N, CHOICE)
DECLARE SUB TPSETBIGCOOKIE (X, Y, L, N, P)
DECLARE SUB TPSETROM (X, Y, N, P)
DECLARE SUB TPSETSMALLCOOKIE (X, Y, L, N, P)
DECLARE SUB TPSETSPARK (X, Y, OBJ, N, P)
DECLARE SUB TPSETWEAPON (X, Y, N, TYP, P)
DECLARE SUB TPSETZZZ (X, Y, N, DIR, P)
DECLARE SUB UPDATEHPBAR (HP, SIDE, P)

CONST FALSE = 0
CONST TRUE = NOT FALSE

CONST DRIVE$ = "C:"
CONST DATAPATH$ = ""
CONST GRAPHICPATH$ = ""
CONST FONTNAME$ = "NEWFONT.FNT"

CONST VISPAGE = 0
CONST ROMPAGE = 1
CONST ENEMYPAGE = 2: CONST MISC2PAGE = 2
CONST MISCPAGE = 3
CONST MAPPAGE = 4: CONST FMVPAGE = 4
CONST PANELPAGE = 5: CONST EXTRAPAGE = 5
CONST LOGOPAGE = 6: CONST BGPAGE = 6
CONST AUXPAGE = 7

CONST COLOR2BLACK = 0
CONST BLACK2COLOR = 1
CONST COLOR2WHITE = 2
CONST WHITE2COLOR = 3

CONST BTLX = 97
CONST BTLY = 47

CONST MAPX = 118
CONST MAPY = 18

CONST BTLROMX = 111
CONST BTLROMY = 65

CONST BTLENEMYX = 177
CONST BTLENEMYY = 65

TYPE CHARACTERINFO
  NAMES    AS STRING * 6
  LEVEL    AS INTEGER
  MAXHP    AS INTEGER
  STRENGTH AS INTEGER
  DEFENSE  AS INTEGER
  LUCK     AS INTEGER
  EXPPOINT AS INTEGER
  FIRST    AS STRING * 7
  SECOND   AS STRING * 7
  THIRD    AS STRING * 7
END TYPE

TYPE PLAYERINFO
  NAMES    AS STRING * 6
  LEVEL    AS INTEGER
  MAXHP    AS INTEGER
  HP       AS INTEGER
  STRENGTH AS INTEGER
  DEFENSE  AS INTEGER
  LUCK     AS INTEGER
  EXPPOINT AS INTEGER
  FIRST    AS STRING * 7
  SECOND   AS STRING * 7
  THIRD    AS STRING * 7
END TYPE

TYPE GAMEINFO
  ROUND      AS INTEGER
  EVENT      AS INTEGER
  GRIDX      AS INTEGER
  GRIDY      AS INTEGER
  MAPSCROLLX AS INTEGER
  MAPSCROLLY AS INTEGER
  MAPROMX    AS INTEGER
  MAPROMY    AS INTEGER
  ROMDIR     AS INTEGER
  NEXTLEVEL  AS INTEGER
  ITEM       AS INTEGER
END TYPE

'- global variable -
COMMON SHARED DEBUG
COMMON SHARED GAMEDATA AS GAMEINFO

REDIM SHARED CHARDATA(0 TO 10) AS CHARACTERINFO
REDIM SHARED PLAYERDATA(0 TO 1) AS PLAYERINFO

REDIM SHARED NEWFONT$(32 TO 126)

REDIM SHARED FMVDATA(1681)
REDIM SHARED FMVMASK(181)

REDIM SHARED GRP(0 TO 21) AS STRING * 6
REDIM SHARED SCRIPT(286) AS STRING * 18

REDIM SHARED FMVPTN(0 TO 23, 0 TO 96)
REDIM SHARED MAPDATA(0 TO 23, 0 TO 17)

'- main -
INITMAINVARIABLE
INITGRAPHIC

LOGO
TITLE
SYSTEM

SUB BATTLE (ENEMYNUM, BATTLERESULT)

 GAMEDATA.ROUND = GAMEDATA.ROUND + 1

 '- output windows -
 DRAWBATTLEINFO ENEMYNUM
 DELAY 18

 '- output round -
 CHVACTION 0, ENEMYNUM

 SIDE = 0
 CHOICE = 0

 ATTACKRESULT = 0 '- attack info -
 BATTLERESULT = 0 '- battle info -

 FIRSTATTACK ENEMYNUM, SIDE

 DO
   BATTLEMENU CHOICE, SIDE

   SELECT CASE SIDE
   '- rom side -
   CASE IS = 0
     SELECT CASE CHOICE
     CASE IS = 0 '- attack -
       ROMATTACK ENEMYNUM, BATTLERESULT

     CASE IS = 1 '- drink -
       '- drink animation start -
       ROMACTION 1

     CASE IS = 2 '- run -
       IF ENEMYNUM > 6 THEN
         '- "can't run from boss" -
         CHVACTION 5, ENEMYNUM
       ELSEIF (RND * 100 < 30 + (RND * 10 - 5) + PLAYERDATA(0).LUCK) THEN
         BATTLERESULT = 2
         '- run animation start -
         ROMACTION 0
       ELSE
         CHVACTION 4, ENEMYNUM
       END IF
     END SELECT

   '- enemy side -
   CASE IS = 1
     SELECT CASE CHOICE
     CASE IS = 0, 1 '- attack -
       ENEMYATTACK CHOICE, ENEMYNUM, BATTLERESULT

     CASE IS = 2    '- talk -
       TALK 113 + ENEMYNUM: DELAY 18
     END SELECT

   END SELECT

   IF BATTLERESULT = 0 THEN SWAPTURN CHOICE, ENEMYNUM, SIDE

 LOOP UNTIL BATTLERESULT > 0

 '- CHANGE V -
 CHVACTION BATTLERESULT, ENEMYNUM

 DELAY 9

 IF BATTLERESULT = 3 THEN
   PSETCHAR BTLROMX, BTLROMY, 8, ROMPAGE, BGPAGE
   PCOPY BGPAGE, VISPAGE

   X = BTLX - 5: Y = BTLY
   CLOUD X, Y, 40, 3
   DRAWFONT X + 4, Y + 4, 1, 15, 1, "  I'm dead now.   "
   DRAWFONT X + 4, Y + 16, 1, 15, 1, "  Go away.        "
   DELAY 27
   SCROLLTEXT X, Y
   SCROLLTEXT X, Y
   DELAY 18
   DRAWFONT X + 4, Y + 10, 1, 15, 1, " G A M E  O V E R "
   DELAY 36

   PCOPY BGPAGE, VISPAGE

 END IF

END SUB

SUB BATTLEMENU (CHOICE, SIDE)

 CLEARBUFFER

 QUIT = FALSE
 CONTROL = TRUE
 SELECTED = FALSE
 CHOICE = 0
 CURSORY = 0
 CURSORPTN = 1

 COUNTDOWN = 10 + INT(RND * 10)

 '- draw battle menu -
 SCREEN , , BGPAGE, VISPAGE
 LINE (BTLX + 3, BTLY + 70)-(BTLX + 53, BTLY + 100), 14, B
 LINE (BTLX + 3, BTLY + 80)-(BTLX + 53, BTLY + 90), 14, B
 LINE (BTLX + 71, BTLY + 70)-(BTLX + 121, BTLY + 100), 14, B
 LINE (BTLX + 71, BTLY + 80)-(BTLX + 121, BTLY + 90), 14, B

 DO

   IF CONTROL THEN
     IF SIDE = 1 AND NOT DEBUG THEN
       A$ = "*" + MID$("PH", INT(RND * 2) + 1, 1)
       IF CHOICE = 0 THEN A$ = "*P"
       IF CHOICE = 2 THEN A$ = "*H"
       COUNTDOWN = COUNTDOWN - 1
       IF COUNTDOWN = 0 THEN A$ = " "
     ELSE
       GETKEY A$
     END IF

     SELECTED = (A$ = " ") OR (A$ = CHR$(13))

     IF A$ = "*P" AND CHOICE < 2 THEN
       CONTROL = FALSE
       CHOICE = CHOICE + 1
       CURSORMOVE = 5
       CURSORDIR = 2
     END IF
     IF A$ = "*H" AND CHOICE > 0 THEN
       CONTROL = FALSE
       CHOICE = CHOICE - 1
       CURSORMOVE = 5
       CURSORDIR = -2
     END IF
   END IF

   IF CONTROL THEN
     CURSORPTN = 1
     LINE (BTLX + (SIDE * 68) + 3, BTLY + (CHOICE * 10) + 70)-(BTLX + (SIDE * 68) + 53, BTLY + (CHOICE * 10) + 80), 8, B
   ELSE
     CURSORPTN = 0
     LINE (BTLX + (SIDE * 68) + 3, BTLY + 70)-(BTLX + (SIDE * 68) + 53, BTLY + 100), 14, B
     LINE (BTLX + (SIDE * 68) + 3, BTLY + 80)-(BTLX + (SIDE * 68) + 53, BTLY + 90), 14, B
   END IF

   IF CURSORMOVE > 0 THEN
     CURSORMOVE = CURSORMOVE - 1
     CURSORY = CURSORY + CURSORDIR
   ELSE
     CONTROL = TRUE
   END IF

   LINE (BTLX + 56, BTLY + 63)-(BTLX + 68, BTLY + 103), 15, BF
   PSETCURSOR BTLX + 56, BTLY + CURSORY + 63, CURSORPTN + (SIDE * 2), BGPAGE

   PCOPY BGPAGE, VISPAGE

   DELAY 1

 LOOP UNTIL SELECTED

 BOXCOLOR = 8
 FOR I = 1 TO 7
   BOXCOLOR = 22 - BOXCOLOR
   LINE (BTLX + (SIDE * 68) + 3, BTLY + (CHOICE * 10) + 70)-(BTLX + (SIDE * 68) + 53, BTLY + (CHOICE * 10) + 80), BOXCOLOR, B
   PCOPY BGPAGE, VISPAGE
   DELAY 1
 NEXT

END SUB

SUB BTLOFF (N)

 SCREEN , , BGPAGE, VISPAGE

 '- erase border -
 LINE (MAPX + 106, MAPY)-(MAPX + 173, MAPY + 83), 0, BF
 LINE (BTLX, BTLY + 58)-(BTLX + 124, BTLY + 105), 0, BF
 LINE (BTLX, BTLY - 29)-(BTLX + 124, BTLY - 4), 0, BF

 IF N = 1 THEN
   LINE (MAPX - 91, MAPY)-(MAPX - 24, MAPY + 83), 0, BF
 END IF

 LINE (BTLX, BTLY)-(BTLX + 124, BTLY + 54), 0, B
 LINE (BTLX + 1, BTLY + 1)-(BTLX + 123, BTLY + 53), 0, B

 '- erase window -
 FOR I = 0 TO 24 STEP 4
   LINE (BTLX + 2, BTLY + 2 + I)-(BTLX + 122, BTLY + 52 - I), 0, B
   LINE (BTLX + 2, BTLY + 3 + I)-(BTLX + 122, BTLY + 51 - I), 0, B
   LINE (BTLX + 2, BTLY + 4 + I)-(BTLX + 122, BTLY + 50 - I), 0, B
   LINE (BTLX + 2, BTLY + 5 + I)-(BTLX + 122, BTLY + 49 - I), 0, B
   PCOPY BGPAGE, VISPAGE
   DELAY 1
 NEXT

END SUB

SUB BTLON

 '- battle field open -
 FOR I = 0 TO 23 STEP 4
   SCREEN , , BGPAGE, VISPAGE: GET (BTLX + 2, BTLY + 27 + I)-(BTLX + 122, BTLY + 32 + I), FMVDATA
   SCREEN , , VISPAGE, VISPAGE: PUT (BTLX + 2, BTLY + I + 27), FMVDATA, PSET
   SCREEN , , BGPAGE, VISPAGE: GET (BTLX + 2, BTLY + 26 - I)-(BTLX + 122, BTLY + 22 - I), FMVDATA
   SCREEN , , VISPAGE, VISPAGE: PUT (BTLX + 2, BTLY - I + 22), FMVDATA, PSET
   DELAY 1
 NEXT

 PCOPY BGPAGE, VISPAGE

END SUB

SUB CHECKEVENT (GROUND, BATTLERESULT)

 PCOPY AUXPAGE, VISPAGE

 SELECT CASE GROUND
 '- grass -
 CASE IS = 0: IF RND < .04 THEN RANDOMBATTLE BATTLERESULT

 '- house -
 CASE IS = 1:
   ZZZCOUNTER = 0

   FOR I = 0 TO 95
     PCOPY BGPAGE, AUXPAGE
     SCREEN , , AUXPAGE, VISPAGE

     ZZZCOUNTER = ZZZCOUNTER + 1
     ZZZPTN = VAL(MID$("000000001111111122222222233333333333", (ZZZCOUNTER MOD 36) + 1, 1))

     TPSETZZZ MAPX + 47, MAPY + 42, ZZZPTN, 1, AUXPAGE

     PCOPY AUXPAGE, VISPAGE
     DELAY 1
   NEXT

   '- set new rom position -
   SETROMPOS 0

   PLAYERDATA(0).HP = PLAYERDATA(0).MAXHP
   DRAWSTATUS MAPX - 70, MAPY, -1, 0, BGPAGE

 '- cookie shop -
 CASE IS = 2:
   SELECT CASE GAMEDATA.EVENT
   CASE IS = 0
     GAMEDATA.EVENT = 1
     MAPOFF
     STATUSFX 0
     EVENTOPEN 3 '- shop outside -

     MIDDEMO 1 '- nnv talks -
     GAMEDATA.ITEM = TRUE

     DELAY 18
     BTLOFF 0
     STATUSFX 1
     '- set new rom position -
     SETROMPOS 1
     DRAWMAP
   CASE IS = 1
     MAPOFF
     STATUSFX 0
     EVENTOPEN 4 '- shop inside -
     TALK 105: DELAY 18
     TALK 106: DELAY 18

     DELAY 18
     BTLOFF 0
     STATUSFX 1
     '- set new rom position -
     SETROMPOS 1
     DRAWMAP
   CASE IS = 2
     MAPOFF
     STATUSFX 0
     EVENTOPEN 4 '- shop inside -
     MIDDEMO 3 '- candy run -

     EVENTBATTLE 2, BATTLERESULT '- 2nd fight (trig1) -

     IF BATTLERESULT <> 3 THEN
       MIDDEMO 4 '- rom sleeps again -
       BTLOFF 0
       STATUSFX 1
       '- set new rom position -
       SETROMPOS 1
       DRAWMAP
     ELSE
       DELAY 18
       BTLOFF 1
       CLRSCR VISPAGE
     END IF

   CASE IS = 3
     MAPOFF
     STATUSFX 0
     EVENTOPEN 4 '- shop inside -
     TALK 108: DELAY 18
     TALK 109: DELAY 18

     BTLOFF 0
     STATUSFX 1
     '- set new rom position -
     SETROMPOS 1
     DRAWMAP
   CASE IS = 4 '- from car with box -
     GAMEDATA.EVENT = 5
     MAPOFF
     GAMEDATA.ITEM = FALSE '- return the box -
     STATUSFX 0
     EVENTOPEN 5 '- shop inside with box -

     MIDDEMO 6

     BTLOFF 0
     STATUSFX 1
     '- set new rom position -
     SETROMPOS 1
     DRAWMAP

   CASE IS = 5 '- 2 cookies, yikes -
     MAPOFF
     STATUSFX 0

     EVENTOPEN 13 '- shop inside -

     MIDDEMO 7

     BTLOFF 0
     STATUSFX 1
     '- set new rom position -
     SETROMPOS 1
     DRAWMAP
   END SELECT

 '- blue castle -
 CASE IS = 3:
   SELECT CASE GAMEDATA.EVENT
   CASE IS = 1
     MAPOFF
     STATUSFX 0
     MIDDEMO 2 '- dra appear -

     EVENTBATTLE 1, BATTLERESULT '- 1st fight (dra) -

     IF BATTLERESULT <> 3 THEN
       DELAY 18
       GAMEDATA.ITEM = FALSE
       BTLOFF 0
       STATUSFX 1
       '- set new rom position -
       SETROMPOS 2
       DRAWMAP
     ELSE
       DELAY 18
       BTLOFF 1
       CLRSCR VISPAGE
     END IF

   CASE ELSE
     MAPOFF
     STATUSFX 0
     EVENTOPEN 1

     DELAY 18
     BTLOFF 0
     STATUSFX 1
     '- set new rom position -
     SETROMPOS 2
     DRAWMAP

   END SELECT

 '- car -
 CASE IS = 4:
   SELECT CASE GAMEDATA.EVENT
   CASE IS = 3
     MAPOFF
     STATUSFX 0
     EVENTOPEN 10 '- car with box -

     MIDDEMO 5 '- chv talk #1 -

     EVENTBATTLE 3, BATTLERESULT '- 3rd fight (trig2) -

     IF BATTLERESULT <> 3 THEN

       GAMEDATA.ITEM = TRUE

       DELAY 18
       BTLOFF 0
       STATUSFX 1
       '- set new rom position -
       SETROMPOS 3
       DRAWMAP
     ELSE
       DELAY 18
       BTLOFF 1
       CLRSCR VISPAGE
     END IF

   CASE IS = 4
     MAPOFF
     STATUSFX 0
     EVENTOPEN 11 '- car without box -

     TALK 110: DELAY 18
     TALK 111: DELAY 18

     BTLOFF 0
     STATUSFX 1
     '- set new rom position -
     SETROMPOS 3
     DRAWMAP
   CASE ELSE
      IF RND < .04 THEN RANDOMBATTLE BATTLERESULT
   END SELECT

 '- red castle -
 CASE IS = 5
   SELECT CASE GAMEDATA.EVENT
   CASE IS = 5
     MAPOFF
     STATUSFX 0
     EVENTOPEN 12  '- red castle -

     MIDDEMO 8
     EVENTBATTLE 4, BATTLERESULT '- 4th fight (skull) -

     IF BATTLERESULT <> 3 THEN
       MIDDEMO 9
       MIDDEMO 10
       BATTLERESULT = 4
     ELSE
       DELAY 18
       BTLOFF 1
       CLRSCR VISPAGE
     END IF
   CASE ELSE
      IF RND < .04 THEN RANDOMBATTLE BATTLERESULT
   END SELECT

 END SELECT

 CLEARBUFFER

END SUB

SUB CHV (N)

 SELECT CASE N
 CASE IS = 1: P$ = "03012"
 CASE IS = 2: P$ = "132100033333345"
 CASE IS = 3: P$ = "15210003333334556"
 CASE IS = 4: P$ = "15210003333334557"
 CASE IS = 5: P$ = "105433300012"
 CASE IS = 6: P$ = "03210"
 CASE IS = 7: P$ = "2321000333333455565756575"
 CASE IS = 8: P$ = "100333333455"
 END SELECT

 FOR I = 1 TO VAL(LEFT$(P$, 2))
   PSETCHV VAL(MID$(P$, I + 2, 1)), BGPAGE
   PCOPY BGPAGE, VISPAGE
   DELAY 1
 NEXT

END SUB

SUB CHVACTION (N, ENEMYNUM)

 IF ENEMYNUM = 9 THEN

   CHVX = BTLX - 4
   CHVY = BTLY + 28

   IF N = 3 THEN
     SIDE = 0
     FOR I = 0 TO 5
       PSETHEAD VAL(MID$("2211001122", I + (SIDE * 4) + 1, 1)), BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT
     DELAY 18
   END IF
 ELSE
   CHV 8: DELAY 9
   CHVX = BTLX - 4
   CHVY = BTLY + 4
 END IF

 IF ENEMYNUM = 9 THEN
   CLOUD CHVX, CHVY, 37, 1
 ELSE
   CLOUD CHVX, CHVY, 58, 1
 END IF

 SELECT CASE N
 CASE IS = 0
   IF ENEMYNUM = 10 THEN
     MSG1$ = "    FINAL ROUND"
   ELSEIF GAMEDATA.ROUND >= 1000 THEN
     MSG1$ = "     ROUND 999+"
   ELSE
     MSG1$ = "     ROUND" + STR$(GAMEDATA.ROUND)
   END IF
   MSG2$ = "       FIGHT"
 CASE IS = 1
   MSG1$ = "       Y O U"
   MSG2$ = "       W I N"
 CASE IS = 2
   MSG1$ = "      D R A W"
   MSG2$ = ""
 CASE IS = 3
   MSG1$ = "       Y O U"
   MSG2$ = "      L O S E"
 CASE IS = 4
   MSG1$ = "  YOU CAN NOT RUN"
   MSG2$ = "    (TRY AGAIN)"
 CASE IS = 5
   MSG1$ = "  YOU CAN NOT RUN"
   MSG2$ = " FROM THIS BATTLE"
 END SELECT

 DRAWFONT CHVX + 4, CHVY + 4, 1, 15, 1, MSG1$
 DRAWFONT CHVX + 4, CHVY + 16, 1, 15, 1, MSG2$

 DELAY 9

 '- check level up -
 IF N = 1 THEN
   FOR I = 1 TO PLAYERDATA(1).EXPPOINT

     PLAYERDATA(0).EXPPOINT = PLAYERDATA(0).EXPPOINT + 1
     PLAYERDATA(1).EXPPOINT = PLAYERDATA(1).EXPPOINT - 1
     DRAWSTATUS MAPX - 91, MAPY, 7, 0, VISPAGE
     DRAWSTATUS MAPX + 106, MAPY, 7, 1, VISPAGE
     DELAY 1

     IF PLAYERDATA(0).EXPPOINT = GAMEDATA.NEXTLEVEL THEN
       PLAYERDATA(0).LEVEL = PLAYERDATA(0).LEVEL + 1 + (PLAYERDATA(0).LEVEL = 100)
       PLAYERDATA(0).EXPPOINT = 0
       GAMEDATA.NEXTLEVEL = GAMEDATA.NEXTLEVEL + 1 + (GAMEDATA.NEXTLEVEL = 30)

       SCROLLTEXT CHVX, CHVY
       DRAWFONT CHVX + 4, CHVY + 16, 1, 15, 1, "    LEVEL UP !!"

       DRAWSTATUS MAPX - 91, MAPY, 0, 0, VISPAGE '- level up -

       IF PLAYERDATA(0).MAXHP < 200 THEN
         PLAYERDATA(0).MAXHP = PLAYERDATA(0).MAXHP + INT(RND * 3) + 5
         IF PLAYERDATA(0).MAXHP >= 200 THEN PLAYERDATA(0).MAXHP = 200
         DRAWSTATUS MAPX - 91, MAPY, 2, 0, VISPAGE '- max hp up -
       END IF

       IF PLAYERDATA(0).STRENGTH < 50 THEN
         PLAYERDATA(0).STRENGTH = PLAYERDATA(0).STRENGTH + INT(RND * 2) + 1
         IF PLAYERDATA(0).STRENGTH >= 50 THEN PLAYERDATA(0).STRENGTH = 50
         DRAWSTATUS MAPX - 91, MAPY, 3, 0, VISPAGE '- strength up -
       END IF

       IF PLAYERDATA(0).DEFENSE < 40 THEN
         PLAYERDATA(0).DEFENSE = PLAYERDATA(0).DEFENSE + INT(RND * 2) + 1
         IF PLAYERDATA(0).DEFENSE >= 40 THEN PLAYERDATA(0).DEFENSE = 40
         DRAWSTATUS MAPX - 91, MAPY, 4, 0, VISPAGE '- defense up -
       END IF

       IF PLAYERDATA(0).LUCK < 40 THEN
         PLAYERDATA(0).LUCK = PLAYERDATA(0).LUCK + INT(RND * 2) + 1
         IF PLAYERDATA(0).LUCK >= 40 THEN PLAYERDATA(0).LUCK = 40
         DRAWSTATUS MAPX - 91, MAPY, 5, 0, VISPAGE '- luck up -
       END IF

       DRAWSTATUS MAPX - 91, MAPY, 7, 0, VISPAGE '- next -
       DELAY 18
     END IF
   NEXT

   DRAWSTATUS MAPX - 91, MAPY, 7, 0, BGPAGE
   DRAWSTATUS MAPX + 106, MAPY, 7, 1, BGPAGE

 END IF

 DRAWSTATUS MAPX - 91, MAPY, -1, 0, BGPAGE

 DELAY 27
 PCOPY BGPAGE, VISPAGE
 DELAY 9

 IF ENEMYNUM <> 9 THEN CHV 5

END SUB

SUB CLEARBUFFER

 DO: LOOP UNTIL INKEY$ = ""

END SUB

SUB CLOUD (X, Y, N, P)

 SCREEN , , VISPAGE, VISPAGE

 DRAW "BM" + STR$(X) + "," + STR$(Y)
 DRAW "C1BR4R125FRFDFD19GDGLGL125HLHUHU19EUEREBL4"
 LINE (X + 1, Y + 4)-(X + 132, Y + 23), 15, B
 LINE (X + 2, Y + 2)-(X + 131, Y + 25), 15, BF
 LINE (X + 4, Y + 1)-(X + 129, Y + 26), 15, B

 SELECT CASE P
 CASE IS = 1
   DRAW "BM" + STR$(X + N) + "," + STR$(Y)
   DRAW "BR5C1EUEUEUENUFDFDFDFBLC15L6ER4UL4ER2UL2EU"
 CASE IS = 2
   DRAW "BM" + STR$(X + N) + "," + STR$(Y)
   DRAW "BR5BD27C1FDFDFDFNDEUEUEUEBLC15L6FR4DL4FR2DL2FD"
 CASE IS = 3
   DRAW "BM" + STR$(X + N) + "," + STR$(Y)
   DRAW "BR14BD27C1G3LG2LG2LNGUEUEU2HBRC15R7GL5DNR4DR2GL2DG"
 CASE IS = 4
   DRAW "BM" + STR$(X + N) + "," + STR$(Y)
   DRAW "BR5BD27C1F3RF2RF2RNFUHUHU2EBLC15L7FR5DNL4DL2FR2DF"
 END SELECT

END SUB

SUB CLRSCR (P)

 SCREEN , , P, VISPAGE
 LINE (0, 0)-(319, 199), 0, BF

END SUB

SUB COPYPANEL (N, PATCH)

 IF N < 6 THEN
   LOADSCREEN GRP(20), PANELPAGE

   SCREEN , , PANELPAGE, VISPAGE

   SELECT CASE PATCH
   '- blue castle patch -
   CASE IS = 1
     GET (21, 157)-(35, 195), FMVDATA
     PUT (215, 56), FMVDATA, PSET

   '- shop cookie box patch -
   CASE IS = 2
     GET (37, 157)-(56, 171), FMVDATA
     PUT (71, 84), FMVDATA, PSET

   '- car cookie box patch -
   CASE IS = 3
     GET (1, 157)-(19, 172), FMVDATA
     PUT (51, 105), FMVDATA, PSET

   '- shop box display patch -
   CASE IS = 4
     GET (58, 157)-(77, 171), FMVDATA
     PUT (65, 54), FMVDATA, PSET
   END SELECT

   PX = N MOD 2
   PY = N \ 2
   SCREEN , , PANELPAGE, VISPAGE
   GET (PX * 122 + 1, PY * 52 + 1)-(PX * 122 + 121, PY * 52 + 51), FMVDATA

 ELSEIF N < 9 THEN
   PY = (N - 6) MOD 3
   SCREEN , , MISCPAGE, VISPAGE
   GET (198, 31 + PY * 52)-(318, 81 + PY * 52), FMVDATA
 ELSEIF N = 9 THEN
   SCREEN , , MISC2PAGE, VISPAGE
   GET (74, 134)-(194, 184), FMVDATA
 ELSEIF N = 10 THEN
   LOADSCREEN GRP(18), MISC2PAGE
   SCREEN , , MISC2PAGE, VISPAGE
   GET (1, 82)-(121, 132), FMVDATA
 END IF

 SCREEN , , BGPAGE, VISPAGE
 PUT (BTLX + 2, BTLY + 2), FMVDATA, PSET

END SUB

SUB DELAY (P)

 STATIC OLDSPEED!

 FOR I = 1 TO P
   DO
     SPEED! = TIMER
   LOOP UNTIL SPEED! <> OLDSPEED!
   OLDSPEED! = SPEED!
 NEXT

END SUB

SUB DEMO1

 '- copy map to bgpage -
 CLRSCR BGPAGE
 DRAWFRAME 0
 SCREEN , , MISC2PAGE, VISPAGE
 GET (57, 1)-(136, 80), FMVDATA
 SCREEN , , BGPAGE, VISPAGE
 PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET
 PCOPY BGPAGE, AUXPAGE

 '- map open -
 TITLEFX

 CLEARBUFFER

 '- animation start -
 COOKIE = FALSE
 ZZZ = FALSE

 LC = 0

 DO
   LC = LC + 1

   '- init fmv (sort by loop counter) -
   IF LC = 20 THEN
     ZZZ = TRUE
     ZZZPTN = 0
   END IF
   IF LC = 65 THEN
     COOKIE = TRUE
     COOKIEX = MAPX + 82
     COOKIEY = MAPY + 60
     COOKICOUNTER = 0
     COOKIECLIP = 0
   END IF

   PCOPY BGPAGE, AUXPAGE

   '- output cel (sort by Z value)-
   IF ZZZ THEN
     ZZZPTN = (ZZZPTN + 1) MOD 20
     TPSETZZZ MAPX + 15, MAPY + 42, VAL(MID$("0011222233", ZZZPTN \ 2 + 1, 1)), 0, AUXPAGE
   END IF

   IF COOKIE THEN
     COOKIECOUNTER = (COOKIECOUNTER + 1) MOD 12
     COOKIEPTN = VAL(MID$("000111000222", COOKIECOUNTER + 1, 1))
     COOKIEX = COOKIEX - 1
     COOKIECLIP = COOKIECLIP + 1
     TPSETSMALLCOOKIE COOKIEX, COOKIEY, COOKIECLIP, COOKIEPTN, AUXPAGE
   END IF

   PCOPY AUXPAGE, VISPAGE

   DELAY 1

 LOOP UNTIL INKEY$ <> "" OR LC = 114

END SUB

SUB DEMO2

 MAPOFF

 '- clear bg, copy back ground -
 CLRSCR BGPAGE
 DRAWFRAME 1 '- draw battle frame -

 COPYPANEL 9, 0

 '- copy char to bg -
 PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
 PSETCHAR BTLENEMYX, BTLENEMYY, FMVPTN(2, 0), ROMPAGE, BGPAGE

 PCOPY BGPAGE, AUXPAGE

 BTLON
 CLEARBUFFER

 '- animation start -
 ROM = FALSE
 NION = FALSE
 ROMWEAPON = FALSE
 SPARK = FALSE

 LC = 0

 ATK2 = 45 + 20

 DO
   LC = LC + 1

   PCOPY BGPAGE, AUXPAGE

   '- init fmv (sort by loop counter) -
   IF LC = 20 OR LC = 23 + ATK2 THEN
     ROM = TRUE
     ROMACT = 2 - (LC <> 20)
     ROMPTN = 0
   END IF

   IF LC = 32 OR LC = 32 + ATK2 THEN
     ROMWEAPON = TRUE
     IF ROMACT = 2 THEN
       ROMWEAPONX = BTLX + 31
       ROMWEAPONY = BTLY + 28
       ROMWEAPONTYP = 0
       ROMWEAPONPTN = 0
       ROMWEAPONLEN = 16
     ELSE
       ROMWEAPONX = BTLX + 23
       ROMWEAPONY = BTLY + 35
       ROMWEAPONTYP = 1
       ROMWEAPONPTN = 0
       ROMWEAPONLEN = 16
     END IF
   END IF

   IF LC = 46 OR LC = 46 + ATK2 THEN
     NION = TRUE
     NIONACT = 53
     NIONPTN = 0
   END IF

   IF LC = 46 OR LC = 46 + ATK2 THEN
     SPARK = TRUE
     SPARKX = BTLX + 87
     SPARKY = BTLY + 28 - (LC <> 46) * 8
     SPARKPTN = -1
   END IF

   '- output cel (sort by Z value)-
   IF ROM THEN
     ROMPTN = ROMPTN + 1
     IF ROMPTN >= FMVPTN(0, ROMACT) THEN ROM = FALSE
     PSETCHAR BTLROMX, BTLROMY, FMVPTN(ROMPTN, ROMACT), ROMPAGE, AUXPAGE
   END IF

   IF NION THEN
     NIONPTN = NIONPTN + 1
     IF NIONPTN >= FMVPTN(0, NIONACT) THEN NION = FALSE
     PSETCHAR BTLENEMYX, BTLENEMYY, FMVPTN(NIONPTN, NIONACT), ROMPAGE, AUXPAGE
   END IF

   IF ROMWEAPON THEN
     ROMWEAPONX = ROMWEAPONX + 4
     ROMWEAPONLEN = ROMWEAPONLEN - 1
     IF ROMWEAPONLEN = 0 THEN ROMWEAPON = FALSE
     IF ROMACT = 3 THEN ROMWEAPONPTN = (LC MOD 4) \ 2
     TPSETWEAPON ROMWEAPONX, ROMWEAPONY, ROMWEAPONPTN, ROMWEAPONTYP, AUXPAGE
   END IF

   IF SPARK THEN
     SPARKPTN = SPARKPTN + 1
     IF SPARKPTN = 3 THEN SPARK = FALSE
     TPSETSPARK SPARKX, SPARKY, 0, SPARKPTN, AUXPAGE
   END IF

   PCOPY AUXPAGE, VISPAGE

   DELAY 1

 LOOP UNTIL INKEY$ <> "" OR LC >= 80 + ATK2

 '- battle field close -
 BTLOFF 0

END SUB

SUB DRAWBATTLEINFO (ENEMYNUM)
 
 DRAWSTATUS MAPX - 91, MAPY, -1, 0, BGPAGE
 DRAWSTATUS MAPX + 106, MAPY, -1, 1, BGPAGE

 '-< battle menu >-
 X = BTLX
 Y = BTLY + 58
 LINE (X, Y)-(X + 124, Y + 47), 15, BF
 LINE (X + 1, Y + 1)-(X + 123, Y + 46), 1, B

 LINE (X + 4, Y + 13)-(X + 52, Y + 41), 3, BF
 LINE (X + 3, Y + 12)-(X + 53, Y + 42), 14, B
 LINE (X + 3, Y + 22)-(X + 53, Y + 32), 14, B

 LINE (72 + X, Y + 13)-(120 + X, Y + 41), 3, BF
 LINE (71 + X, Y + 12)-(121 + X, Y + 42), 14, B
 LINE (71 + X, Y + 22)-(121 + X, Y + 32), 14, B

 PSETCURSOR X + 56, Y + 5, 0, BGPAGE

 MSGLEN = LEN(RTRIM$(PLAYERDATA(0).NAMES))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(0).NAMES)
 DRAWFONT X + 8 - (MSGLEN AND 1) * 3, Y + 3 + 0 * 10, 1, 0, 1, MSG$

 MSGLEN = LEN(RTRIM$(PLAYERDATA(0).FIRST))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(0).FIRST)
 DRAWFONT X + 8 - (MSGLEN AND 1) * 3, Y + 4 + 1 * 10, 1, 0, 1, MSG$

 MSGLEN = LEN(RTRIM$(PLAYERDATA(0).SECOND))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(0).SECOND)
 DRAWFONT X + 8 - (MSGLEN AND 1) * 3, Y + 4 + 2 * 10, 1, 0, 1, MSG$

 MSGLEN = LEN(RTRIM$(PLAYERDATA(0).THIRD))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(0).THIRD)
 DRAWFONT X + 8 - (MSGLEN AND 1) * 3, Y + 4 + 3 * 10, 1, 0, 1, MSG$

 '- ENEMY MENU -
 MSGLEN = LEN(RTRIM$(PLAYERDATA(1).NAMES))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(1).NAMES)
 DRAWFONT 76 + X - (MSGLEN AND 1) * 3, Y + 3 + 0 * 10, 1, 0, 1, MSG$

 MSGLEN = LEN(RTRIM$(PLAYERDATA(1).FIRST))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(1).FIRST)
 DRAWFONT 76 + X - (MSGLEN AND 1) * 3, Y + 4 + 1 * 10, 1, 0, 1, MSG$

 MSGLEN = LEN(RTRIM$(PLAYERDATA(1).SECOND))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(1).SECOND)
 DRAWFONT 76 + X - (MSGLEN AND 1) * 3, Y + 4 + 2 * 10, 1, 0, 1, MSG$

 MSGLEN = LEN(RTRIM$(PLAYERDATA(1).THIRD))
 MSG$ = SPACE$(3 - (MSGLEN \ 2)) + RTRIM$(PLAYERDATA(1).THIRD)
 DRAWFONT 76 + X - (MSGLEN AND 1) * 3, Y + 4 + 3 * 10, 1, 0, 1, MSG$

 '-< hp bar >-
 X = BTLX
 Y = BTLY - 29

 LINE (X, Y)-(X + 124, Y + 25), 15, BF
 LINE (X + 2, Y + 3)-(X + 122, Y + 22), 1, B
 LINE (X + 2, Y + 5)-(X + 122, Y + 20), 1, B
 LINE (X + 53, Y + 5)-(X + 71, Y + 20), 1, B
 LINE (X + 54, Y + 6)-(X + 70, Y + 19), 14, BF

 IF ENEMYNUM = 9 THEN
   PSETCHV 2, BGPAGE
 ELSE
   PSETCHV 0, BGPAGE
 END IF

 UPDATEHPBAR PLAYERDATA(0).HP, 0, BGPAGE
 UPDATEHPBAR PLAYERDATA(1).HP, 1, BGPAGE

 PCOPY BGPAGE, AUXPAGE
 PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, AUXPAGE
 PSETCHAR BTLENEMYX, BTLENEMYY, 0, ENEMYPAGE, AUXPAGE

 PCOPY AUXPAGE, VISPAGE

END SUB

SUB DRAWFONT (X, Y, C1, C2, S, S$)

 DRAW "BM" + STR$(X) + "," + STR$(Y)
 FOR I = 1 TO LEN(S$)
    IF C2 THEN '- erase back ground -
       DRAW "C" + STR$(C2) + "NR6DNR6DNR6DNR6DNR6DNR6DNR6DNR6U7"
    END IF
    IF C1 THEN '- write text -
       DRAW "C" + STR$(C1) + NEWFONT$(ASC(MID$(S$, I, 1))) + "BR" + STR$(S)
    END IF
 NEXT

END SUB

SUB DRAWFRAME (N)

 SCREEN , , BGPAGE, VISPAGE

 SELECT CASE N
 '- draw map frame -
 CASE IS = 0
   LINE (MAPX, MAPY)-(MAPX + 83, MAPY + 83), 15, BF
   LINE (MAPX + 1, MAPY + 1)-(MAPX + 82, MAPY + 82), 1, B
 '- draw battle frame -
 CASE 1
   LINE (BTLX, BTLY)-(BTLX + 124, BTLY + 54), 15, B
   LINE (BTLX + 1, BTLY + 1)-(BTLX + 123, BTLY + 53), 1, B
 END SELECT

END SUB

SUB DRAWMAINMENU (N, P)

 IF N = -1 THEN
   SCREEN , , P, VISPAGE
   CLRSCR P

   '- box -
   LINE (MAPX, MAPY)-(MAPX + 83, MAPY + 83), 15, BF
   LINE (MAPX + 1, MAPY + 1)-(MAPX + 82, MAPY + 82), 1, B
   LINE (MAPX + 2, MAPY + 30)-(MAPX + 82, MAPY + 30), 1, B

   '- "mini rpg III" -
   SCREEN , , MISCPAGE, VISPAGE
   GET (59, 141)-(138, 168), FMVDATA
   SCREEN , , P, VISPAGE
   PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET
 END IF

 '- start -
 SCREEN , , MISCPAGE, VISPAGE
 GET (102 + (N = 0) * 43, 63)-(143 + (N = 0) * 43, 70), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (MAPX + 21, MAPY + 40 + 0 * 10), FMVDATA, PSET

 '- load -
 SCREEN , , MISCPAGE, VISPAGE
 GET (102 + (N = 1) * 43, 72)-(143 + (N = 1) * 43, 72 + 7), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (MAPX + 21, MAPY + 40 + 1 * 10), FMVDATA, PSET

 '- normal/cheat -
 SCREEN , , MISCPAGE, VISPAGE
 GET (102 + (N = 2) * 43, 99 + (DEBUG) * 18)-(143 + (N = 2) * 43, 106 + (DEBUG) * 18), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (MAPX + 21, MAPY + 40 + 2 * 10), FMVDATA, PSET

 '- exit -
 SCREEN , , MISCPAGE, VISPAGE
 GET (102 + (N = 3) * 43, 90)-(143 + (N = 3) * 43, 97), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (MAPX + 21, MAPY + 40 + 3 * 10), FMVDATA, PSET

END SUB

SUB DRAWMAP

 DRAWFRAME 0 '- make map frame -

 '- load map -
 LOADMAP

 '- restore map -
 SCREEN , , MAPPAGE, VISPAGE
 GET (GAMEDATA.MAPSCROLLX, GAMEDATA.MAPSCROLLY)-(GAMEDATA.MAPSCROLLX + 79, GAMEDATA.MAPSCROLLY + 79), FMVDATA
 SCREEN , , BGPAGE, VISPAGE
 PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET

 '- update -
 PCOPY BGPAGE, AUXPAGE
 MAPROMPTN = GAMEDATA.ROMDIR * 3
 TPSETROM GAMEDATA.MAPROMX, GAMEDATA.MAPROMY, MAPROMPTN, AUXPAGE

 MAPON

END SUB

SUB DRAWSCRIPT (X, Y, N, L)

 DRAWFONT X + 4, Y + 4, 1, 15, 1, SCRIPT(N)
 IF L >= 2 THEN
   DRAWFONT X + 4, Y + 16, 1, 15, 1, SCRIPT(N + 1)
   DELAY 9

   FOR I = 3 TO L
     DELAY 18
     SCROLLTEXT X, Y
     DRAWFONT X + 4, Y + 16, 1, 15, 1, SCRIPT(N + I - 1)
   NEXT

 END IF

END SUB

SUB DRAWSTATUS (X, Y, N, SIDE, P)

 IF N = -1 THEN
   SCREEN , , P, VISPAGE
   LINE (X, Y)-(X + 67, Y + 83), 15, BF
   LINE (X + 1, Y + 1)-(X + 66, Y + 82), 1, B
   LINE (X + 1, Y + 13)-(X + 66, Y + 13), 1, B

   DRAWFONT X + 3 + (0 * 8), Y + 4 + (0 * 8), 1, 0, 2, "Level"
   DRAWFONT X + 3 + (0 * 8), Y + 7 + (1 * 8), 1, 0, 2, "HP"
   DRAWFONT X + 3 + (4 * 8), Y + 7 + (2 * 8), 1, 0, 2, "/"
   DRAWFONT X + 3 + (0 * 8), Y + 7 + (3 * 8), 1, 0, 2, "STR"
   DRAWFONT X + 3 + (0 * 8), Y + 7 + (4 * 8), 1, 0, 2, "DEF"
   DRAWFONT X + 3 + (0 * 8), Y + 7 + (5 * 8), 1, 0, 2, "LUCK"

   LINE (X + 1, Y + 72)-(X + 66, Y + 72), 1, B
   IF SIDE = 0 THEN
     DRAWFONT X + 3, Y + 12 + (6 * 8), 1, 0, 2, "ITEM:"
     DRAWFONT X + 3, Y + 10 + (8 * 8), 1, 0, 2, "NEXT:"
   ELSE
     DRAWFONT X + 3, Y + 10 + (8 * 8), 1, 15, 2, "EXP: "
   END IF
 END IF

 '-< UPDATE >-
 SCREEN , , P, VISPAGE
 '- level -
 IF N = -1 OR N = 0 THEN
   IF PLAYERDATA(SIDE).LEVEL > 99 THEN
     DRAWFONT X - 3 + (6 * 8), Y + 4 + (0 * 8), 1, 15, 1, "99+"
   ELSE
     MSG$ = RIGHT$("0" + LTRIM$(STR$(PLAYERDATA(SIDE).LEVEL)), 2)
     DRAWFONT X + 3 + (6 * 8), Y + 4 + (0 * 8), 1, 15, 2, MSG$
   END IF
 END IF

 '- hp -
 IF N = -1 OR N = 1 THEN
   MSG$ = RIGHT$("00" + LTRIM$(STR$(PLAYERDATA(SIDE).HP)), 3)
   DRAWFONT X + 3 + (4 * 8), Y + 7 + (1 * 8), 1, 15, 2, MSG$
 END IF

 '- max hp -
 IF N = -1 OR N = 2 THEN
   MSG$ = RIGHT$("00" + LTRIM$(STR$(PLAYERDATA(SIDE).MAXHP)), 3)
   DRAWFONT X + 3 + (5 * 8), Y + 7 + (2 * 8), 1, 15, 2, MSG$
 END IF

 '- str -
 IF N = -1 OR N = 3 THEN
   MSG$ = RIGHT$("0" + LTRIM$(STR$(PLAYERDATA(SIDE).STRENGTH)), 2)
   DRAWFONT X + 3 + (6 * 8), Y + 7 + (3 * 8), 1, 15, 2, MSG$
 END IF

 '- def -
 IF N = -1 OR N = 4 THEN
   MSG$ = RIGHT$("0" + LTRIM$(STR$(PLAYERDATA(SIDE).DEFENSE)), 2)
   DRAWFONT X + 3 + (6 * 8), Y + 7 + (4 * 8), 1, 15, 2, MSG$
 END IF

 '- luck -
 IF N = -1 OR N = 5 THEN
   MSG$ = RIGHT$("0" + LTRIM$(STR$(PLAYERDATA(SIDE).LUCK)), 2)
   DRAWFONT X + 3 + (6 * 8), Y + 7 + (5 * 8), 1, 15, 2, MSG$
 END IF

 IF SIDE = 0 THEN
   IF N = -1 OR N = 6 THEN
     IF GAMEDATA.ITEM THEN
       SCREEN , , MISCPAGE, VISPAGE
       GET (173, 63)-(192, 78), FMVDATA
       SCREEN , , P, VISPAGE
       PUT (X + 43, Y + 55), FMVDATA, PSET
     ELSE
       LINE (X + 62, Y + 70)-(X + 43, Y + 55), 15, BF
       DRAW "BM" + STR$(X + 43) + "," + STR$(Y + 55)
       DRAW "C14DEBR18LFBD14UGBL18RH"
     END IF
   END IF

   '- next -
   IF N = -1 OR N = 7 THEN
     MSG$ = RIGHT$("00" + LTRIM$(STR$(GAMEDATA.NEXTLEVEL - PLAYERDATA(SIDE).EXPPOINT)), 3)
     DRAWFONT X + 3 + (5 * 8), Y + 10 + (8 * 8), 1, 15, 2, MSG$
   END IF
 ELSE
   MSG$ = RIGHT$("00" + LTRIM$(STR$(PLAYERDATA(SIDE).EXPPOINT)), 3)
   DRAWFONT X + 3 + (5 * 8), Y + 10 + (8 * 8), 1, 15, 2, MSG$
 END IF

END SUB

SUB DRAWSUBMENU (N)

 IF N = -1 THEN
   SCREEN , , VISPAGE, VISPAGE
   LINE (MAPX, MAPY)-(MAPX + 50, MAPY + 52), 15, BF
   LINE (MAPX + 1, MAPY + 1)-(MAPX + 49, MAPY + 51), 1, B
   LINE (MAPX + 1, MAPY + 53)-(MAPX + 51, MAPY + 53), 1, B
   LINE (MAPX + 51, MAPY + 1)-(MAPX + 51, MAPY + 53), 1, B
 END IF

 SCREEN , , MISCPAGE, VISPAGE
 GET (30 + (29 * (N = 0)), 63)-(56 + (29 * (N = 0)), 70), FMVDATA
 SCREEN , , VISPAGE, VISPAGE: PUT (MAPX + 5, MAPY + 11), FMVDATA, PSET

 SCREEN , , MISCPAGE, VISPAGE
 GET (30 + (29 * (N = 1)), 72)-(56 + (29 * (N = 1)), 79), FMVDATA
 SCREEN , , VISPAGE, VISPAGE: PUT (MAPX + 5, MAPY + 25), FMVDATA, PSET

 SCREEN , , MISCPAGE, VISPAGE
 GET (30 + (29 * (N = 2)), 81)-(56 + (29 * (N = 2)), 88), FMVDATA
 SCREEN , , VISPAGE, VISPAGE: PUT (MAPX + 5, MAPY + 39), FMVDATA, PSET

END SUB

SUB ENEMYATTACK (CHOICE, ENEMYNUM, BATTLERESULT)

 '- init -
 ENEMY = TRUE

 IF ((RND * 100) < 10 + PLAYERDATA(0).LUCK / 2.5) AND NOT (ENEMYNUM = 7 AND CHOICE = 1) THEN  '- rom block -
   DAMAGE = 0
   ATTACKRESULT = 2
 '- else calc damage -
 ELSE
   ENEMYATKPOWER = PLAYERDATA(1).STRENGTH

   '- critical attack -
   IF CHOICE = 1 THEN ENEMYATKPOWER = ENEMYATKPOWER * (1.2 + RND * .3)

   ROMDEFPOWER = PLAYERDATA(0).DEFENSE

   DAMAGE = (ENEMYATKPOWER - ROMDEFPOWER)

   IF DAMAGE <= 0 THEN DAMAGE = 0

   DAMAGE = DAMAGE + INT(RND * (PLAYERDATA(1).LUCK \ 10 + 2))

   '- if death -
   IF DAMAGE >= PLAYERDATA(0).HP THEN
     DAMAGE = PLAYERDATA(0).HP
     ATTACKRESULT = 3
     BATTLERESULT = 3
   '- else normal hit -
   ELSE
     ATTACKRESULT = 1
   END IF
 END IF

 PLAYERDATA(0).HP = PLAYERDATA(0).HP - DAMAGE

 '- init enemy action -
 SELECT CASE CHOICE
 '- normal attack -
 CASE IS = 0
   ENEMYACT = VAL(MID$("09323232281639323246", ENEMYNUM * 2 - 1, 2))
   ENEMYCOUNTER = 0
   ENEMY = TRUE
 '- enemy special attack -
 CASE IS = 1
   ENEMYACT = VAL(MID$("10323232291640333347", ENEMYNUM * 2 - 1, 2))
   ENEMYCOUNTER = 0
   ENEMY = TRUE
 END SELECT

 LC = 0
 DO
   LC = LC + 1
   '- normal hit on rom init -
   IF CHOICE = 0 THEN
     SELECT CASE ATTACKRESULT
     CASE IS = 1 '- normal hit -
       IF LC = VAL(MID$("32353535297432363626", ENEMYNUM * 2 - 1, 2)) THEN
         ROM = TRUE
         ROMACT = 4
         ROMCOUNTER = 0
       END IF
     CASE IS = 2 '- block hit -
       IF LC = VAL(MID$("16202020135916202010", ENEMYNUM * 2 - 1, 2)) THEN
         ROM = TRUE
         ROMACT = 3
         ROMCOUNTER = 0
       END IF
     CASE IS = 3 '- death -
       IF LC = VAL(MID$("32353535297432363626", ENEMYNUM * 2 - 1, 2)) THEN
         ROM = TRUE
         ROMACT = 5
         ROMCOUNTER = 0
       END IF
     END SELECT
   '- special hit on rom init -
   ELSE
     SELECT CASE ATTACKRESULT
     CASE IS = 1 '- normal hit -
       IF LC = VAL(MID$("64373737365833343424", ENEMYNUM * 2 - 1, 2)) THEN
         ROM = TRUE
         ROMACT = 4
         ROMCOUNTER = 0
       END IF
     CASE IS = 2 '- block hit (CAN NOT BLOCK DRA'S SPECIAL) -
       IF LC = VAL(MID$("49212121204233181808", ENEMYNUM * 2 - 1, 2)) THEN
         ROM = TRUE
         ROMACT = 3 - (ENEMYNUM = 7 AND CHOICE = 1)
         ROMCOUNTER = 0
       END IF
     CASE IS = 3 '- death -
       IF LC = VAL(MID$("64373737365833343424", ENEMYNUM * 2 - 1, 2)) THEN
         ROM = TRUE
         ROMACT = 5
         ROMCOUNTER = 0
       END IF
     END SELECT
   END IF

   '- init guest -
   IF LC = 22 AND ENEMYNUM = 6 THEN
     GUEST = TRUE
     GUESTACT = 22 + (CHOICE * 3)
     GUESTCOUNTER = 0
   END IF

   '- init enemy weapon -
   SELECT CASE CHOICE
   CASE IS = 0'- normal attack -
     IF LC = VAL(MID$("13171717115812171709", ENEMYNUM * 2 - 1, 2)) THEN
       ENEMYWEAPON = TRUE
       ENEMYWEAPONX = BTLX + VAL(MID$("87838383856290838380", ENEMYNUM * 2 - 1, 2))
       ENEMYWEAPONY = BTLY + VAL(MID$("32333333233127313128", ENEMYNUM * 2 - 1, 2))
       ENEMYWEAPONTYP = VAL(MID$("02050505060810121206", ENEMYNUM * 2 - 1, 2))
       IF ATTACKRESULT = 2 THEN
         ENEMYWEAPONLEN = VAL(MID$("13131313121114131311", ENEMYNUM * 2 - 1, 2))
       ELSE
         ENEMYWEAPONLEN = VAL(MID$("17161616161418171715", ENEMYNUM * 2 - 1, 2))
       END IF

       ENEMYWEAPONCOUNTER = 0
     END IF
   CASE IS = 1'- special attack -
     IF LC = VAL(MID$("46171717164400151505", ENEMYNUM * 2 - 1, 2)) THEN
       ENEMYWEAPON = TRUE
       ENEMYWEAPONX = BTLX + VAL(MID$("82909090906500878787", ENEMYNUM * 2 - 1, 2))
       ENEMYWEAPONY = BTLY + VAL(MID$("27282828353300353535", ENEMYNUM * 2 - 1, 2))
       ENEMYWEAPONTYP = VAL(MID$("03040404070900111107", ENEMYNUM * 2 - 1, 2))

       IF ATTACKRESULT = 2 THEN
         ENEMYWEAPONLEN = VAL(MID$("13141414140800131313", ENEMYNUM * 2 - 1, 2))
       ELSE
         ENEMYWEAPONLEN = VAL(MID$("16181818181200171717", ENEMYNUM * 2 - 1, 2))
       END IF

       ENEMYWEAPONCOUNTER = 0
     END IF
   END SELECT

   '- calc enemy animation -
   IF ENEMY THEN
     ENEMYCOUNTER = ENEMYCOUNTER + 1
     ENEMYPTN = FMVPTN(ENEMYCOUNTER, ENEMYACT)
     '- if end of animation -
     IF ENEMYCOUNTER >= FMVPTN(0, ENEMYACT) THEN

       SELECT CASE CHOICE
       CASE IS = 0 '- if normal attack -
         IF ENEMYACT = VAL(MID$("09323232281739323246", ENEMYNUM * 2 - 1, 2)) THEN
           ENEMY = FALSE
           ENEMYCOUNTER = 0
         ELSE
           ENEMYACT = ENEMYACT + 1
           ENEMYCOUNTER = 0
         END IF
       CASE IS = 1
         IF ENEMYACT = VAL(MID$("13323232291842343447", ENEMYNUM * 2 - 1, 2)) THEN
           ENEMY = FALSE
           ENEMYCOUNTER = 0
         ELSE
           ENEMYACT = ENEMYACT + 1
           IF ENEMYACT = 17 THEN ENEMYACT = 18
           ENEMYCOUNTER = 0
         END IF

       END SELECT
     END IF
   END IF

   '- calc rom animation -
   IF ROM THEN
     ROMCOUNTER = ROMCOUNTER + 1
     ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
     '- if end of animation -
     IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
       ROM = FALSE
       ROMCOUNTER = 0
       '- set extra delay -
       EXTRA = TRUE
       EXTRACOUNTER = VAL(MID$("03020202010902020200", ENEMYNUM * 2 - 1, 2)) + 10
       EXTRACOUNTER = 13 - (ENEMYNUM = 7 AND CHOICE = 1) * 15
     END IF
   END IF

   '- output cel -
   PSETCHAR BTLROMX, BTLROMY, ROMPTN, ROMPAGE, BGPAGE
   PSETCHAR BTLENEMYX, BTLENEMYY, ENEMYPTN, ENEMYPAGE, BGPAGE

   IF GUEST THEN
     GUESTCOUNTER = GUESTCOUNTER + 1
     GUESTPTN = FMVPTN(GUESTCOUNTER, GUESTACT)
     IF GUESTCOUNTER >= FMVPTN(0, GUESTACT) THEN
       IF GUESTACT = 24 OR GUESTACT = 27 THEN
         GUEST = FALSE
         GUESTCOUNTER = 0
       ELSE
         GUESTACT = GUESTACT + 1
         GUESTCOUNTER = 0
       END IF
     END IF

     PSETCHAR BTLENEMYX - 21, BTLENEMYY, GUESTPTN, ENEMYPAGE, BGPAGE
   END IF

   PCOPY BGPAGE, AUXPAGE

   IF ENEMYWEAPON THEN

     ENEMYWEAPONX = ENEMYWEAPONX - (4 + (ENEMYWEAPONTYP = 8))

     ENEMYWEAPONCOUNTER = ENEMYWEAPONCOUNTER + 1

     SELECT CASE ENEMYWEAPONTYP
     CASE 4                '- 2 patterns fast -
       ENEMYWEAPONPTN = ENEMYWEAPONCOUNTER MOD 2
     CASE 2, 3, 7, 11      '- 2 patterns slow -
       ENEMYWEAPONPTN = (ENEMYWEAPONCOUNTER MOD 4) \ 2
     CASE 8                '- 8 patterns -
       ENEMYWEAPONPTN = (((ENEMYWEAPONCOUNTER + 1) MOD 8) + 1) MOD 8
     CASE IS = 9           '- wave pattern -
       ENEMYWEAPONY = ENEMYWEAPONY + (VAL(MID$("122100", ENEMYWEAPONCOUNTER MOD 6 + 1, 1)) - 1)
     END SELECT

     ENEMYWEAPONLEN = ENEMYWEAPONLEN - 1

     IF ENEMYWEAPONLEN <= 0 THEN

       ENEMYWEAPON = FALSE

       IF ATTACKRESULT = 2 THEN
          STAR = TRUE
          IF CHOICE = 0 THEN '- normal block star -
            STARX = BTLX + VAL(MID$("32323232323232323232", ENEMYNUM * 2 - 1, 2))
            STARY = BTLY + VAL(MID$("30292929243028292929", ENEMYNUM * 2 - 1, 2))
          ELSE               '- special block star -
            STARX = BTLX + VAL(MID$("32333333323200333333", ENEMYNUM * 2 - 1, 2))
            STARY = BTLY + VAL(MID$("30282828353000343434", ENEMYNUM * 2 - 1, 2))
          END IF

          STARPTN = -1
        ELSE
          SPARK = TRUE
          IF CHOICE = 0 THEN '- normal hit spark -
            SPARKX = BTLX + VAL(MID$("17191919171815181816", ENEMYNUM * 2 - 1, 2))
            SPARKY = BTLY + VAL(MID$("30282828232827282828", ENEMYNUM * 2 - 1, 2))
          ELSE               '- special hit spark -
            SPARKX = BTLX + VAL(MID$("20181818181600181818", ENEMYNUM * 2 - 1, 2))
            SPARKY = BTLY + VAL(MID$("30282828363000363636", ENEMYNUM * 2 - 1, 2))
          END IF
          SPARKPTN = -1
          NUMBER = TRUE
          NUMBERCOUNTER = -1
          '- update hp bar -
          UPDATEHPBAR PLAYERDATA(0).HP, 0, BGPAGE
          DRAWSTATUS MAPX - 91, MAPY, 1, 0, BGPAGE
        END IF
     END IF

     TPSETWEAPON ENEMYWEAPONX, ENEMYWEAPONY, ENEMYWEAPONPTN, ENEMYWEAPONTYP, AUXPAGE
   END IF

   '- special dra attack spark -
   IF LC = 30 AND ENEMYNUM = 7 AND CHOICE = 1 THEN
     SPARK = TRUE
     SPARKX = BTLX + 16
     SPARKY = BTLY + 30
     SPARKPTN = -1
     NUMBER = TRUE
     NUMBERCOUNTER = -1
     '- update hp bar -
     UPDATEHPBAR PLAYERDATA(0).HP, 0, BGPAGE
     DRAWSTATUS MAPX - 91, MAPY, 1, 0, BGPAGE
   END IF

   IF SPARK THEN
     SPARKPTN = SPARKPTN + 1
     IF SPARKPTN = 3 THEN SPARK = FALSE
     TPSETSPARK SPARKX, SPARKY, 0, SPARKPTN, AUXPAGE
   END IF

   IF STAR THEN
     STARPTN = STARPTN + 1
     IF STARPTN = 4 THEN STAR = FALSE
     TPSETSPARK STARX, STARY, 1, STARPTN, AUXPAGE
   END IF

   IF NUMBER THEN
     NUMBERCOUNTER = NUMBERCOUNTER + 1
     IF NUMBERCOUNTER >= 16 THEN NUMBER = FALSE
     NUMBERFX BTLROMX - 5, BTLROMY + 21, -DAMAGE, NUMBERCOUNTER, AUXPAGE
   END IF

   PCOPY AUXPAGE, VISPAGE

   DELAY 1

   IF EXTRA THEN EXTRACOUNTER = EXTRACOUNTER - 1

 LOOP UNTIL EXTRACOUNTER < 0

END SUB

SUB EVENTBATTLE (N, BATTLERESULT)

 ENEMYNUM = 6 + N
 INITENEMYDATA ENEMYNUM
 BATTLE ENEMYNUM, BATTLERESULT

 IF BATTLERESULT = 1 THEN GAMEDATA.EVENT = GAMEDATA.EVENT + 1

END SUB

SUB EVENTOPEN (N)

 '- make battle field -
 DRAWFRAME 1

 '- copy bg -
 COPYPANEL VAL(MID$("3312222224452", N, 1)), VAL(MID$("1000200003004", N, 1))

 '- load graphic -
 SELECT CASE N
 '- blue castle -
 CASE IS = 1
   LOADSCREEN GRP(0), ROMPAGE
 CASE IS = 2
   LOADSCREEN GRP(0), ROMPAGE
   LOADSCREEN GRP(9), ENEMYPAGE
 '- shop outside -
 CASE IS = 3
   LOADSCREEN GRP(0), ROMPAGE
   LOADSCREEN GRP(13), FMVPAGE
 '- shop inside -
 CASE IS = 4
   LOADSCREEN GRP(1), ROMPAGE
 CASE IS = 5
   LOADSCREEN GRP(1), ROMPAGE
 CASE IS = 6
   LOADSCREEN GRP(1), ROMPAGE
 CASE IS = 7
   LOADSCREEN GRP(1), ROMPAGE
 CASE IS = 8
   LOADSCREEN GRP(1), ROMPAGE
   LOADSCREEN GRP(10), ENEMYPAGE
 CASE IS = 9
   LOADSCREEN GRP(1), ROMPAGE
 '- car -
 CASE IS = 10
   LOADSCREEN GRP(2), ROMPAGE
   LOADSCREEN GRP(15), FMVPAGE
   LOADSCREEN GRP(11), ENEMYPAGE
 CASE IS = 11
   LOADSCREEN GRP(2), ROMPAGE
   LOADSCREEN GRP(15), FMVPAGE
 '- red castle -
 CASE IS = 12
   LOADSCREEN GRP(0), ROMPAGE
   LOADSCREEN GRP(12), ENEMYPAGE
 CASE IS = 13 '- last minute update -
   LOADSCREEN GRP(1), ROMPAGE
 END SELECT

 '- update -
 SELECT CASE N
 CASE IS = 1 '- blue castle : rom vs none -
   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
 CASE IS = 2 '- blue castle : rom vs dra -
   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
 CASE IS = 3 '- shop outside : rom vs none -
   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
 CASE IS = 4 '- shop inside : candy vs rom -
   PSETPATCH BTLX + 2, BTLY + 16, 0, BGPAGE
   PSETPATCH BTLX + 92, BTLY + 16, 1, BGPAGE
 CASE IS = 5 '- shop inside : candy vs rom -
   PSETPATCH BTLX + 2, BTLY + 16, 0, BGPAGE
   PSETPATCH BTLX + 92, BTLY + 16, 1, BGPAGE
 CASE IS = 6 '- shop inside : candy vs namnam -
   PSETPATCH BTLX + 2, BTLY + 16, 0, BGPAGE
   PSETPATCH BTLX + 92, BTLY + 16, 2, BGPAGE
 CASE IS = 7 '- shop inside : rom vs none -
   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
 CASE IS = 8 '- shop inside : rom vs trig1 -
   PSETCHAR BTLROMX, BTLROMY, 3, ROMPAGE, BGPAGE
   PSETCHAR BTLENEMYX, BTLENEMYY, 0, ENEMYPAGE, BGPAGE
 CASE IS = 9 '- shop inside : rom vs candy -
   PSETCHAR BTLROMX, BTLROMY, 3, ROMPAGE, BGPAGE
   PSETPATCH BTLX + 92, BTLY + 16, 3, BGPAGE
 CASE IS = 10'- car : rom vs none -
   PSETCHAR BTLROMX, BTLROMY, 10, FMVPAGE, BGPAGE
 CASE IS = 11'- car : rom vs none -
   PSETCHAR BTLROMX, BTLROMY, 10, FMVPAGE, BGPAGE
 CASE IS = 12'- red castle : rom vs skull -
   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
   PSETCHAR BTLENEMYX, BTLENEMYY, 0, ENEMYPAGE, BGPAGE
 CASE IS = 13 '- shop inside : candy vs rom + box display -
   PSETPATCH BTLX + 2, BTLY + 16, 0, BGPAGE
   PSETPATCH BTLX + 92, BTLY + 16, 1, BGPAGE
 END SELECT

 '- open -
 BTLON
 DELAY 18

END SUB

SUB FADE (P)

 R$ = "250009270918451800000000000000006363545509254563"
 G$ = "260054630927095400000000000000000921545436264563"
 B$ = "270009276363096300000000000000000921093609274563"
 FADESTEP = (8 \ 1) - 1

 FOR J = FADESTEP * ((P MOD 2)) TO FADESTEP * -((P MOD 2) <> 1) STEP 1 - ((P MOD 2) * 2)
   OUT &H3C8, (P \ 2)
   FOR I = (P \ 2) TO 23
     VALUE1 = VAL(MID$(R$, I * 2 + 1, 2))
     OUT &H3C9, VALUE1 - ((VALUE1 - 63 * (P \ 2)) / FADESTEP * J)
     VALUE1 = VAL(MID$(G$, I * 2 + 1, 2))
     OUT &H3C9, VALUE1 - ((VALUE1 - 63 * (P \ 2)) / FADESTEP * J)
     VALUE1 = VAL(MID$(B$, I * 2 + 1, 2))
     OUT &H3C9, VALUE1 - ((VALUE1 - 63 * (P \ 2)) / FADESTEP * J)
    NEXT
   DELAY 1
 NEXT

END SUB

SUB FIRSTATTACK (ENEMYNUM, SIDE)

 SIDE = 0

 FOR I = 1 TO 4 + INT(RND * 7)
   SIDE = (SIDE + 1) MOD 2
   LINE (BTLX + 56, BTLY + 63)-(BTLX + 68, BTLY + 103), 15, BF
   PSETCURSOR BTLX + 56, BTLY + 63, (SIDE * 2), BGPAGE
   PCOPY BGPAGE, VISPAGE
   DELAY 5
 NEXT

 L = 41
 N = 10
 X = BTLX + 56
 Y = BTLY + 35

 SCREEN , , VISPAGE, VISPAGE
 DRAW "BM" + STR$(X) + "," + STR$(Y)
 DRAW "C13BR4R" + STR$(L) + "FRFDFD19GDGLGL" + STR$(L) + "HLHUHU19EUEREBFP3,13P15,13BHBL4"
 DRAW "C1 BR4R" + STR$(L) + "FRFDFD19GDGLGL" + STR$(L) + "HLHUHU19EUEREBL4"
 DRAW "BM" + STR$(X + N) + "," + STR$(Y)
 DRAW "BR14BD27C1G3LG2LG2LNGUEUEU2HBRC15R7GL5DNR4DR2GL2DG"

 DRAWFONT X + 6, Y + 4, 1, 15, 2, " YOU "
 DRAWFONT X + 6, Y + 2 + 14, 1, 15, 2, "FIRST"
 DELAY 27

 PCOPY BGPAGE, VISPAGE
 DELAY 9

 '- head turn (event #4) -
 IF ENEMYNUM = 9 AND SIDE = 0 THEN
   FOR I = 0 TO 5
     PSETHEAD VAL(MID$("2211001122", I + (SIDE * 4) + 1, 1)), BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT
 END IF

END SUB

SUB GETKEY (KEY$)

 DUMMY = RND
 KEY$ = INKEY$
 IF LEN(KEY$) = 2 THEN KEY$ = "*" + RIGHT$(KEY$, 1)

END SUB

SUB INITDATA

 '- LOADABLE DATA -
 GAMEDATA.EVENT = 0
 GAMEDATA.ROUND = 0
 GAMEDATA.ITEM = FALSE

 GAMEDATA.MAPROMX = 47 + MAPX
 GAMEDATA.MAPROMY = 60 + MAPY

 GAMEDATA.MAPSCROLLX = 113
 GAMEDATA.MAPSCROLLY = 65
 GAMEDATA.GRIDX = 20
 GAMEDATA.GRIDY = 16
 GAMEDATA.ROMDIR = 1

 PLAYERDATA(0).NAMES = CHARDATA(0).NAMES
 PLAYERDATA(0).LEVEL = CHARDATA(0).LEVEL
 PLAYERDATA(0).MAXHP = CHARDATA(0).MAXHP
 PLAYERDATA(0).HP = PLAYERDATA(0).MAXHP
 PLAYERDATA(0).STRENGTH = CHARDATA(0).STRENGTH
 PLAYERDATA(0).DEFENSE = CHARDATA(0).DEFENSE
 PLAYERDATA(0).LUCK = CHARDATA(0).LUCK

 PLAYERDATA(0).EXPPOINT = CHARDATA(0).EXPPOINT

 PLAYERDATA(0).FIRST = CHARDATA(0).FIRST
 PLAYERDATA(0).SECOND = CHARDATA(0).SECOND
 PLAYERDATA(0).THIRD = CHARDATA(0).THIRD

 GAMEDATA.NEXTLEVEL = 10

END SUB

SUB INITENEMYDATA (N)

 PLAYERDATA(1).NAMES = CHARDATA(N).NAMES
 PLAYERDATA(1).LEVEL = CHARDATA(N).LEVEL
 PLAYERDATA(1).MAXHP = CHARDATA(N).MAXHP
 PLAYERDATA(1).HP = CHARDATA(N).MAXHP
 PLAYERDATA(1).STRENGTH = CHARDATA(N).STRENGTH
 PLAYERDATA(1).DEFENSE = CHARDATA(N).DEFENSE
 PLAYERDATA(1).LUCK = CHARDATA(N).LUCK
 PLAYERDATA(1).EXPPOINT = CHARDATA(N).EXPPOINT
 PLAYERDATA(1).FIRST = CHARDATA(N).FIRST
 PLAYERDATA(1).SECOND = CHARDATA(N).SECOND
 PLAYERDATA(1).THIRD = CHARDATA(N).THIRD

END SUB

SUB INITFILE

 PRINT "CHECK SAVED FILE"
 OPEN "SAVEDATA.REC" FOR APPEND AS #1
 FILESIZE = LOF(1)
 CLOSE #1

 IF FILESIZE = 0 THEN
   INITDATA
   SAVEDATA
 END IF

END SUB

SUB INITGRAPHIC

 '- load graphics -
 PRINT "LOAD GRAPHIC(s)"

 '- misc -
 LOADSCREEN GRP(17), MISCPAGE

END SUB

SUB INITMAINVARIABLE

 SCREEN 7, , VISPAGE, VISPAGE
 CLS

 '- set color -
 PRINT "SET NEW COLOR"
 NEWCOLOR

 DEBUG = FALSE

 '-< reset timer >-
 PRINT "RESET TIMER"
 DELAY 1

 '-< load font data >-
 PRINT "SET NEW FONT"
 OPEN DRIVE$ + DATAPATH$ + FONTNAME$ FOR INPUT AS #1
 FOR I = 32 TO 126
   LINE INPUT #1, NEWFONT$(I)
 NEXT
 CLOSE #1

 '-< load graphic filename >-
 PRINT "LOAD GRAPHIC FILENAME"
 DEF SEG = VARSEG(GRP(0))
 BLOAD DRIVE$ + DATAPATH$ + "GRPLIST.^_^", VARPTR(GRP(0))
 DEF SEG

 '-< load map data >-
 PRINT "LOAD MAP DATA"
 DEF SEG = VARSEG(MAPDATA(0, 0))
 BLOAD DRIVE$ + DATAPATH$ + "MAPDATA.^_^", VARPTR(MAPDATA(0, 0))
 DEF SEG

 '-< load script >-
 PRINT "LOAD SCRIPT"
 DEF SEG = VARSEG(SCRIPT(0))
 BLOAD DRIVE$ + DATAPATH$ + "SCRIPT.^_^", VARPTR(SCRIPT(0))
 DEF SEG

 '-< load fmv pattern >-
 PRINT "LOAD FMV PATTERN"
 DEF SEG = VARSEG(FMVPTN(0, 0))
 BLOAD DRIVE$ + DATAPATH$ + "FMV.^_^", VARPTR(FMVPTN(0, 0))
 DEF SEG

 '-< load status >-
 PRINT "LOAD STATUS"
 DEF SEG = VARSEG(CHARDATA(0).NAMES)
 BLOAD DRIVE$ + DATAPATH$ + "STATUS.^_^", VARPTR(CHARDATA(0).NAMES)
 DEF SEG

 '-< check saved file >-
 PRINT "CHECK SAVED FILE"
 INITFILE

END SUB

SUB INTRO

 '- copy map to bgpage -
 CLRSCR BGPAGE
 DRAWFRAME 0
 SCREEN , , MISC2PAGE, VISPAGE
 GET (57, 1)-(136, 80), FMVDATA
 SCREEN , , BGPAGE, VISPAGE
 PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET
 PCOPY BGPAGE, AUXPAGE

 '- map open -
 TITLEFX

 CLEARBUFFER

 '- animation start -
 COOKIE = FALSE
 ZZZ = FALSE

 LC = 0

 DO
   LC = LC + 1

   '- init fmv (sort by loop counter) -
   IF LC = 20 THEN
     ZZZ = TRUE
     ZZZPTN = 0
   END IF
   IF LC = 65 THEN
     COOKIE = TRUE
     COOKIEX = MAPX + 82
     COOKIEY = MAPY + 60
     COOKICOUNTER = 0
     COOKIECLIP = 0
   END IF

   PCOPY BGPAGE, AUXPAGE

   '- output cel (sort by Z value)-
   IF ZZZ THEN
     ZZZPTN = (ZZZPTN + 1) MOD 20
     TPSETZZZ MAPX + 15, MAPY + 42, VAL(MID$("0011222233", ZZZPTN \ 2 + 1, 1)), 0, AUXPAGE
   END IF

   IF COOKIE THEN
     COOKIECOUNTER = (COOKIECOUNTER + 1) MOD 12
     COOKIEPTN = VAL(MID$("000111000222", COOKIECOUNTER + 1, 1))
     COOKIEX = COOKIEX - 1
     COOKIECLIP = COOKIECLIP + 1
     TPSETSMALLCOOKIE COOKIEX, COOKIEY, COOKIECLIP, COOKIEPTN, AUXPAGE
   END IF

   PCOPY AUXPAGE, VISPAGE

   DELAY 1

 LOOP UNTIL LC = 135

 MAPOFF

 '- battle field update for intro -
 CLRSCR BGPAGE
 DRAWFRAME 1
 COPYPANEL 6, 0
 PSETCHAR BTLX + 30, BTLY + 11, 0, EXTRAPAGE, BGPAGE
 PCOPY BGPAGE, AUXPAGE
 BTLON

 '- 2nd animation start -
 COOKIE = FALSE
 ZZZ = FALSE

 LC = 0
 DO
   LC = LC + 1

   '- init fmv (sort by loop counter) -
   IF LC = 10 THEN
     COOKIE = TRUE
     COOKIEX = BTLX + 123
     COOKIEY = BTLY + 21
     COOKIECOUNTER = 0
     COOKIECLIP = 0
     COOKIEACT = 0
   END IF
   IF LC = 110 THEN
     ROM = TRUE
     ROMX = BTLX + 30
     ROMY = BTLY + 11
     ROMACT = 54
     ROMCOUNTER = 0
   END IF
   IF LC = 266 THEN
     ROM = TRUE
     ROMX = BTLX + 30
     ROMY = BTLY + 11
     ROMACT = 56
     ROMCOUNTER = 0
   END IF
   IF LC = 290 THEN
     NAMNAM = TRUE
     NAMNAMX = BTLX + 2
     NAMNAMY = BTLY + 21
     NAMNAMACT = 60
     NAMNAMCOUNTER = 1
   END IF

   '- talk -
   IF LC = 100 THEN TALK 1
   IF LC = 146 THEN TALK 2
   IF LC = 170 THEN TALK 3
   IF LC = 180 THEN TALK 4
   IF LC = 190 THEN TALK 5
   IF LC = 265 THEN TALK 6
   IF LC = 340 THEN TALK 7
   IF LC = 390 THEN TALK 8
   IF LC = 400 THEN TALK 9
   IF LC = 410 THEN TALK 10
   IF LC = 420 THEN TALK 11
   IF LC = 430 THEN TALK 12

   PCOPY BGPAGE, AUXPAGE

   '- output cel (sort by Z value)-
   IF NAMNAM THEN
     SELECT CASE NAMNAMACT
     CASE IS = 60
       NAMNAMCOUNTER = NAMNAMCOUNTER + 1
       NAMNAMPTN = FMVPTN(NAMNAMCOUNTER, NAMNAMACT)
       IF NAMNAMCOUNTER >= FMVPTN(0, NAMNAMACT) THEN
         NAMNAMACT = 61
         NAMNAMCOUNTER = 0
       END IF
       PSETCHAR NAMNAMX, NAMNAMY, NAMNAMPTN, EXTRAPAGE, AUXPAGE
     CASE IS = 61
       NAMNAMCOUNTER = NAMNAMCOUNTER + 1
       NAMNAMPTN = FMVPTN(NAMNAMCOUNTER, NAMNAMACT)
       IF NAMNAMCOUNTER >= FMVPTN(0, NAMNAMACT) THEN
         NAMNAMACT = -1
         NAMNAMCOUNTER = 0
         NAMNAM = FALSE
         'overlap bg(namnam)
         PSETCHAR NAMNAMX, NAMNAMY, 34, EXTRAPAGE, BGPAGE
       END IF
       PSETCHAR NAMNAMX, NAMNAMY, NAMNAMPTN, EXTRAPAGE, AUXPAGE
     END SELECT
   END IF

   IF ROM THEN
     SELECT CASE ROMACT
     CASE IS = 54 '- appear -
       ROMCOUNTER = ROMCOUNTER + 1
       ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
       IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
         ROMACT = 55
         ROMCOUNTER = 0
       END IF
       PSETCHAR ROMX, ROMY, ROMPTN, EXTRAPAGE, AUXPAGE
     CASE IS = 55 '- blink -
       ROMCOUNTER = ROMCOUNTER + 1
       ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
       IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
         ROMACT = -1
         ROMCOUNTER = 0
         ROM = FALSE
         'overlap bg(rom)
         PSETCHAR ROMX, ROMY, 7, EXTRAPAGE, BGPAGE
       END IF
       PSETCHAR ROMX, ROMY, ROMPTN, EXTRAPAGE, AUXPAGE
     CASE 56
       ROMCOUNTER = ROMCOUNTER + 1
       ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
       IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
         ROMACT = 57
         ROMCOUNTER = 0
         ROMLOOP = 0
       END IF
       PSETCHAR ROMX, ROMY, ROMPTN, EXTRAPAGE, AUXPAGE
     CASE 57
       ROMCOUNTER = ROMCOUNTER + 1
       ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
       IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
         ROMCOUNTER = 0
         ROMLOOP = ROMLOOP + 1
         IF ROMLOOP > 2 THEN
           ROMACT = 58
           ROMCOUNTER = 0
         END IF
       END IF
       PSETCHAR ROMX, ROMY, ROMPTN, EXTRAPAGE, AUXPAGE
     CASE 58
       ROMCOUNTER = ROMCOUNTER + 1
       ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
       IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
         ROMCOUNTER = 0
         ROMACT = 59
         ROMCOUNTER = 0
       END IF
       PSETCHAR ROMX, ROMY, ROMPTN, EXTRAPAGE, AUXPAGE
     CASE 59
       ROMCOUNTER = ROMCOUNTER + 1
       ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
       IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
         ROMCOUNTER = 0
         ROMACT = -1
         ROMCOUNTER = 0
         ROM = FALSE
         'overlap bg(rom)
         PSETCHAR ROMX, ROMY, 21, EXTRAPAGE, BGPAGE
       END IF
       PSETCHAR ROMX, ROMY, ROMPTN, EXTRAPAGE, AUXPAGE
     END SELECT
   END IF

   IF COOKIE THEN
     SELECT CASE COOKIEACT
     '- walk -
     CASE IS = 0
       COOKIECOUNTER = COOKIECOUNTER + 1
       COOKIEPTN = VAL(MID$("000111000222", (COOKIECOUNTER MOD 12) + 1, 1))
       COOKIEX = COOKIEX - 1
       COOKIECLIP = COOKIECLIP + 1
       '- check end of animation -
       IF COOKIECOUNTER = 49 THEN
         COOKIEACT = 1
         COOKIECOUNTER = 0
         COOKIECLIP = 99
       END IF
     '- turn -
     CASE IS = 1
       COOKIECOUNTER = COOKIECOUNTER + 1
       COOKIEPTN = FMVPTN(COOKIECOUNTER, 91)
       '- check end of animation -
       IF COOKIECOUNTER >= FMVPTN(0, 91) THEN
         COOKIEACT = 2
         COOKIECOUNTER = 0
       END IF
     '- knock -
     CASE IS = 2
       COOKIECOUNTER = COOKIECOUNTER + 1
       COOKIEPTN = FMVPTN(COOKIECOUNTER, 92)
       '- check end of animation -
       IF COOKIECOUNTER >= FMVPTN(0, 92) THEN
         COOKIEACT = 3
         COOKIECOUNTER = 0
       END IF
     '- wait -
     CASE IS = 3
       COOKIECOUNTER = COOKIECOUNTER + 1
       'COOKIEPTN = FMVPTN(COOKIECOUNTER, 93)
       '- check end of animation -
       IF COOKIECOUNTER >= 51 THEN
         COOKIEACT = 4
         COOKIECOUNTER = 0
       END IF
     '- turn -
     CASE IS = 4
       COOKIECOUNTER = COOKIECOUNTER + 1
       COOKIEPTN = FMVPTN(COOKIECOUNTER, 94)
       '- check end of animation -
       IF COOKIECOUNTER >= FMVPTN(0, 94) THEN
         COOKIEACT = 5
         COOKIECOUNTER = 0
       END IF
     '- wait, talk -
     CASE IS = 5
       COOKIECOUNTER = COOKIECOUNTER + 1
       '- check end of animation -
       IF COOKIECOUNTER >= 25 THEN
         COOKIEACT = 7
         COOKIECOUNTER = 0
       END IF
     '- turn 180 -
     CASE IS = 7
       COOKIECOUNTER = COOKIECOUNTER + 1
       COOKIEPTN = FMVPTN(COOKIECOUNTER, 96)
       '- check end of animation -
       IF COOKIECOUNTER >= FMVPTN(0, 96) THEN
         COOKIEACT = 8
         COOKIECOUNTER = 0
         COOKIECLIP = 49
       END IF
     '- walk -
     CASE IS = 8
       COOKIECOUNTER = COOKIECOUNTER + 1
       COOKIEPTN = VAL(MID$("000111000222", (COOKIECOUNTER MOD 12) + 1, 1)) + 10
       COOKIEX = COOKIEX + 1
       COOKIECLIP = COOKIECLIP - 1
       '- check end of animation -
       IF COOKIECOUNTER = 50 THEN
         COOKIEACT = -1
         COOKIECOUNTER = 0
         COOKIECLIP = 0
         COOKIE = FALSE
       END IF
     END SELECT

     TPSETBIGCOOKIE COOKIEX, COOKIEY, COOKIECLIP, COOKIEPTN, AUXPAGE

   END IF

   PCOPY AUXPAGE, VISPAGE

   DELAY 1

 LOOP UNTIL LC = 450

 BTLOFF 0

 '- copy map -
 CLRSCR BGPAGE
 DRAWFRAME 0
 SCREEN , , MISC2PAGE, VISPAGE
 GET (57, 1)-(136, 80), FMVDATA
 SCREEN , , BGPAGE, VISPAGE
 PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET

 PCOPY BGPAGE, AUXPAGE

 MAPON
 PCOPY AUXPAGE, VISPAGE
 DELAY 9

 '- scroll map (fast) -
 N = 28
 FOR I = 0 TO N
   SCREEN , , MISC2PAGE, VISPAGE
   GET (57 - (I * 2), 1)-(136 - (I * 2), 80), FMVDATA
   SCREEN , , AUXPAGE, VISPAGE
   PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET
   PCOPY AUXPAGE, VISPAGE
   DELAY 1
 NEXT

 DELAY 9

END SUB

SUB LOADDATA

 OPEN DRIVE$ + DATAPATH$ + "SAVEDATA.REC" FOR INPUT AS #1
   INPUT #1, DUMMY$, GAMEDATA.EVENT
   INPUT #1, DUMMY$, GAMEDATA.ROUND
   INPUT #1, DUMMY$, PLAYERDATA(0).LEVEL
   INPUT #1, DUMMY$, GAMEDATA.ITEM
   INPUT #1, DUMMY$, GAMEDATA.MAPROMX
   INPUT #1, DUMMY$, GAMEDATA.MAPROMY
   INPUT #1, DUMMY$, GAMEDATA.MAPSCROLLX
   INPUT #1, DUMMY$, GAMEDATA.MAPSCROLLY
   INPUT #1, DUMMY$, GAMEDATA.GRIDX
   INPUT #1, DUMMY$, GAMEDATA.GRIDY
   INPUT #1, DUMMY$, GAMEDATA.ROMDIR
   INPUT #1, DUMMY$, PLAYERDATA(0).MAXHP
   INPUT #1, DUMMY$, PLAYERDATA(0).HP
   INPUT #1, DUMMY$, PLAYERDATA(0).STRENGTH
   INPUT #1, DUMMY$, PLAYERDATA(0).DEFENSE
   INPUT #1, DUMMY$, PLAYERDATA(0).LUCK
   INPUT #1, DUMMY$, GAMEDATA.NEXTLEVEL
   INPUT #1, DUMMY$, PLAYERDATA(0).EXPPOINT
 CLOSE #1
  
 GAMEDATA.MAPROMX = GAMEDATA.MAPROMX + MAPX
 GAMEDATA.MAPROMY = GAMEDATA.MAPROMY + MAPY

 PLAYERDATA(0).NAMES = CHARDATA(0).NAMES
 PLAYERDATA(0).FIRST = CHARDATA(0).FIRST
 PLAYERDATA(0).SECOND = CHARDATA(0).SECOND
 PLAYERDATA(0).THIRD = CHARDATA(0).THIRD

 LOADMAP

END SUB

SUB LOADMAP

 LOADSCREEN GRP(19), MAPPAGE
 SCREEN , , MAPPAGE, VISPAGE

 '- check event then select patch -
 SELECT CASE GAMEDATA.EVENT
 CASE IS = 3 '- car with box -
   GET (208, 146)-(247, 177), FMVDATA
   PUT (121, 17), FMVDATA, PSET
 CASE IS = 4 '- car without box -
   GET (249, 146)-(288, 177), FMVDATA
   PUT (121, 17), FMVDATA, PSET
 CASE IS = 5 '- red castle -
   GET (290, 146)-(313, 169), FMVDATA
   PUT (81, 73), FMVDATA, PSET
 END SELECT

END SUB

SUB LOADSCREEN (S$, P)
'---------------------------------------------------------------------------'
' S$ = FILENAME (6letters, 2identifier, and 'JSV'extension)                 '
' P  = PAGE (0 - 7)                                                         '
'---------------------------------------------------------------------------'

 TEMP$ = LEFT$(LTRIM$(RTRIM$(S$)), 6)     'filename : 6letter + 2code

 DEF SEG = &HA000 + (&H200 * (P MOD 8))   'select page

 OUT &H3C4, &H2                           'Sequencer register
                                          '(The color plane write
                                          'enable register)
 FOR I = 0 TO 3
    OUT &H3C5, 2 ^ I                      'select plane I for writing
    BLOAD GRAPHICPATH$ + TEMP$ + "-" + LTRIM$(STR$(I)) + ".JSV", 0
 NEXT

 OUT &H3C5, &HF                           'set all plane for other functions

 DEF SEG

END SUB

SUB LOADTITLEGRP

 GAMEDATA.EVENT = 0

 '- load rom1(grass) -
 LOADSCREEN GRP(0), ROMPAGE
 '- load misc2 -
 LOADSCREEN GRP(18), MISC2PAGE
 '- load map -
 LOADMAP
 '- load clip1 -
 LOADSCREEN GRP(13), EXTRAPAGE

END SUB

SUB LOGO

 CLEARBUFFER

 SCREEN , , VISPAGE, VISPAGE
 FADE COLOR2BLACK
 CLS

 '- logo initialize -
 LOADSCREEN "LOGO", LOGOPAGE

 REDIM LOGOFX(505)
 LOGOCOUNTER = 0
 FX1 = 80
 FX2 = 0

 '- output logo -
 PCOPY LOGOPAGE, VISPAGE
 FADE BLACK2COLOR

 '- logo FX -
 DO
   FX1 = FX1 + 8: IF FX1 >= 236 THEN FX1 = 80
   FX2 = FX2 + 8: IF FX2 >= 236 THEN FX2 = 80
 
   PCOPY LOGOPAGE, AUXPAGE
   SCREEN , , AUXPAGE, VISPAGE
 
   GET (FX1, 59)-(FX1 + 20, 142), LOGOFX
   PUT (FX1 - 1, 59), LOGOFX, PSET
 
   GET (FX2, 59)-(FX2 + 20, 142), LOGOFX
   PUT (FX2 + 1, 59), LOGOFX, PSET

   SCREEN , , VISPAGE, VISPAGE
   PCOPY AUXPAGE, VISPAGE
 
   LOGOCOUNTER = LOGOCOUNTER + 1

   DELAY 1

 LOOP UNTIL INKEY$ <> "" OR LOGOCOUNTER >= 80

 PCOPY LOGOPAGE, VISPAGE
 SCREEN , , VISPAGE, VISPAGE

 ERASE LOGOFX

END SUB

SUB MAIN (EXITRESULT)

 '- initialize
 QUIT = FALSE
 ENDING = FALSE
 SUBMENUCALL = FALSE
 WALK = 0
 ROMWALKCOUNTER = 0
 SUBMENURESULT = 0  'NONE

 '- main loop -
 CLEARBUFFER

 '- draw window -
 DRAWSTATUS MAPX - 70, MAPY, -1, 0, BGPAGE
 LINE (MAPX, MAPY)-(MAPX + 83, MAPY + 83), 15, B
 LINE (MAPX + 1, MAPY + 1)-(MAPX + 82, MAPY + 82), 1, B

 DO

   IF WALK = 0 THEN '- check key -
     GETKEY A$
     SUBMENUCALL = (A$ = CHR$(27))
     IF A$ = "*K" THEN
       WALK = 4
       GAMEDATA.ROMDIR = 0
       GAMEDATA.GRIDX = GAMEDATA.GRIDX - 1 - (GAMEDATA.GRIDX = 0)
     END IF
     IF A$ = "*M" THEN
       WALK = 4
       GAMEDATA.ROMDIR = 3
       GAMEDATA.GRIDX = GAMEDATA.GRIDX + 1 + (GAMEDATA.GRIDX = 23)
     END IF
     IF A$ = "*P" THEN
       WALK = 4
       GAMEDATA.ROMDIR = 1
       GAMEDATA.GRIDY = GAMEDATA.GRIDY + 1 + (GAMEDATA.GRIDY = 16)
     END IF
     IF A$ = "*H" THEN
       WALK = 4
       GAMEDATA.ROMDIR = 2
       GAMEDATA.GRIDY = GAMEDATA.GRIDY - 1 - (GAMEDATA.GRIDY = 1)
     END IF
   END IF

   IF WALK THEN
     WALK = WALK - 1
     ROMWALKCOUNTER = (ROMWALKCOUNTER + 1) MOD 8
     '- check ground, store its value -
     IF WALK = 0 THEN
       CHECK = TRUE
       GROUND = MAPDATA(GAMEDATA.GRIDX, GAMEDATA.GRIDY)
     END IF

     SELECT CASE GAMEDATA.ROMDIR
     '- left -
     CASE IS = 0
       IF GAMEDATA.MAPROMX > 31 + MAPX OR GAMEDATA.MAPSCROLLX <= 1 THEN
         GAMEDATA.MAPROMX = GAMEDATA.MAPROMX - 2
         IF GAMEDATA.MAPROMX <= -1 + MAPX THEN GAMEDATA.MAPROMX = -1 + MAPX
       ELSE
         GAMEDATA.MAPSCROLLX = GAMEDATA.MAPSCROLLX - 2
         IF GAMEDATA.MAPSCROLLX <= 1 THEN GAMEDATA.MAPSCROLLX = 1
       END IF
     '- down -
     CASE IS = 1
       IF GAMEDATA.MAPROMY <= 35 + MAPY OR GAMEDATA.MAPSCROLLY >= 65 THEN
         GAMEDATA.MAPROMY = GAMEDATA.MAPROMY + 2
         IF GAMEDATA.MAPROMY >= 60 + MAPY THEN GAMEDATA.MAPROMY = 60 + MAPY
       ELSE
         GAMEDATA.MAPSCROLLY = GAMEDATA.MAPSCROLLY + 2
         IF GAMEDATA.MAPSCROLLY >= 65 THEN GAMEDATA.MAPSCROLLY = 65
       END IF
     '- up -
     CASE IS = 2
       IF GAMEDATA.MAPROMY > 36 + MAPY OR GAMEDATA.MAPSCROLLY <= 1 THEN
         GAMEDATA.MAPROMY = GAMEDATA.MAPROMY - 2
         IF GAMEDATA.MAPROMY <= 4 + MAPY THEN GAMEDATA.MAPROMY = 4 + MAPY
       ELSE
         GAMEDATA.MAPSCROLLY = GAMEDATA.MAPSCROLLY - 2
         IF GAMEDATA.MAPSCROLLY <= 1 THEN GAMEDATA.MAPSCROLLY = 1
       END IF
     '- right -
     CASE IS = 3
       IF GAMEDATA.MAPROMX <= 30 + MAPX OR GAMEDATA.MAPSCROLLX >= 113 THEN
         GAMEDATA.MAPROMX = GAMEDATA.MAPROMX + 2
         IF GAMEDATA.MAPROMX >= 71 + MAPX THEN GAMEDATA.MAPROMX = 71 + MAPX
       ELSE
         GAMEDATA.MAPSCROLLX = GAMEDATA.MAPSCROLLX + 2
         IF GAMEDATA.MAPSCROLLX >= 113 THEN GAMEDATA.MAPSCROLLX = 113
       END IF
     END SELECT

   END IF

   '- output map -
   SCREEN , , MAPPAGE, VISPAGE
   GET (GAMEDATA.MAPSCROLLX, GAMEDATA.MAPSCROLLY)-(GAMEDATA.MAPSCROLLX + 79, GAMEDATA.MAPSCROLLY + 79), FMVDATA
   SCREEN , , BGPAGE, VISPAGE
   PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET

   PCOPY BGPAGE, AUXPAGE

   FLAGCOUNTER = (FLAGCOUNTER + 1) MOD 6
   PSETFLAG FLAGCOUNTER

   MAPROMPTN = GAMEDATA.ROMDIR * 3 + VAL(MID$("01110222", ROMWALKCOUNTER + 1, 1))
   TPSETROM GAMEDATA.MAPROMX, GAMEDATA.MAPROMY, MAPROMPTN, AUXPAGE

   PCOPY AUXPAGE, VISPAGE

   '- check submenu -
   IF SUBMENUCALL THEN
     SUBMENUCALL = FALSE
     SUBMENU MENURESULT

     SELECT CASE MENURESULT
     CASE IS = 1: RAINBOWFX: LOADDATA: DRAWSTATUS MAPX - 70, MAPY, -1, 0, BGPAGE
     CASE IS = 2: RAINBOWFX: SAVEDATA
     CASE IS = 3:
       QUIT = TRUE
       SCREEN , , BGPAGE, VISPAGE
       LINE (MAPX - 70, MAPY)-(MAPX - 3, MAPY + 83), 0, BF
       PCOPY BGPAGE, VISPAGE
     END SELECT
     CLEARBUFFER
   END IF

   '- check event -
   IF CHECK THEN
     CHECK = FALSE
     CHECKEVENT GROUND, BATTLERESULT
   END IF

   '- check game over -
   IF BATTLERESULT = 3 THEN LOSE = TRUE
   IF BATTLERESULT = 4 THEN ENDING = TRUE

   DELAY 1

 LOOP UNTIL QUIT OR ENDING OR LOSE

 IF LOSE THEN
   EXITRESULT = 1
 ELSEIF ENDING THEN
   EXITRESULT = 2
 ELSEIF QUIT THEN
   EXITRESULT = 3
 END IF

END SUB

SUB MAPOFF

 SCREEN , , AUXPAGE, VISPAGE

 '- erase border -
 LINE (MAPX, MAPY)-(MAPX + 83, MAPY + 83), 0, B
 LINE (MAPX + 1, MAPY + 1)-(MAPX + 82, MAPY + 82), 0, B

 '- erase window -
 FOR I = 0 TO 40 STEP 4
   LINE (MAPX + 2 + I, MAPY + 1)-(MAPX + 81 - I, MAPY + 82), 0, B
   LINE (MAPX + 1 + I, MAPY + 1)-(MAPX + 82 - I, MAPY + 82), 0, B
   LINE (MAPX + 0 + I, MAPY + 1)-(MAPX + 83 - I, MAPY + 82), 0, B
   LINE (MAPX - 1 + I, MAPY + 1)-(MAPX + 84 - I, MAPY + 82), 0, B
   PCOPY AUXPAGE, VISPAGE
   DELAY 1
 NEXT

END SUB

SUB MAPON

 '- rpg2-type open fx -
 FOR I = 0 TO 35 STEP 5
    SCREEN , , AUXPAGE, VISPAGE
    GET (MAPX + 37 - I, MAPY + 2)-(MAPX + 41 - I, MAPY + 81), FMVDATA
    GET (MAPX + 42 + I, MAPY + 2)-(MAPX + 46 + I, MAPY + 81), FMVMASK
    SCREEN , , VISPAGE, VISPAGE
    PUT (MAPX + 37 - I, MAPY + 2), FMVDATA, PSET
    PUT (MAPX + 42 + I, MAPY + 2), FMVMASK, PSET
    DELAY 1
 NEXT

 PCOPY AUXPAGE, VISPAGE

END SUB

SUB MIDDEMO (N)

 SELECT CASE N
 CASE IS = 1 '- nnv appear -
   TALK 13
   FOR CHARACT = 62 TO 64
     FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
       PSETCHAR BTLENEMYX, BTLENEMYY, FMVPTN(CHARCOUNTER, CHARACT), FMVPAGE, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT
     DELAY 9
     IF CHARACT = 63 THEN
       FOR I = 14 TO 20
         TALK I: DELAY 18
       NEXT
     END IF
   NEXT

   BTLOFF 0
   DELAY 9
   EVENTOPEN 4
   DELAY 18

   '- now candy talks(go to blue castle) -
   FOR I = 21 TO 32
     TALK I: DELAY 18
   NEXT

 CASE IS = 2 '- dra appear -
     MIDMESSAGE "  meanwhile . . . "

     EVENTOPEN 6
     FOR I = 33 TO 35
       TALK I: DELAY 18
     NEXT
     BTLOFF 0
     DELAY 18
     EVENTOPEN 2

   TALK 36
   CHARACT = 42
   FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
     PSETCHAR BTLENEMYX, BTLENEMYY, FMVPTN(CHARCOUNTER, CHARACT), ENEMYPAGE, BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT
   FOR I = 37 TO 40
     TALK I: DELAY 18
   NEXT

 CASE IS = 3 '- candy run -
   TALK 41: DELAY 18
   TALK 42: DELAY 18
   LOADSCREEN GRP(14), FMVPAGE
   SCREEN , , FMVPAGE, VISPAGE
   LINE (240, 126)-(318, 130), 14, BF '- fill (c) -
   FOR CHARACT = 65 TO 67
     FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
       PSETCHAR BTLX + 2, BTLY + 16, FMVPTN(CHARCOUNTER, CHARACT), FMVPAGE, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT
     IF CHARACT = 65 THEN
       TALK 43: DELAY 18
       TALK 44: DELAY 18
     END IF
   NEXT

   BTLOFF 0
   DELAY 27

   EVENTOPEN 7 '- ZZZ zzz ... -

   CHARACT = 1
   FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
     PSETCHAR BTLROMX, BTLROMY, FMVPTN(CHARCOUNTER, CHARACT), ROMPAGE, BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT
   DELAY 18
   CHARACT = 1
   FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
     PSETCHAR BTLROMX, BTLROMY, FMVPTN(CHARCOUNTER, CHARACT), ROMPAGE, BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT
   DELAY 18

   PSETCHAR BTLROMX, BTLROMY, 3, ROMPAGE, BGPAGE
   PCOPY BGPAGE, VISPAGE
   DELAY 18

   FOR I = 0 TO 95
     PCOPY BGPAGE, AUXPAGE
     SCREEN , , AUXPAGE, VISPAGE

     ZZZCOUNTER = ZZZCOUNTER + 1
     ZZZPTN = VAL(MID$("000000001111111122222222233333333333", (ZZZCOUNTER MOD 36) + 1, 1))

     TPSETZZZ BTLROMX + 15, BTLROMY - 2, ZZZPTN, 0, AUXPAGE

     PCOPY AUXPAGE, VISPAGE
     DELAY 1
   NEXT
   PCOPY BGPAGE, VISPAGE
   BTLOFF 0

   MIDMESSAGE "A few hours later!"

   EVENTOPEN 8 '- trig appear -
   TALK 45: DELAY 18
   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
   PCOPY BGPAGE, VISPAGE
   FOR I = 46 TO 50
     TALK I: DELAY 18
   NEXT

 CASE IS = 4 '- rom sleep again -
   TALK 52: DELAY 18 ' now back to zzz
   PSETCHAR BTLROMX, BTLROMY, 3, ROMPAGE, BGPAGE: PCOPY BGPAGE, VISPAGE

   DELAY 18
   BTLOFF 0

   '- a few hours later -
   MIDMESSAGE "A few hours later!"

   DELAY 27
   EVENTOPEN 9 '- candy appear -

   '- wake up you idiot ! -
   TALK 53: DELAY 18
   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE: PCOPY BGPAGE, VISPAGE
   FOR I = 54 TO 62
     TALK I: DELAY 18
   NEXT

 CASE IS = 5 '- car demo #1 -
   FOR I = 63 TO 65
     TALK I: DELAY 18
   NEXT
   TALK 66

   '- trig appear -
   CHARACT = 38
   FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
     PSETCHAR BTLENEMYX, BTLENEMYY, FMVPTN(CHARCOUNTER, CHARACT), ENEMYPAGE, BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT

   '- turn head(s) -
   FOR I = 0 TO 5
     PSETHEAD VAL(MID$("2211001122", I + 5, 1)), BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT

   CHARACT = 70
   FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
     PSETCHAR BTLROMX, BTLROMY, FMVPTN(CHARCOUNTER, CHARACT), FMVPAGE, BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT

 CASE IS = 6, 7
   IF N = 6 THEN '- shop with box -
     FOR I = 68 TO 81
       TALK I: DELAY 18
     NEXT
     TALK 82
   ELSE '- 2 cookies -
     TALK 112: DELAY 18
     TALK 113: DELAY 18 * 0
   END IF

   LOADSCREEN GRP(14), FMVPAGE
   FOR CHARACT = 51 TO 52
     FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
       PSETCHAR BTLENEMYX + 12, BTLENEMYY + 3, FMVPTN(CHARCOUNTER, CHARACT), FMVPAGE, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT
   NEXT

 CASE IS = 8 '- for final battle -
   FOR I = 83 TO 89
     TALK I: DELAY 18
   NEXT

 CASE IS = 9 '- after final battle FINAL DEMO !! -
   SCREEN , , BGPAGE, VISPAGE
   LINE (MAPX - 91, MAPY)-(MAPX - 24, MAPY + 83), 0, BF
   LINE (MAPX + 106, MAPY)-(MAPX + 173, MAPY + 83), 0, BF
   LINE (BTLX, BTLY + 58)-(BTLX + 124, BTLY + 105), 0, BF
   LINE (BTLX, BTLY - 29)-(BTLX + 124, BTLY - 4), 0, BF
   PCOPY BGPAGE, VISPAGE

   DELAY 18
   TALK 90: DELAY 18

   LOADSCREEN GRP(16), FMVPAGE
   LOADSCREEN GRP(15), EXTRAPAGE

   PSETCHAR BTLROMX, BTLROMY, 53, FMVPAGE, BGPAGE
   PCOPY BGPAGE, VISPAGE

   FOR CHARACT = 71 TO 78
     FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
       PSETCHAR BTLENEMYX + 1, BTLENEMYY - 7, FMVPTN(CHARCOUNTER, CHARACT), FMVPAGE, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT

     IF CHARACT = 74 THEN TALK 91

   NEXT

   DELAY 18

   FOR I = 92 TO 95
     TALK I: DELAY 18
   NEXT

   CHARACT = 79
   FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
     PSETCHAR BTLX + 48, BTLY + 21, FMVPTN(CHARCOUNTER, CHARACT), EXTRAPAGE, BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT

   PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
   PCOPY BGPAGE, VISPAGE

   TALK 96: DELAY 18

   FOR CHARACT = 80 TO 81
     FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
       PSETCHAR BTLX + 48, BTLY + 21, FMVPTN(CHARCOUNTER, CHARACT), EXTRAPAGE, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT
   NEXT

   TALK 97: DELAY 18

   '- dream fx !! -
   FADE COLOR2WHITE
   DRAWFRAME 1
   COPYPANEL 7, 0
   PCOPY BGPAGE, VISPAGE
   FADE WHITE2COLOR

   TALK 98: DELAY 18

   FOR CHARACT = 82 TO 88
     FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
       PSETCHAR BTLX + 66, BTLY + 2, FMVPTN(CHARCOUNTER, CHARACT), EXTRAPAGE, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT
     IF CHARACT = 87 THEN TALK 99: DELAY 18
   NEXT

   TALK 100

   FOR CHARACT = 89 TO 90
     FOR CHARCOUNTER = 1 TO FMVPTN(0, CHARACT)
       PSETCHAR BTLX + 19, BTLY + 2, FMVPTN(CHARCOUNTER, CHARACT), EXTRAPAGE, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT
   NEXT

   FOR I = 101 TO 103
     TALK I: DELAY 18
   NEXT
   TALK 104

   COPYPANEL 8, 0
   PCOPY BGPAGE, VISPAGE
   DELAY 18 * 4

   BTLOFF 0
   DELAY 36

 CASE IS = 10
   DRAWFRAME 1
   COPYPANEL 10, 0
   BTLON

   DELAY 18

   FOR STAFF = 0 TO 6
     FOR L = 0 TO 18
       PSETPANEL STAFF, L, BGPAGE
       PCOPY BGPAGE, VISPAGE
       DELAY 1
     NEXT

     DELAY 18

     IF STAFF > 0 AND STAFF < 6 THEN
       FOR I = 0 TO 30
         CHARNUM = VAL(MID$("20010", STAFF, 1))
         PSETSTAFF CHARNUM, I, BGPAGE
         PCOPY BGPAGE, VISPAGE
         DELAY 1

         IF I = 15 THEN
           FOR J = 0 TO 8
             PSETNAME BTLX + 35, BTLY + 28, J + CHARNUM * 10, VISPAGE
             DELAY 1
           NEXT
           DELAY 27
           PSETNAME BTLX + 35, BTLY + 28, 9 + CHARNUM * 10, VISPAGE
           DELAY 2
           PSETNAME BTLX + 35, BTLY + 28, 30, VISPAGE
           DELAY 1
         END IF
       NEXT
     END IF


     IF STAFF <> 6 THEN
       DELAY 18
       FOR L = 18 TO 0 STEP -1
         PSETPANEL STAFF, L, BGPAGE
         PCOPY BGPAGE, VISPAGE
         DELAY 1
       NEXT
     ELSE
       FOR I = 0 TO 2
         PSETJSVSOFT I, BGPAGE
         PCOPY BGPAGE, VISPAGE
         DELAY 1
       NEXT
     END IF
   NEXT

   DELAY 90
   BTLOFF 0

 END SELECT

END SUB

SUB MIDMESSAGE (MSG$)

 X = 93: Y = 50
 CLOUD X, Y, 0, 0
 DRAWFONT X + 4, Y + 10, 1, 15, 1, MSG$
 DELAY 36: PCOPY BGPAGE, VISPAGE

END SUB

SUB NEWCOLOR

 '- set NEW color -
 OUT &H3C8, 0
 FOR I = 0 TO 23
   '- original palette -
   'OUT &H3C9, VAL(MID$("250009270918451800000000000000006363545509254563", I * 2 + 1, 2))
   'OUT &H3C9, VAL(MID$("260054630927095400000000000000000921545436264563", I * 2 + 1, 2))
   'OUT &H3C9, VAL(MID$("270009276363096300000000000000000921093609274563", I * 2 + 1, 2))
   
   '- modified palette -
   OUT &H3C9, VAL(MID$("250009270918451800000000000000006363545509544563", I * 2 + 1, 2))
   OUT &H3C9, VAL(MID$("260054630927095400000000000000000921545436184563", I * 2 + 1, 2))
   OUT &H3C9, VAL(MID$("270009276363096300000000000000000921093609454563", I * 2 + 1, 2))
 NEXT

END SUB

SUB NUMBERFX (X, Y, NUM, PTN, P)

 SELECT CASE PTN
 '- draw number -
 CASE IS = 0
   SCREEN , , MISCPAGE, VISPAGE
   LINE (140, 141)-(174, 149), 0, BF
   LINE (140, 151)-(174, 159), 15, BF

   MSG$ = MID$("+", 2 + (SGN(NUM) > 0), 1) + LTRIM$(STR$(NUM))

   SELECT CASE LEN(LTRIM$(MSG$))
   CASE IS = 1: MSG$ = "  " + MSG$
   CASE IS = 2, 3: MSG$ = " " + MSG$
   END SELECT

   MSGLEN = LEN(LTRIM$(MSG$))

   FOR I = 0 TO 4
     N = INSTR(" 0123456789+-", MID$(MSG$, I + 1, 1)) - 1
     IF N THEN
       GET (98 + (N - 1) * 8, 170)-(104 + (N - 1) * 8, 178), FMVDATA
       GET (98 + (N - 1) * 8, 180)-(104 + (N - 1) * 8, 188), FMVMASK
       PUT (143 - (MSGLEN AND 1) * 3 + (I * 7), 141), FMVDATA, PSET
       PUT (143 - (MSGLEN AND 1) * 3 + (I * 7), 141 + 10), FMVMASK, PSET
     END IF
   NEXT

 '- animate number -
 CASE ELSE
   SCREEN , , MISCPAGE, VISPAGE
   GET (140, 141)-(174, 149), FMVDATA
   GET (140, 151)-(174, 159), FMVMASK
   SCREEN , , P, VISPAGE
   YPOS = -VAL(MID$("00061011060002000000000000000000", PTN * 2 - 1, 2))
   PUT (X, Y + YPOS), FMVMASK, AND
   PUT (X, Y + YPOS), FMVDATA, OR
 END SELECT

END SUB

SUB PSETCHAR (X, Y, N, SOURCEPAGE, TARGETPAGE)

 SCREEN , , SOURCEPAGE, VISPAGE
 XX = (N MOD 10)
 YY = (N \ 10)
 GET (XX * 32 + 1, YY * 33 + 1)-(XX * 32 + 31, YY * 33 + 32), FMVDATA
 SCREEN , , TARGETPAGE, VISPAGE
 PUT (X, Y), FMVDATA, PSET

END SUB

SUB PSETCHV (N, P)

 X = N MOD 4
 Y = N \ 4
 SCREEN , , MISCPAGE, VISPAGE
 GET (113 + X * 18, 31 + Y * 16)-(129 + X * 18, 45 + Y * 16), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (BTLX + 54, BTLY - 22), FMVDATA, PSET

END SUB

SUB PSETCURSOR (X, Y, N, P)

 CURX = N MOD 2
 CURY = N \ 2
 SCREEN , , MISCPAGE, VISPAGE
 GET (145 + CURX * 14, 63 + CURY * 22)-(157 + CURX * 14, 83 + CURY * 22), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVDATA, PSET

END SUB

SUB PSETFLAG (N)

 XX = (N MOD 6)
 SCREEN , , MAPPAGE, VISPAGE
 GET (1 + XX * 8, 178)-(1 + XX * 8 + 6, 178 + 5), FMVDATA
 PUT (20, 1), FMVDATA, PSET

END SUB

SUB PSETHEAD (N, P)

 SCREEN , , MISCPAGE, VISPAGE
 GET (59 + N * 13, 170)-(70 + N * 13, 179), FMVDATA
 GET (59 + N * 13, 181)-(70 + N * 13, 191), FMVMASK
 SCREEN , , P, VISPAGE
 PUT (BTLX + 36, BTLY + 7), FMVDATA, PSET
 PUT (BTLX + 76, BTLY + 4), FMVMASK, PSET

END SUB

SUB PSETJSVSOFT (N, P)
 
 SCREEN , , MISC2PAGE, VISPAGE
 GET (1, 134 + (N * 15))-(72, 147 + (N * 15)), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (BTLX + 31, BTLY + 29), FMVDATA, PSET

END SUB

SUB PSETNAME (X, Y, N, P)

 SCREEN , , MISC2PAGE, VISPAGE
 GET (262, 1 + N * 6)-(262 + 43, 1 + N * 6 + 4), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVDATA, PSET

END SUB

SUB PSETPANEL (N, L, P)

 IF L THEN
   SCREEN , , MISC2PAGE, VISPAGE
   GET (138, 1 + (N * 19) + (18 - L))-(200, 18 + (N * 19)), FMVDATA
   SCREEN , , P, VISPAGE
   PUT (BTLX + 20, BTLY + 2), FMVDATA, PSET
 END IF

END SUB

SUB PSETPATCH (X, Y, N, P)

 SCREEN , , MISCPAGE, VISPAGE
 XX = (N MOD 4)
 GET (59 + XX * 32, 108)-(89 + XX * 32, 139), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVDATA, PSET

END SUB

SUB PSETSTAFF (STAFF, N, P)

 PTN = VAL(MID$("012" + STRING$(25, 51) + "210", N + 1, 1))
 SCREEN , , MISC2PAGE, VISPAGE
 GET (202 + (PTN * 15), 1 + (STAFF * 31))-(215 + (PTN * 15), 30 + (STAFF * 31)), FMVDATA
 SCREEN , , P, VISPAGE
 PUT (BTLX + 85, BTLY + 14), FMVDATA, PSET

END SUB

SUB RAINBOWFX

 SCREEN , , VISPAGE, VISPAGE
 PSET (MAPX + 1, MAPY + 52), 1
 PSET (MAPX + 50, MAPY + 1), 1

 FOR I = 0 TO 79 STEP 2
   DRAW "BM" + STR$(MAPX + 2) + "," + STR$(MAPY + I + 2) + "C" + STR$((I + 1) MOD 16)
   FOR J = 1 TO 39: DRAW "FE": NEXT: DRAW "F"
   DRAW "BM" + STR$(MAPX + 2) + "," + STR$(MAPY + 81 - I) + "C" + STR$((I + 1) MOD 16)
   FOR J = 1 TO 39: DRAW "EF": NEXT: DRAW "E"
 NEXT

 DELAY 1

END SUB

SUB RANDOMBATTLE (RESULT)

 MAPOFF

 '- select new enemy -
 ENEMYNUM = INT(RND * 6) + 1

 '- move status -
 STATUSFX 0

 '- init enemy data, menu -
 INITENEMYDATA ENEMYNUM

 '- load graphic -
 LOADSCREEN GRP(15), FMVPAGE
 LOADSCREEN GRP(VAL(MID$("0000000120", ENEMYNUM, 1))), ROMPAGE
 LOADSCREEN GRP(ENEMYNUM + 2), ENEMYPAGE

 '- select battle field -
 DRAWFRAME 1
 COPYPANEL VAL(MID$("0000003245", ENEMYNUM, 1)), 0

 '- update -
 PSETCHAR BTLROMX, BTLROMY, 0, ROMPAGE, BGPAGE
 PSETCHAR BTLENEMYX, BTLENEMYY, 0, ENEMYPAGE, BGPAGE

 BTLON

 '- fight -
 BATTLE ENEMYNUM, RESULT

 IF RESULT = 3 THEN
   DELAY 18

   BTLOFF 1

   SCREEN , , BGPAGE, VISPAGE
   LINE (MAPX - 91, MAPY)-(MAPX - 24, MAPY + 83), 0, BF
   PCOPY BGPAGE, VISPAGE

   DELAY 18

   CLRSCR VISPAGE

 ELSE
   DELAY 18
   BTLOFF 0

   '- move status -
   STATUSFX 1

   DRAWMAP

 END IF

 CLEARBUFFER

END SUB

SUB ROMACTION (N)

 ROM = TRUE
 ROMACT = 51 + (N = 1) * 44
 ROMCOUNTER = 0
 LC = 0

 DO
   LC = LC + 1

   '- output cel -
   IF ROM THEN
     ROMCOUNTER = ROMCOUNTER + 1
     ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
     IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
       ROMACT = ROMACT + 1
       IF ROMACT = 53 THEN ROM = FALSE
       IF ROMACT = 9 THEN
         ROM = FALSE
         NUMBER = TRUE
         NUMBERCOUNTER = -1

         RECOVER = 0
         FOR I = 1 TO 10 + (PLAYERDATA(0).MAXHP \ 10) + (PLAYERDATA(0).LUCK / 2.5) + INT(RND * 5)
           IF PLAYERDATA(0).HP < PLAYERDATA(0).MAXHP THEN
             PLAYERDATA(0).HP = PLAYERDATA(0).HP + 1
             RECOVER = RECOVER + 1
           END IF
         NEXT
         UPDATEHPBAR PLAYERDATA(0).HP, 0, BGPAGE
         DRAWSTATUS MAPX - 91, MAPY, 1, 0, BGPAGE

       END IF
       ROMCOUNTER = 0
     END IF
   END IF

   IF N = 0 THEN
     PSETCHAR BTLROMX - 12, BTLROMY + 3, ROMPTN, FMVPAGE, BGPAGE
   ELSE
     PSETCHAR BTLROMX, BTLROMY, ROMPTN, ROMPAGE, BGPAGE
   END IF

   PCOPY BGPAGE, AUXPAGE

   IF NUMBER THEN
     NUMBERCOUNTER = NUMBERCOUNTER + 1
     IF NUMBERCOUNTER >= 16 THEN
         NUMBER = FALSE
         ROM = FALSE
     END IF

     NUMBERFX BTLROMX - 5, BTLROMY + 21, RECOVER, NUMBERCOUNTER, AUXPAGE
   END IF

   PCOPY AUXPAGE, VISPAGE

   DELAY 1

 LOOP UNTIL NOT (ROM OR NUMBER)

END SUB

SUB ROMATTACK (ENEMYNUM, BATTLERESULT)

 '- init -
 ROM = TRUE
 ROMCOUNTER = 0

 ROMACT = 2 - ((RND * 100) < (20 + ((RND * 10) - 5) + PLAYERDATA(0).LUCK / 2.5))

 IF (ENEMYNUM = 7 OR ENEMYNUM = 10) AND ((RND * 100) < PLAYERDATA(1).LUCK) THEN
   DAMAGE = 0
   ATTACKRESULT = 2
 '- else calc damage -
 ELSE
   ROMATKPOWER = PLAYERDATA(0).STRENGTH

   '- critical attack -
   IF ROMACT = 3 THEN ROMATKPOWER = ROMATKPOWER * (1.2 + RND * .3)
   ENEMYDEFPOWER = PLAYERDATA(1).DEFENSE

   DAMAGE = (ROMATKPOWER - ENEMYDEFPOWER)

   IF DAMAGE <= 0 THEN DAMAGE = 0

   DAMAGE = DAMAGE + INT(RND * (PLAYERDATA(0).LUCK \ 10 + 2))

   '- if death -
   IF DAMAGE >= PLAYERDATA(1).HP THEN
     DAMAGE = PLAYERDATA(1).HP
     ATTACKRESULT = 3
     BATTLERESULT = 1
   '- else normal hit -
   ELSE
     ATTACKRESULT = 1
   END IF
 END IF

 PLAYERDATA(1).HP = PLAYERDATA(1).HP - DAMAGE

 '- attack animation start -
 LC = 0
 DO
   LC = LC + 1

   '- init weapon animation -
   IF ROMACT = 2 AND LC = 13 THEN
     ROMWEAPON = TRUE
     ROMWEAPONX = BTLX + 31
     ROMWEAPONY = BTLY + 28
     ROMWEAPONTYP = 0
     ROMWEAPONPTN = 0
     IF ATTACKRESULT <> 2 THEN '- if not block -
       ROMWEAPONLEN = VAL(MID$("16161616161616161616", ENEMYNUM * 2 - 1, 2))
     ELSE
       ROMWEAPONLEN = VAL(MID$("16161616161615161612", ENEMYNUM * 2 - 1, 2))
     END IF
   ELSEIF ROMACT = 3 AND LC = 10 THEN
     ROMWEAPON = TRUE
     ROMWEAPONX = BTLX + 23
     ROMWEAPONY = BTLY + 35
     ROMWEAPONTYP = 1
     ROMWEAPONPTN = 0
     IF ATTACKRESULT <> 2 THEN '- if not block -
       ROMWEAPONLEN = VAL(MID$("16161616161616161616", ENEMYNUM * 2 - 1, 2))
     ELSE
       ROMWEAPONLEN = VAL(MID$("16161616161615161613", ENEMYNUM * 2 - 1, 2))
     END IF
   END IF

   '- init enemy action -
   SELECT CASE ATTACKRESULT
   CASE IS = 1 '- normal hit -
     IF ROMACT = 2 THEN '- rom normal attack -
       IF LC = VAL(MID$("25262626272826262627", ENEMYNUM * 2 - 1, 2)) THEN
         ENEMYACT = VAL(MID$("14353535301943353548", ENEMYNUM * 2 - 1, 2))
         ENEMYCOUNTER = 0
         ENEMY = TRUE
       END IF
     ELSE '- rom special attack -
       IF LC = VAL(MID$("24232323242623232325", ENEMYNUM * 2 - 1, 2)) THEN
         ENEMYACT = VAL(MID$("14353535301943353548", ENEMYNUM * 2 - 1, 2))
         ENEMYCOUNTER = 0
         ENEMY = TRUE
       END IF
     END IF
   CASE IS = 2 '- block -
     IF ROMACT = 2 THEN '- rom normal attack -
       IF LC = VAL(MID$("25262626272818262620", ENEMYNUM * 2 - 1, 2)) THEN
         ENEMYACT = VAL(MID$("14353535301945353547", ENEMYNUM * 2 - 1, 2))
         ENEMYCOUNTER = 0
         ENEMY = TRUE
       END IF
     ELSE '- rom special attack -
       IF LC = VAL(MID$("24232323242615232318", ENEMYNUM * 2 - 1, 2)) THEN
         ENEMYACT = VAL(MID$("14353535301945353547", ENEMYNUM * 2 - 1, 2))
         ENEMYCOUNTER = 0
         ENEMY = TRUE
       END IF
     END IF
   CASE IS = 3 '- death -
     IF ROMACT = 2 THEN '- rom normal attack -
       IF LC = VAL(MID$("25262626272826262627", ENEMYNUM * 2 - 1, 2)) THEN
         ENEMYACT = VAL(MID$("14353535312044353548", ENEMYNUM * 2 - 1, 2))
         ENEMYCOUNTER = 0
         ENEMY = TRUE
       END IF
     ELSE '- rom special attack -
       IF LC = VAL(MID$("24232323242623232325", ENEMYNUM * 2 - 1, 2)) THEN
         ENEMYACT = VAL(MID$("14353535312044353548", ENEMYNUM * 2 - 1, 2))
         ENEMYCOUNTER = 0
         ENEMY = TRUE
       END IF
     END IF
   END SELECT

   '- calc rom animation -
   IF ROM THEN
     ROMCOUNTER = ROMCOUNTER + 1
     ROMPTN = FMVPTN(ROMCOUNTER, ROMACT)
     IF ROMCOUNTER >= FMVPTN(0, ROMACT) THEN
       ROM = FALSE
       ROMCOUNTER = 0
       ROMPTN = 0
     END IF
   END IF

   '- calc enemy animation -
   IF ENEMY THEN
     ENEMYCOUNTER = ENEMYCOUNTER + 1
     ENEMYPTN = FMVPTN(ENEMYCOUNTER, ENEMYACT)
     IF ENEMYCOUNTER >= FMVPTN(0, ENEMYACT) THEN
       IF ATTACKRESULT = 3 THEN '- if death then -
         '- if end of long animation then end -
         IF ENEMYACT = VAL(MID$("15373737312144373750", ENEMYNUM * 2 - 1, 2)) THEN
           ENEMY = FALSE
           ENEMYCOUNTER = 0
           '- wait a litle longer -
           EXTRA = TRUE
           EXTRACOUNTER = VAL(MID$("00000000000000000000", ENEMYNUM * 2 - 1, 2)) + 5
         '- else extend death animation -
         ELSE
           IF ENEMYNUM = 8 AND ENEMYACT = 35 THEN
             DELAY 18: TALK 51: DELAY 18 ' see you later
           END IF
           IF ENEMYNUM = 9 AND ENEMYACT = 35 THEN
             DELAY 18: TALK 67: DELAY 18 ' i give up
           END IF

           ENEMYACT = ENEMYACT + 1
           ENEMYCOUNTER = 0
         END IF
       '- if 'damage' or 'block' then just end animation -
       ELSE
         ENEMY = FALSE
         ENEMYCOUNTER = 0
         ENEMYPTN = 0
         '- wait a litle longer -
         EXTRA = TRUE
         EXTRACOUNTER = VAL(MID$("03020202010902020203", ENEMYNUM * 2 - 1, 2)) + 10
       END IF
     END IF
   END IF

   '- output cel -
   PSETCHAR BTLROMX, BTLROMY, ROMPTN, ROMPAGE, BGPAGE
   PSETCHAR BTLENEMYX, BTLENEMYY, ENEMYPTN, ENEMYPAGE, BGPAGE

   PCOPY BGPAGE, AUXPAGE

   IF ROMWEAPON THEN
     ROMWEAPONX = ROMWEAPONX + 4
     ROMWEAPONLEN = ROMWEAPONLEN - 1
     IF ROMWEAPONLEN = 0 THEN
       ROMWEAPON = FALSE
       IF ATTACKRESULT = 2 THEN
         STAR = TRUE
         STARX = BTLX + 88
         IF ENEMYNUM = 10 THEN STARX = STARX - 10
         STARY = BTLY + 28 - (ROMACT = 3) * 8
         STARPTN = -1
       ELSE
         SPARK = TRUE
         SPARKX = BTLX + 90
         SPARKY = BTLY + 28 - (ROMACT = 3) * 8
         SPARKPTN = -1
         NUMBER = TRUE
         NUMBERCOUNTER = -1
         '- update hp bar -
         UPDATEHPBAR PLAYERDATA(1).HP, 1, BGPAGE
         DRAWSTATUS MAPX + 106, MAPY, 1, 1, BGPAGE
       END IF
     END IF

     IF ROMACT = 3 THEN ROMWEAPONPTN = (LC MOD 4) \ 2
     TPSETWEAPON ROMWEAPONX, ROMWEAPONY, ROMWEAPONPTN, ROMWEAPONTYP, AUXPAGE
   END IF

   IF SPARK THEN
     SPARKPTN = SPARKPTN + 1
     IF SPARKPTN = 3 THEN SPARK = FALSE
     TPSETSPARK SPARKX, SPARKY, 0, SPARKPTN, AUXPAGE
   END IF

   IF STAR THEN
     STARPTN = STARPTN + 1
     IF STARPTN = 4 THEN STAR = FALSE
     TPSETSPARK STARX, STARY, 1, STARPTN, AUXPAGE
   END IF

   IF NUMBER THEN
     NUMBERCOUNTER = NUMBERCOUNTER + 1
     IF NUMBERCOUNTER >= 16 THEN NUMBER = FALSE
     NUMBERFX BTLENEMYX + 4, BTLENEMYY + 21, -DAMAGE, NUMBERCOUNTER, AUXPAGE
   END IF

   PCOPY AUXPAGE, VISPAGE

   DELAY 1

   IF EXTRA THEN EXTRACOUNTER = EXTRACOUNTER - 1

 LOOP UNTIL EXTRACOUNTER < 0

END SUB

SUB SAVEDATA

 OPEN DRIVE$ + DATAPATH$ + "SAVEDATA.REC" FOR OUTPUT AS #1
   PRINT #1, "EVENT NUMBER                      -> ,"; GAMEDATA.EVENT
   PRINT #1, "BATTLE ROUND                      -> ,"; GAMEDATA.ROUND
   PRINT #1, "LEVEL                             -> ,"; PLAYERDATA(0).LEVEL
   PRINT #1, "ITEM          (-1=HAVE / 0=DON'T) -> ,"; GAMEDATA.ITEM
   PRINT #1, "ROM X POS (MAP)   *do not change* -> ,"; GAMEDATA.MAPROMX - MAPX
   PRINT #1, "ROM Y POS (MAP)   *do not change* -> ,"; GAMEDATA.MAPROMY - MAPY
   PRINT #1, "MAP X POS         *do not change* -> ,"; GAMEDATA.MAPSCROLLX
   PRINT #1, "MAP Y POS         *do not change* -> ,"; GAMEDATA.MAPSCROLLY
   PRINT #1, "ROM X POS         *do not change* -> ,"; GAMEDATA.GRIDX
   PRINT #1, "ROM Y POS         *do not change* -> ,"; GAMEDATA.GRIDY
   PRINT #1, "ROM'S DIR         *do not change* -> ,"; GAMEDATA.ROMDIR
   PRINT #1, "MAX HP     (0 TO 200)             -> ,"; PLAYERDATA(0).MAXHP
   PRINT #1, "CURRENT HP (0 TO MAX HP)          -> ,"; PLAYERDATA(0).HP
   PRINT #1, "STRENGTH   (0 TO 50)              -> ,"; PLAYERDATA(0).STRENGTH
   PRINT #1, "DEFENCE    (0 TO 40)              -> ,"; PLAYERDATA(0).DEFENSE
   PRINT #1, "LUCK       (0 TO 40)              -> ,"; PLAYERDATA(0).LUCK
   PRINT #1, "NEXTLEVEL  (0 TO ?)               -> ,"; GAMEDATA.NEXTLEVEL
   PRINT #1, "EXPERIENCE (0 TO ?)               -> ,"; PLAYERDATA(0).EXPPOINT
 CLOSE #1

END SUB

SUB SCROLLTEXT (X, Y)

 SCROLLX = X + 4
 SCROLLY = Y + 2
 SCREEN , , VISPAGE, VISPAGE

 '- unrolled loop! -
 FOR I = 1 TO 4
   GET (SCROLLX, SCROLLY)-(SCROLLX + 125, SCROLLY + 24), FMVDATA
   PUT (SCROLLX, SCROLLY - 1), FMVDATA, PSET
   GET (SCROLLX, SCROLLY)-(SCROLLX + 125, SCROLLY + 24), FMVDATA
   PUT (SCROLLX, SCROLLY - 1), FMVDATA, PSET
   GET (SCROLLX, SCROLLY)-(SCROLLX + 125, SCROLLY + 24), FMVDATA
   PUT (SCROLLX, SCROLLY - 1), FMVDATA, PSET
   DELAY 1
 NEXT

END SUB

SUB SETROMPOS (N)

 GAMEDATA.ROMDIR = 1

 SELECT CASE N
 CASE IS = 0
   GAMEDATA.MAPSCROLLX = 113
   GAMEDATA.MAPSCROLLY = 65
   GAMEDATA.MAPROMX = 47 + MAPX
   GAMEDATA.MAPROMY = 60 + MAPY
   GAMEDATA.GRIDX = 20
   GAMEDATA.GRIDY = 16
 CASE IS = 1
   GAMEDATA.MAPSCROLLX = 25
   GAMEDATA.MAPSCROLLY = 65
   GAMEDATA.MAPROMX = 31 + MAPX
   GAMEDATA.MAPROMY = 36 + MAPY
   GAMEDATA.GRIDX = 7
   GAMEDATA.GRIDY = 13
 CASE IS = 2
   GAMEDATA.MAPSCROLLX = 1
   GAMEDATA.MAPSCROLLY = 1
   GAMEDATA.MAPROMX = 15 + MAPX
   GAMEDATA.MAPROMY = 20 + MAPY
   GAMEDATA.GRIDX = 2
   GAMEDATA.GRIDY = 3
 CASE IS = 3
   GAMEDATA.MAPSCROLLX = 105
   GAMEDATA.MAPSCROLLY = 1
   GAMEDATA.MAPROMX = 31 + MAPX
   GAMEDATA.MAPROMY = 36 + MAPY
   GAMEDATA.GRIDX = 17
   GAMEDATA.GRIDY = 5
 CASE IS = 4
   GAMEDATA.MAPSCROLLX = 57
   GAMEDATA.MAPSCROLLY = 49
   GAMEDATA.MAPROMX = 31 + MAPX
   GAMEDATA.MAPROMY = 36 + MAPY
   GAMEDATA.GRIDX = 11
   GAMEDATA.GRIDY = 11
 END SELECT

END SUB

SUB STATUSFX (N)

 '- move status -

 IF N = 0 THEN
   CLRSCR BGPAGE
   X = MAPX - 70
   Y = MAPY

   DRAWSTATUS X, Y, -1, 0, BGPAGE
   GET (X, Y)-(X + 75, Y + 83), FMVDATA

   FOR I = 0 TO 3
     PUT (X - I * 7, Y), FMVDATA, PSET
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT

   DRAWSTATUS MAPX - 91, MAPY, -1, 0, BGPAGE

 ELSE
   CLRSCR BGPAGE
   X = MAPX - 91
   Y = MAPY

   DRAWSTATUS X, Y, -1, 0, BGPAGE
   GET (X - 8, Y)-(X + 67, Y + 83), FMVDATA

   FOR I = 0 TO 3
     PUT (X + I * 7 - 8, Y), FMVDATA, PSET
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT

   DRAWSTATUS MAPX - 70, MAPY, -1, 0, BGPAGE

 END IF

END SUB

SUB SUBMENU (RESULT)

 CLEARBUFFER

 QUIT = FALSE
 CONTROL = TRUE
 SELECTED = FALSE

 CHOICE = 0
 CURSORY = 0
 CURSORPTN = 1

 DRAWSUBMENU -1
 DRAWSUBMENU CHOICE

 DO

   IF CONTROL THEN
     GETKEY A$

     SELECTED = (A$ = " ") OR (A$ = CHR$(13))
     QUIT = (A$ = CHR$(27))

     IF A$ = "*P" AND CHOICE < 2 THEN
       CONTROL = FALSE
       CHOICE = CHOICE + 1
       CURSORMOVE = 7
       CURSORDIR = 2
     END IF
     IF A$ = "*H" AND CHOICE > 0 THEN
       CONTROL = FALSE
       CHOICE = CHOICE - 1
       CURSORMOVE = 7
       CURSORDIR = -2
     END IF
   END IF

   IF CONTROL THEN
     CURSORPTN = 1
     DRAWSUBMENU CHOICE
   ELSE
     CURSORPTN = 0
     DRAWSUBMENU -2
   END IF

   IF CURSORMOVE > 0 THEN
     CURSORMOVE = CURSORMOVE - 1
     CURSORY = CURSORY + CURSORDIR
   ELSE
     CONTROL = TRUE
   END IF

   PSETCURSOR MAPX + 36, MAPY + 2 + CURSORY, CURSORPTN, VISPAGE

   DELAY 1

 LOOP UNTIL SELECTED OR QUIT

 RESULT = (CHOICE + 1) * (-SELECTED)

END SUB

SUB SWAPTURN (CHOICE, ENEMYNUM, SIDE)

 CURSORY = CHOICE * 10

 SCREEN , , BGPAGE, VISPAGE

 '- update bgpage, output -
 LINE (BTLX + 56, BTLY + 63)-(BTLX + 68, BTLY + 103), 15, BF
 PSETCURSOR BTLX + 56, BTLY + CURSORY + 63, (SIDE * 2), BGPAGE
 PCOPY BGPAGE, VISPAGE
 DELAY 1

 '- update auxpage, output -
 FOR I = CURSORY TO 1 STEP -2
   LINE (BTLX + 56, BTLY + 63)-(BTLX + 68, BTLY + 103), 15, BF
   PSETCURSOR BTLX + 56, BTLY + I + 63, (SIDE * 2), BGPAGE
   PCOPY BGPAGE, VISPAGE
   DELAY 1
 NEXT

 '- update auxpage, output -
 LINE (BTLX + 56, BTLY + 63)-(BTLX + 68, BTLY + 103), 15, BF
 PSETCURSOR BTLX + 56, BTLY + 63, (SIDE * 2), BGPAGE
 PCOPY BGPAGE, VISPAGE
 DELAY 1

 SIDE = (SIDE + 1) MOD 2  '- change side -

 '- update auxpage, output -
 LINE (BTLX + 56, BTLY + 63)-(BTLX + 68, BTLY + 103), 15, BF
 PSETCURSOR BTLX + 56, BTLY + I + 63, (SIDE * 2), BGPAGE
 PCOPY BGPAGE, VISPAGE
 DELAY 1

 '- MAKE : HEAD TURN(EVENT#4) -
 IF ENEMYNUM = 9 THEN
   FOR I = 0 TO 5
     PSETHEAD VAL(MID$("2211001122", I + (SIDE * 4) + 1, 1)), BGPAGE
     PCOPY BGPAGE, VISPAGE
     DELAY 1
   NEXT
 END IF

END SUB

SUB TALK (N)

 SELECT CASE N
 CASE IS = 1, 3, 5
   X = BTLX + 14: Y = BTLY - 12: CLOUD X, Y, 75, 3
 CASE IS = 2, 4, 6, 8, 10, 12
   X = BTLX - 12: Y = BTLY - 8: CLOUD X, Y, 40, 4
 CASE IS = 7, 9, 11
   X = BTLX - 26: Y = BTLY: CLOUD X, Y, 40, 3
 CASE IS = 13, 15, 17, 19, 36, 37, 39, 46, 48, 50, 52, 54, 56
   X = BTLX - 16: Y = BTLY - 12: CLOUD X, Y, 40, 3
 CASE IS = 58, 60, 62, 64, 83, 85, 87, 89, 93, 95, 97, 111
   X = BTLX - 16: Y = BTLY - 12: CLOUD X, Y, 40, 3
 CASE IS = 21, 23, 25, 27, 29, 31, 33, 35, 42, 44, 69
   X = BTLX - 16: Y = BTLY - 15: CLOUD X, Y, 40, 3
 CASE IS = 71, 73, 75, 77, 79, 81, 105, 108, 112
   X = BTLX - 16: Y = BTLY - 15: CLOUD X, Y, 40, 3
 CASE IS = 22, 24, 26, 28, 30, 32, 34, 38, 40, 41, 43, 45, 47
   X = BTLX + 24: Y = BTLY - 12: CLOUD X, Y, 50, 4
 CASE IS = 49, 51, 53, 55, 57, 59, 61, 66, 67, 68, 70, 72, 74
   X = BTLX + 24: Y = BTLY - 12: CLOUD X, Y, 50, 4
 CASE IS = 76, 78, 80, 82, 84, 86, 88, 106, 107, 109, IS >= 113
   X = BTLX + 24: Y = BTLY - 12: CLOUD X, Y, 50, 4
 CASE IS = 14, 16, 18, 20
   X = BTLX + 24: Y = BTLY - 12: CLOUD X, Y, 75, 3
 CASE IS = 63, 65, 110
   X = BTLX - 4: Y = BTLY + 28: CLOUD X, Y, 37, 1
 CASE IS = 90
   X = BTLX + 13: Y = BTLY + 3: CLOUD X, Y, 50, 4
 CASE IS = 91
   X = BTLX + 24: Y = BTLY - 17: CLOUD X, Y, 55, 4
 CASE IS = 92, 94
   X = BTLX + 24: Y = BTLY - 12: CLOUD X, Y, 50, 4
 CASE IS = 96
   X = BTLX + 14: Y = BTLY - 5: CLOUD X, Y, 40, 2
 CASE IS = 98, 99, 101, 103
   X = BTLX + 14: Y = BTLY - 25: CLOUD X, Y, 40, 4
 CASE IS = 100, 102, 104
   X = BTLX + 6: Y = BTLY - 25: CLOUD X, Y, 40, 3
 END SELECT

 SELECT CASE N
 CASE IS = 1: DRAWSCRIPT X, Y, 0, 1
 CASE IS = 2: DRAWSCRIPT X, Y, 1, 2
 CASE IS = 3: DRAWSCRIPT X, Y, 3, 1
 CASE IS = 4: DRAWSCRIPT X, Y, 4, 2
 CASE IS = 5: DRAWSCRIPT X, Y, 6, 2
 CASE IS = 6: DRAWSCRIPT X, Y, 8, 4
 CASE IS = 7: DRAWSCRIPT X, Y, 12, 1
 CASE IS = 8: DRAWSCRIPT X, Y, 13, 1
 CASE IS = 9: DRAWSCRIPT X, Y, 14, 2
 CASE IS = 10: DRAWSCRIPT X, Y, 16, 4
 CASE IS = 11: DRAWSCRIPT X, Y, 20, 2
 CASE IS = 12: DRAWSCRIPT X, Y, 22, 1
 CASE IS = 13: DRAWSCRIPT X, Y, 23, 5
 CASE IS = 14: DRAWSCRIPT X, Y, 28, 2
 CASE IS = 15: DRAWSCRIPT X, Y, 30, 1
 CASE IS = 16: DRAWSCRIPT X, Y, 31, 4
 CASE IS = 17: DRAWSCRIPT X, Y, 35, 3
 CASE IS = 18: DRAWSCRIPT X, Y, 38, 2
 CASE IS = 19: DRAWSCRIPT X, Y, 40, 2
 CASE IS = 20: DRAWSCRIPT X, Y, 42, 2
 CASE IS = 21: DRAWSCRIPT X, Y, 44, 4
 CASE IS = 22: DRAWSCRIPT X, Y, 48, 2
 CASE IS = 23: DRAWSCRIPT X, Y, 50, 3
 CASE IS = 24: DRAWSCRIPT X, Y, 53, 3
 CASE IS = 25: DRAWSCRIPT X, Y, 56, 3
 CASE IS = 26: DRAWSCRIPT X, Y, 59, 1
 CASE IS = 27: DRAWSCRIPT X, Y, 60, 4
 CASE IS = 28: DRAWSCRIPT X, Y, 64, 3
 CASE IS = 29: DRAWSCRIPT X, Y, 67, 3
 CASE IS = 30: DRAWSCRIPT X, Y, 70, 3
 CASE IS = 31: DRAWSCRIPT X, Y, 73, 1
 CASE IS = 32: DRAWSCRIPT X, Y, 74, 1
 CASE IS = 33: DRAWSCRIPT X, Y, 75, 4
 CASE IS = 34: DRAWSCRIPT X, Y, 79, 3
 CASE IS = 35: DRAWSCRIPT X, Y, 82, 3
 CASE IS = 36: DRAWSCRIPT X, Y, 85, 2
 CASE IS = 37: DRAWSCRIPT X, Y, 87, 1
 CASE IS = 38: DRAWSCRIPT X, Y, 88, 1
 CASE IS = 39: DRAWSCRIPT X, Y, 89, 2
 CASE IS = 40: DRAWSCRIPT X, Y, 91, 3
 CASE IS = 41: DRAWSCRIPT X, Y, 94, 3
 CASE IS = 42: DRAWSCRIPT X, Y, 97, 3
 CASE IS = 43: DRAWSCRIPT X, Y, 100, 1
 CASE IS = 44: DRAWSCRIPT X, Y, 101, 1
 CASE IS = 45: DRAWSCRIPT X, Y, 102, 1
 CASE IS = 46: DRAWSCRIPT X, Y, 103, 1
 CASE IS = 47: DRAWSCRIPT X, Y, 104, 2
 CASE IS = 48: DRAWSCRIPT X, Y, 106, 3
 CASE IS = 49: DRAWSCRIPT X, Y, 109, 2
 CASE IS = 50: DRAWSCRIPT X, Y, 111, 2
 CASE IS = 51: DRAWSCRIPT X, Y, 113, 2
 CASE IS = 52: DRAWSCRIPT X, Y, 115, 3
 CASE IS = 53: DRAWSCRIPT X, Y, 118, 2
 CASE IS = 54: DRAWSCRIPT X, Y, 120, 2
 CASE IS = 55: DRAWSCRIPT X, Y, 122, 2
 CASE IS = 56: DRAWSCRIPT X, Y, 124, 1
 CASE IS = 57: DRAWSCRIPT X, Y, 125, 4
 CASE IS = 58: DRAWSCRIPT X, Y, 129, 1
 CASE IS = 59: DRAWSCRIPT X, Y, 130, 2
 CASE IS = 60: DRAWSCRIPT X, Y, 132, 2
 CASE IS = 61: DRAWSCRIPT X, Y, 134, 2
 CASE IS = 62: DRAWSCRIPT X, Y, 136, 1
 CASE IS = 63: DRAWSCRIPT X, Y, 137, 6
 CASE IS = 64: DRAWSCRIPT X, Y, 143, 3
 CASE IS = 65: DRAWSCRIPT X, Y, 146, 1
 CASE IS = 66: DRAWSCRIPT X, Y, 147, 3
 CASE IS = 67: DRAWSCRIPT X, Y, 150, 3
 CASE IS = 68: DRAWSCRIPT X, Y, 153, 1
 CASE IS = 69: DRAWSCRIPT X, Y, 154, 3
 CASE IS = 70: DRAWSCRIPT X, Y, 157, 2
 CASE IS = 71: DRAWSCRIPT X, Y, 159, 4
 CASE IS = 72: DRAWSCRIPT X, Y, 163, 3
 CASE IS = 73: DRAWSCRIPT X, Y, 166, 3
 CASE IS = 74: DRAWSCRIPT X, Y, 169, 4
 CASE IS = 75: DRAWSCRIPT X, Y, 173, 4
 CASE IS = 76: DRAWSCRIPT X, Y, 177, 2
 CASE IS = 77: DRAWSCRIPT X, Y, 179, 4
 CASE IS = 78: DRAWSCRIPT X, Y, 183, 5
 CASE IS = 79: DRAWSCRIPT X, Y, 188, 5
 CASE IS = 80: DRAWSCRIPT X, Y, 193, 1
 CASE IS = 81: DRAWSCRIPT X, Y, 194, 2
 CASE IS = 82: DRAWSCRIPT X, Y, 196, 2
 CASE IS = 83: DRAWSCRIPT X, Y, 198, 4
 CASE IS = 84: DRAWSCRIPT X, Y, 202, 3
 CASE IS = 85: DRAWSCRIPT X, Y, 205, 2
 CASE IS = 86: DRAWSCRIPT X, Y, 207, 1
 CASE IS = 87: DRAWSCRIPT X, Y, 208, 1
 CASE IS = 88: DRAWSCRIPT X, Y, 209, 1
 CASE IS = 89: DRAWSCRIPT X, Y, 210, 3
 CASE IS = 90: DRAWSCRIPT X, Y, 213, 1
 CASE IS = 91: DRAWSCRIPT X, Y, 214, 1
 CASE IS = 92: DRAWSCRIPT X, Y, 215, 2
 CASE IS = 93: DRAWSCRIPT X, Y, 217, 3
 CASE IS = 94: DRAWSCRIPT X, Y, 220, 5
 CASE IS = 95: DRAWSCRIPT X, Y, 225, 2
 CASE IS = 96: DRAWSCRIPT X, Y, 227, 7
 CASE IS = 97: DRAWSCRIPT X, Y, 234, 3
 CASE IS = 98: DRAWSCRIPT X, Y, 237, 2
 CASE IS = 99: DRAWSCRIPT X, Y, 239, 2
 CASE IS = 100: DRAWSCRIPT X, Y, 241, 1
 CASE IS = 101: DRAWSCRIPT X, Y, 242, 3
 CASE IS = 102: DRAWSCRIPT X, Y, 245, 4
 CASE IS = 103: DRAWSCRIPT X, Y, 249, 1
 CASE IS = 104: DRAWSCRIPT X, Y, 250, 1
 CASE IS = 105: DRAWSCRIPT X, Y, 251, 2
 CASE IS = 106: DRAWSCRIPT X, Y, 253, 3
 CASE IS = 107: DRAWSCRIPT X, Y, 256, 1
 CASE IS = 108: DRAWSCRIPT X, Y, 257, 3
 CASE IS = 109: DRAWSCRIPT X, Y, 260, 1
 CASE IS = 110: DRAWSCRIPT X, Y, 261, 2
 CASE IS = 111: DRAWSCRIPT X, Y, 263, 1
 CASE IS = 112: DRAWSCRIPT X, Y, 264, 2
 CASE IS = 113: DRAWSCRIPT X, Y, 266, 2
 CASE IS = 114: DRAWSCRIPT X, Y, 268, 2
 CASE IS = 115: DRAWSCRIPT X, Y, 270, 2
 CASE IS = 116: DRAWSCRIPT X, Y, 272, 2
 CASE IS = 117: DRAWSCRIPT X, Y, 274, 1
 CASE IS = 118: DRAWSCRIPT X, Y, 275, 2
 CASE IS = 119: DRAWSCRIPT X, Y, 277, 2
 CASE IS = 120: DRAWSCRIPT X, Y, 279, 2
 CASE IS = 121: DRAWSCRIPT X, Y, 281, 1
 CASE IS = 122: DRAWSCRIPT X, Y, 282, 2
 CASE IS = 123: DRAWSCRIPT X, Y, 284, 3
 END SELECT
 DELAY 27

 IF N < 13 THEN
   PCOPY AUXPAGE, VISPAGE
 ELSE
   PCOPY BGPAGE, VISPAGE
 END IF

END SUB

SUB TITLE

 CLEARBUFFER

 QUIT = FALSE
 CONTROL = TRUE
 SELECTED = FALSE
 CHOICE = 0
 CURSORY = 0
 CURSORPTN = 1
 TITLECOUNTER = 0
 DEMONUM = 0

 FADE COLOR2BLACK
 CLS

 LOADTITLEGRP

 '- draw main menu -
 CLRSCR AUXPAGE
 DRAWMAINMENU -1, AUXPAGE
 DRAWMAINMENU CHOICE, AUXPAGE
 PSETCURSOR MAPX + 4, MAPY + 31 + CURSORY, CURSORPTN + 2, AUXPAGE
 PSETCURSOR MAPX + 67, MAPY + 31 + CURSORY, CURSORPTN, AUXPAGE
 PCOPY AUXPAGE, VISPAGE
 FADE BLACK2COLOR

 DEMO1
 TITLEOPEN 0, CHOICE

 DO
   SELECTED = FALSE
   DO

     IF CONTROL THEN
       GETKEY A$

       IF A$ <> "" THEN TITLECOUNTER = 0
       SELECTED = (A$ = " ") OR (A$ = CHR$(13))

       IF A$ = "*P" AND CHOICE < 3 THEN
         CONTROL = FALSE
         CHOICE = CHOICE + 1
         CURSORMOVE = 5
         CURSORDIR = 2
       END IF
       IF A$ = "*H" AND CHOICE > 0 THEN
         CONTROL = FALSE
         CHOICE = CHOICE - 1
         CURSORMOVE = 5
         CURSORDIR = -2
       END IF
     END IF

     IF CONTROL THEN
       CURSORPTN = 1
       DRAWMAINMENU CHOICE, AUXPAGE
     ELSE
       CURSORPTN = 0
       DRAWMAINMENU -2, AUXPAGE
     END IF

     IF CURSORMOVE > 0 THEN
       CURSORMOVE = CURSORMOVE - 1
       CURSORY = CURSORY + CURSORDIR
     ELSE
       CONTROL = TRUE
     END IF

     PSETCURSOR MAPX + 4, MAPY + 31 + CURSORY, CURSORPTN + 2, AUXPAGE
     PSETCURSOR MAPX + 67, MAPY + 31 + CURSORY, CURSORPTN, AUXPAGE

     TITLECOUNTER = (TITLECOUNTER + 1) MOD 80

     '- check counter for demo -
     IF TITLECOUNTER = 0 THEN
       DEMONUM = (DEMONUM + 1) MOD 2
       IF DEMONUM = 0 THEN
          DEMO1
          TITLEOPEN 0, CHOICE
       ELSE
          DEMO2
          TITLEOPEN 1, CHOICE
       END IF
     END IF

     PCOPY AUXPAGE, VISPAGE

     DELAY 1

   LOOP UNTIL SELECTED

   SELECT CASE CHOICE
   CASE IS = 0, 1
     IF CHOICE = 0 THEN
       INTRO
       INITDATA
     ELSE
       MAPOFF
       LOADDATA

       SCREEN , , MAPPAGE, VISPAGE
       GET (GAMEDATA.MAPSCROLLX, GAMEDATA.MAPSCROLLY)-(GAMEDATA.MAPSCROLLX + 79, GAMEDATA.MAPSCROLLY + 79), FMVDATA
       SCREEN , , BGPAGE, VISPAGE
       CLRSCR BGPAGE
       PUT (MAPX + 2, MAPY + 2), FMVDATA, PSET
       PCOPY BGPAGE, AUXPAGE
       MAPROMPTN = GAMEDATA.ROMDIR * 3
       TPSETROM GAMEDATA.MAPROMX, GAMEDATA.MAPROMY, MAPROMPTN, AUXPAGE

       MAPON
     END IF

     MAIN EXITRESULT

     IF EXITRESULT = 2 THEN
       QUIT = TRUE
     ELSE

       LOADTITLEGRP
       CHOICE = 0
       CURSORY = 0

       TITLEOPEN 0, CHOICE

     END IF

   CASE IS = 2: DEBUG = NOT DEBUG
   CASE IS = 3: QUIT = TRUE
   END SELECT

 LOOP UNTIL QUIT

 SCREEN , , VISPAGE, VISPAGE
 FADE COLOR2BLACK
 CLS
 FADE BLACK2COLOR

END SUB

SUB TITLEFX

 FOR I = 0 TO 70 STEP 10
    SCREEN , , AUXPAGE, VISPAGE
    GET (MAPX + 2 + I, MAPY + 2)-(MAPX + 6 + I, MAPY + 81), FMVDATA
    GET (MAPX + 77 - I, MAPY + 2)-(MAPX + 81 - I, MAPY + 81), FMVMASK
    SCREEN , , VISPAGE, VISPAGE
    PUT (MAPX + 2 + I, MAPY + 2), FMVDATA, PSET
    PUT (MAPX + 77 - I, MAPY + 2), FMVMASK, PSET
    DELAY 1
 NEXT
 PCOPY AUXPAGE, VISPAGE

END SUB

SUB TITLEOPEN (N, CHOICE)

 '- title open -
 CLRSCR BGPAGE
 DRAWMAINMENU -1, BGPAGE
 DRAWMAINMENU CHOICE, BGPAGE
 PSETCURSOR MAPX + 4, MAPY + 31 + CHOICE * 10, 2, BGPAGE
 PSETCURSOR MAPX + 67, MAPY + 31 + CHOICE * 10, 0, BGPAGE
 PCOPY BGPAGE, AUXPAGE

 IF N = 0 THEN TITLEFX ELSE MAPON

END SUB

SUB TPSETBIGCOOKIE (X, Y, L, N, P)

 IF L > 0 THEN
   CLIP = 21 - L
   IF CLIP < 0 THEN CLIP = 0
   SCREEN , , EXTRAPAGE, VISPAGE
   GET (1 + N * 22, 133)-(21 + N * 22 - CLIP, 162), FMVDATA
   GET (1 + N * 22, 164)-(21 + N * 22 - CLIP, 193), FMVMASK
   SCREEN , , P, VISPAGE
   PUT (X, Y), FMVMASK, AND
   PUT (X, Y), FMVDATA, OR
 END IF

END SUB

SUB TPSETROM (X, Y, N, P)

 IF (X < MAPX + 82) AND (X > MAPX - 11) THEN
   IF (X > MAPX + 69) THEN RCLIP = X - MAPX - 69
   IF (X < MAPX + 2) THEN LCLIP = 2 - (X - MAPX)
   SCREEN , , MAPPAGE, VISPAGE
   GET (1 + N * 14 + LCLIP, 146)-(13 + N * 14 - RCLIP, 160), FMVDATA
   GET (1 + N * 14 + LCLIP, 162)-(13 + N * 14 - RCLIP, 176), FMVMASK
   SCREEN , , P, VISPAGE
   PUT (X + LCLIP, Y), FMVMASK, AND
   PUT (X + LCLIP, Y), FMVDATA, OR
 END IF

END SUB

SUB TPSETSMALLCOOKIE (X, Y, L, N, P)

 IF L > 0 THEN
   CLIP = 12 - L
   IF CLIP < 0 THEN CLIP = 0
   SCREEN , , MAPPAGE, VISPAGE
   GET (169 + N * 13, 146)-(180 + N * 13 - CLIP, 160), FMVDATA
   GET (169 + N * 13, 162)-(180 + N * 13 - CLIP, 176), FMVMASK
   SCREEN , , P, VISPAGE
   PUT (X, Y), FMVMASK, AND
   PUT (X, Y), FMVDATA, OR
 END IF

END SUB

SUB TPSETSPARK (X, Y, OBJ, N, P)

 SELECT CASE OBJ
 '- spark -
 CASE IS = 0
   SPARKPTN = N MOD 4
   SCREEN , , MISCPAGE, VISPAGE
   GET (1 + SPARKPTN * 16, 31)-(15 + SPARKPTN * 16, 45), FMVDATA
   GET (1 + SPARKPTN * 16, 47)-(15 + SPARKPTN * 16, 61), FMVMASK
 '- star -
 CASE ELSE
   SPARKPTN = VAL(MID$("01210", (N MOD 5) + 1, 1))
   SCREEN , , MISCPAGE, VISPAGE
   GET (65 + SPARKPTN * 16, 31)-(79 + SPARKPTN * 16, 45), FMVDATA
   GET (65 + SPARKPTN * 16, 47)-(79 + SPARKPTN * 16, 61), FMVMASK
 END SELECT

 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVMASK, AND
 PUT (X, Y), FMVDATA, OR

END SUB

SUB TPSETWEAPON (X, Y, N, TYP, P)

 '- select source -
 IF TYP < 2 THEN
   SCREEN , , ROMPAGE, VISPAGE
 ELSE
   SCREEN , , ENEMYPAGE, VISPAGE
 END IF

 '- get data -
 SELECT CASE TYP
 CASE IS = 0
   GET (33, 166)-(39, 181), FMVDATA
   GET (33, 183)-(33 + 6, 198), FMVMASK
 CASE IS = 1
   GET (41 + N * 18, 166)-(57 + N * 18, 177), FMVDATA
   GET (41 + N * 18, 179)-(57 + N * 18, 190), FMVMASK
 CASE IS = 2
   GET (33 + N * 13, 166)-(44 + N * 13, 176), FMVDATA
   GET (33 + N * 13, 178)-(44 + N * 13, 188), FMVMASK
 CASE IS = 3
   GET (59 + N * 46, 166)-(80 + N * 46, 184), FMVDATA
   GET (82 + N * 46, 166)-(103 + N * 46, 184), FMVMASK
 CASE IS = 4
   GET (33 + N * 15, 166)-(46 + N * 15, 179), FMVDATA
   GET (33 + N * 15, 181)-(46 + N * 15, 194), FMVMASK
 CASE IS = 5
   GET (63, 166)-(79, 171), FMVDATA
   GET (63, 173)-(79, 178), FMVMASK
 CASE IS = 6
   GET (33, 166)-(39, 181), FMVDATA
   GET (33, 183)-(39, 198), FMVMASK
 CASE IS = 7
   GET (41 + N * 18, 166)-(57 + N * 18, 177), FMVDATA
   GET (41 + N * 18, 179)-(57 + N * 18, 190), FMVMASK
 CASE IS = 8
   GET (65 + N * 17, 166)-(80 + N * 17, 181), FMVDATA
   GET (65 + N * 17, 183)-(80 + N * 17, 198), FMVMASK
 CASE IS = 9
   GET (201, 166)-(216, 174), FMVDATA
   GET (201, 176)-(216, 184), FMVMASK
 CASE IS = 10
   GET (33, 166)-(42, 181), FMVDATA
   GET (33, 183)-(42, 198), FMVMASK
 CASE IS = 11
   GET (33 + N * 18, 166)-(49 + N * 18, 177), FMVDATA
   GET (33 + N * 18, 179)-(49 + N * 18, 190), FMVMASK
 CASE IS = 12
   GET (69, 166)-(87, 174), FMVDATA
   GET (69, 176)-(87, 184), FMVMASK
 END SELECT

 SCREEN , , P, VISPAGE
 PUT (X, Y), FMVMASK, AND
 PUT (X, Y), FMVDATA, OR

END SUB

SUB TPSETZZZ (X, Y, N, DIR, P)

 IF N < 3 THEN
   ZZZY = 90 - (DIR = 0) * 51
   SCREEN , , MISCPAGE, VISPAGE
   GET (1, ZZZY + N * 17)-(28, ZZZY + N * 17 + 15), FMVDATA
   GET (30, ZZZY + N * 17)-(57, ZZZY + N * 17 + 15), FMVMASK
   SCREEN , , P, VISPAGE
   PUT (X, Y), FMVMASK, AND
   PUT (X, Y), FMVDATA, OR
 END IF

END SUB

SUB UPDATEHPBAR (HP, SIDE, P)

 SCREEN , , MISCPAGE, VISPAGE
 SELECT CASE SIDE
 CASE IS = 0
   GET ((HP + 1) \ 2 + 1, 1)-((HP + 1) \ 2 + 50, 14), FMVDATA
   SCREEN , , P, VISPAGE
   PUT (BTLX + 3, BTLY - 23), FMVDATA, PSET
 CASE IS = 1
   GET ((502 - HP) \ 2 + 1, 16)-((502 - HP) \ 2 + 50, 29), FMVDATA
   SCREEN , , P, VISPAGE
   PUT (BTLX + 72, BTLY - 23), FMVDATA, PSET
 END SELECT

END SUB

