/*
// ChangeV's first game boy color demo
// Title : Akumajo Dracula G (PCEngine Akumajo Dracula X clone)
// real game(1 stage only) will not use multilayer scrolling
// (since it uses too much VRAM and speed)
//
// note!! this is just scrolling demo. no user control yet!
// by the way, it really looks like PCEngine version!! he he he
*/

#include <gb.h>

#include "Newbg.c"
#include "Newspr.c"
#include "scrldata.c"
#include "fakescrl.c"

void putgrass(int x, int y, int ptn);
void putprologue();

void putrichter(int x, int y, int ptn) ;
void putmantle(int x, int y, int ptn) ;
void putcart(int x, int y, int ptn) ;
void puthorse(int x, int y, int ptn) ;
void putspritecolor();
void puthpbar(int x, int y, int ptn);

UWORD spritepalette[] = {
  0x7fff, 0x531c, 0x7da0, 0x0c63,
  0x7fff, 0x2210, 0x118c, 0x0c63,
  0x7fff, 0x531c, 0x2210, 0x0c63,
  0x7fff, 0x5230, 0x314a, 0x0c63,
  0x7fff, 0x001f, 0x29b6, 0x0c63,
  0x7fff, 0x0132, 0x4210, 0x0c63,
  0x7fff, 0x29b6, 0x0132, 0x0c63, 
  0x7fff, 0x0228, 0x7da0, 0x7fff
}; 

UWORD backgroundpalette[] = {
  0x7c00, 0x5400, 0x0000, 0x0000,
  0x0089, 0x0080, 0x0000, 0x0000,
  0x0120, 0x0080, 0x0000, 0x00cd,
  0x0208, 0x2210, 0x02c9, 0x0000,
  0x0000, 0x0208, 0x2210, 0x118c,
  0x0000, 0x118c, 0x2210, 0x0208,
  0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000
}; 

unsigned char cgbmap[] = { // color map for back ground
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5
}; 

void main() {

    int i = 0, idelay = 0;
    int mantleptn = 0, mantleptndelay = 0;
    int wheelptn = 0;
    long int grassx = 0;
  
    int x = 30, y = 100;
  
    DISPLAY_OFF;
    SPRITES_8x16; 
 
    if(_cpu == 0x11) {  // initialize Extra Colors if this demo runs on gameboy color
      VBK_REG = 1;
      set_bkg_tiles(0, 0, 20, 18, cgbmap); 
      VBK_REG = 0;  
      set_bkg_palette(0, 8, &backgroundpalette[0]); 
      set_sprite_palette(0, 8, &spritepalette[0]);   
      putspritecolor();
    }

    set_bkg_data(0, 255, newbg);
    set_sprite_data(0, 128, newspr);

    set_bkg_tiles(0,  0, 20, 1, &Mapblank2[0]);
    set_bkg_tiles(0,  5, 20, 1, &Mapblank2[0]);
    set_bkg_tiles(0, 14, 20, 1, &Mapblank2[0]);

    DISPLAY_ON;

    // demo start
    puthpbar(10, 2, 0);
    fakescroll();
    SHOW_BKG;
    SHOW_SPRITES;
 
    while(!0) {
      fakescroll();

      idelay = (idelay + 1) % 3; if (idelay == 0) i ^= 1; //general delay
      wheelptn ^= 1; //cart wheel...no delay
      mantleptndelay = (mantleptndelay + 1) % 4; if (mantleptndelay == 0) mantleptn ^= 1;
      grassx -= 8; if (grassx == -8) grassx = 8 * 20;
  
      putprologue();
      putgrass(grassx, y + 16, i);
      putrichter(x, y, i);
      putmantle(x, y, mantleptn);
      putcart(x, y, wheelptn);
      puthorse(x, y, i);
      delay(30);
    }//wend    
}//end main

// sprite layer info
// HPBAR 0,1,2,3,4,5(replaced)
// PROLOGUE 6,7,8,9,10,11,12,13
// GRASS 14,15,16,17
// BOSS 18,19,20,21(not in this demo)
// MANTLE 22,23
// WHIP 24,25(not in this demo)
// RICHTER 26,27
// CART 28,29,30
// HORSE 31,32,33

void putspritecolor() { // set all sprite color here
  set_sprite_prop( 0, (S_PALETTE & 0XF8) | 4); 
  set_sprite_prop( 1, (S_PALETTE & 0XF8) | 5); 
  set_sprite_prop( 2, (S_PALETTE & 0XF8) | 5); 
  set_sprite_prop( 3, (S_PALETTE & 0XF8) | 4); 
  set_sprite_prop( 4, (S_PALETTE & 0XF8) | 6); 
  set_sprite_prop( 5, (S_PALETTE & 0XF8) | 6); 
  set_sprite_prop( 6, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop( 7, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop( 8, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop( 9, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(10, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(11, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(12, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(13, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(14, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(15, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(16, (S_PALETTE & 0XF8) | 7); 
  set_sprite_prop(17, (S_PALETTE & 0XF8) | 7); 

  set_sprite_prop(22, (S_PALETTE & 0XF8) | 3); 
  set_sprite_prop(23, (S_PALETTE & 0XF8) | 3); 

  set_sprite_prop(26, (S_PALETTE & 0XF8) | 0); 
  set_sprite_prop(27, (S_PALETTE & 0XF8) | 0); 
  set_sprite_prop(28, (S_PALETTE & 0XF8) | 1); 
  set_sprite_prop(29, (S_PALETTE & 0XF8) | 1); 
  set_sprite_prop(30, (S_PALETTE & 0XF8) | 1); 
  set_sprite_prop(31, (S_PALETTE & 0XF8) | 2); 
  set_sprite_prop(32, (S_PALETTE & 0XF8) | 2); 
  set_sprite_prop(33, (S_PALETTE & 0XF8) | 2); 
}

void putprologue() {
  int px = 55, py = 90;
  set_sprite_tile( 6, 0x0c); 
  set_sprite_tile( 7, 0x0e); 
  set_sprite_tile( 8, 0x10); 
  set_sprite_tile( 9, 0x12); 
  set_sprite_tile(10, 0x14); 
  set_sprite_tile(11, 0x16); 
  set_sprite_tile(12, 0x18); 
  set_sprite_tile(13, 0x1a);  
  move_sprite( 6, 8 * 0 + px, py); 
  move_sprite( 7, 8 * 1 + px, py); 
  move_sprite( 8, 8 * 2 + px, py); 
  move_sprite( 9, 8 * 3 + px, py); 
  move_sprite(10, 8 * 4 + px, py); 
  move_sprite(11, 8 * 5 + px, py); 
  move_sprite(12, 8 * 6 + px, py); 
  move_sprite(13, 8 * 7 + px, py); 
}

void putgrass(int x, int y, int ptn) {
  set_sprite_tile(14, 0x1c); 
  set_sprite_tile(15, 0x1e); 
  set_sprite_tile(16, 0x20); 
  set_sprite_tile(17, 0x22); 
  move_sprite(14, x +  8, y + 16); 
  move_sprite(15, x + 16, y + 16); 
  move_sprite(16, x +  8 + 64 + 16, y + 16); 
  move_sprite(17, x + 16 + 64 + 16, y + 16); 
}
void putrichter(int x, int y, int ptn) {
  switch(ptn) {
  case (0): 
    set_sprite_tile(26, 0x30); 
    set_sprite_tile(27, 0x32); 
    break;
  case (1): 
    set_sprite_tile(26, 0x34); 
    set_sprite_tile(27, 0x36); 
    break;
  };
  move_sprite(26, x +  8, y + 16); 
  move_sprite(27, x + 16, y + 16); 
}

void putmantle(int x, int y, int ptn) {
  switch(ptn) {
  case (0): 
    set_sprite_tile(22, 0x38); 
    set_sprite_tile(23, 0x3a); 
    break;
  case (1): 
    set_sprite_tile(22, 0x3c); 
    set_sprite_tile(23, 0x3e); 
    break;
  };
  move_sprite(22, x +  8 - 8, y + 16); 
  move_sprite(23, x + 16 - 8, y + 16); 
}

void putcart(int x, int y, int ptn) {
  switch(ptn) {
  case (0): 
    set_sprite_tile(28, 0x40); 
    set_sprite_tile(29, 0x42); 
    set_sprite_tile(30, 0x44); 
    break;
  case (1): 
    set_sprite_tile(28, 0x46); 
    set_sprite_tile(29, 0x48); 
    set_sprite_tile(30, 0x4a); 
    break;
  };
  move_sprite(28, x +  8 - 8, y + 16 + 8); 
  move_sprite(29, x + 16 - 8, y + 16 + 8); 
  move_sprite(30, x + 24 - 8, y + 16 + 8); 
}

void puthorse(int x, int y, int ptn) {
  switch(ptn) {
  case (0): 
    set_sprite_tile(31, 0x4c);
    set_sprite_tile(32, 0x4e); 
    set_sprite_tile(33, 0x50); 
    break;
  case (1): 
    set_sprite_tile(31, 0x54); 
    set_sprite_tile(32, 0x56); 
    set_sprite_tile(33, 0x58); 
    break;
  };
  move_sprite(31, x +  8 + 16, y + 16 + 8); 
  move_sprite(32, x + 16 + 16, y + 16 + 8); 
  move_sprite(33, x + 24 + 16, y + 16 + 8); 
}

void puthpbar(int x, int y, int ptn) {
  set_sprite_tile(0, 0x00); 
  set_sprite_tile(1, 0x02); 
  set_sprite_tile(2, 0x04); 
  set_sprite_tile(3, 0x06); 
  set_sprite_tile(4, 0x08); 
  set_sprite_tile(5, 0x0a);
 
  move_sprite(0, x +  8, y + 16 + 8); 
  move_sprite(1, x + 16, y + 16 + 8); 
  move_sprite(2, x + 24, y + 16 + 8); 
  move_sprite(3, x +  8, y + 16 + 8 + 16); 
  move_sprite(4, x + 16, y + 16 + 8 + 16); 
  move_sprite(5, x + 24, y + 16 + 8 + 16); 
}
