DEFINT A-Z

DECLARE SUB AnimPanel (enemyid, enemyhp, damage)
DECLARE SUB AutoScrollMap (oldx, oldy, newx, newy, ID)
DECLARE SUB Battle (ID, enemyid, battleresult)
DECLARE SUB BattleElixir (ID, enemyid)
DECLARE SUB BattleEnemyAttack (ID, enemyid, damage, item)
DECLARE SUB BattleEnemyDeath (ID, enemyid, itemid)
DECLARE SUB BattleMagic (ID, enemyid, damage)
DECLARE SUB BattlePlayerAttack (ID, enemyid, damage)
DECLARE SUB BattlePlayerDeath (ID, enemyid)
DECLARE SUB BossAction (x, y)
DECLARE SUB BounceFX (x, y, num, ctr)
DECLARE SUB CleanUp ()
DECLARE SUB ClearBuffer ()
DECLARE SUB Delays (N)
DECLARE SUB DrawHexMap (x, y, ID)
DECLARE SUB DrawStatus (N)
DECLARE SUB fade00 ()
DECLARE SUB fadeff ()
DECLARE SUB InitStatus ()
DECLARE SUB Intro ()
DECLARE SUB LastMinuteUpdate1 (x, y)
DECLARE SUB LMUshoptalk (selection)
DECLARE SUB LoadConfig ()
DECLARE SUB LoadTileSet (N, playerid, extra)
DECLARE SUB Main (beatgame)
DECLARE SUB MoveChara (x, y, charadir, ID, roulette)
DECLARE SUB Pause (a$)
DECLARE SUB PlayerBtlMenu (ID, enemyid, selection)
DECLARE SUB PlayerMapMenu (x, y, ID, selection)
DECLARE SUB PlayerShock (x, y, ID)
DECLARE SUB ProcessCmdLine ()
DECLARE SUB PutChara (x, y)
DECLARE SUB QuitMenu (x, y, ID, quit)
DECLARE SUB RouletteMenu (ID, result)
DECLARE SUB Shop (ID)
DECLARE SUB SetStareZone ()
DECLARE SUB SortSpriteY ()
DECLARE SUB Talk1 (x, y, N)
DECLARE SUB Title (result)
DECLARE SUB UpdateCharaPos (N)
DECLARE SUB WalkChara (mapx, mapy, charadir, ID, dir)

DECLARE FUNCTION AiShopInput$ (selection%, target%)
DECLARE FUNCTION BattleDamage% (hp%, clr%)
DECLARE FUNCTION Dist (x1, y1, X2, Y2)
DECLARE FUNCTION EnemyAtkElem% (hp%)
DECLARE FUNCTION EnemySTR% (enemyid%, hp%)
DECLARE FUNCTION HexDirScan (x, y, range, ID)
DECLARE FUNCTION HpColor% (hp%)
DECLARE FUNCTION MapIDx (x, y)
DECLARE FUNCTION MapIDy (x, y)
DECLARE FUNCTION MapRelx (x, y)
DECLARE FUNCTION MapRelY (x, y)
DECLARE FUNCTION NextSy (x, y, dir)
DECLARE FUNCTION Nextx (x, y, dir)
DECLARE FUNCTION Nexty (x, y, dir)
DECLARE FUNCTION Scan (x, y, dir, range, ID)

CONST setupfilename = "minirpg1.cfg"
CONST gfxpath = ""
CONST lose = 0
CONST win = NOT lose

'$INCLUDE: 'NEXUS_13.BI'

TYPE hexmaptype  '10 bytes waste
 txt AS INTEGER
 dsz AS INTEGER
 typ AS INTEGER
 obj AS INTEGER  'not used
 misc AS INTEGER 'not used
END TYPE

TYPE playertype '44 bytes waste
 Names AS STRING * 8
 ID    AS INTEGER
 dir   AS INTEGER 'for boss-direction and player-animation-pattern
 hp AS INTEGER
 x AS INTEGER
 y AS INTEGER
 idx AS INTEGER
 idy AS INTEGER
 State AS INTEGER
 gp AS INTEGER
 elixir AS INTEGER
 mstone AS INTEGER
 item AS INTEGER
 dagger AS INTEGER
 sword AS INTEGER
 axe AS INTEGER
 dslayer AS INTEGER
 AI AS INTEGER
 AIlevel AS INTEGER
 aicommand AS INTEGER
END TYPE

TYPE ysorttype
 ID AS INTEGER
 y AS INTEGER
END TYPE

DIM SHARED scrnbuff(0) AS INTEGER   'double buffer
DIM SHARED fontbuff(0) AS INTEGER   'font buffer
DIM SHARED itembuff(0) AS INTEGER   'item buffer
DIM SHARED cursorbuff(0) AS INTEGER ' cursor buffer... not used

DIM SHARED buffer0(0) AS INTEGER'dynamic tile buffers
DIM SHARED buffer1(0) AS INTEGER
DIM SHARED buffer2(0) AS INTEGER
DIM SHARED buffer3(0) AS INTEGER
DIM SHARED buffer4(0) AS INTEGER
DIM SHARED buffer5(0) AS INTEGER
DIM SHARED buffer6(0) AS INTEGER
DIM SHARED buffer7(0) AS INTEGER
DIM SHARED buffer8(0) AS INTEGER
DIM SHARED buffer9(0) AS INTEGER
DIM SHARED bufferA(0) AS INTEGER
DIM SHARED bufferB(0) AS INTEGER
DIM SHARED bufferC(0) AS INTEGER

DIM SHARED map(8, 8) AS hexmaptype
DIM SHARED path$, musics, sounds, bloods, winnerID, winnerAI, speedup, wid

DIM SHARED player(4) AS playertype
DIM SHARED ysort(4) AS ysorttype

DIM SHARED talk$(21) 'hardwired text for this game

'-< main >-------------------------------------------------------------------
RANDOMIZE TIMER

LoadConfig
ProcessCmdLine
InitStatus

'init default tile set(font, items, cursor.. also palette)
LoadTileSet 0, 0, 0

fade00

DO
Title quit
IF NOT quit THEN
  InitStatus
  Intro
  Main beatgame
END IF
LOOP UNTIL quit OR beatgame

IF beatgame THEN
  CLS
  fade00 'back to normal

  OPEN path$ + "temp.tmp" FOR OUTPUT AS #1: PRINT #1, wid + 1: CLOSE
  RUN "enddemo.exe"

END IF

CleanUp

REM $DYNAMIC
FUNCTION AiShopInput$ (selection, target)

 IF (selection = target) THEN
   AiShopInput$ = " "
 ELSE
   AiShopInput$ = CHR$(0) + MID$("KM", ABS(selection < target) + 1, 1)
 END IF

END FUNCTION

REM $STATIC
SUB AnimPanel (enemyid, enemyhp, damage)

 enemyclass = VAL(MID$("00001111112", enemyid + 1, 1))

 'battle frame B
 LoadTileSet 9, 0, enemyid
 PAGE.CREATE 104, 64, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 IF enemyhp > 0 AND damage > 0 THEN
   DO
     IF enemyhp = 1 THEN
       FOR i = 1 TO 8
         sprite.put 0, 0, 0, buffer0()
         sprite.draw enemyclass, 0, 39 + enemyclass * 8, buffer1()  'class bar
         blink = NOT blink
         IF blink THEN sprite.draw 0, (enemyhp - 1) * 6, 10, buffer2() 'hp marker
         Delays 6
         PAGE.SHOW 16, 112, scrnbuff()
       NEXT
       enemyhp = 0
     ELSE
       'move 6 dot
       FOR i = 1 TO 6
         sprite.put 0, 0, 0, buffer0()
         sprite.draw enemyclass, 0, 39 + enemyclass * 8, buffer1()  'class bar
         sprite.draw 0, (enemyhp - 1) * 6 - i, 10, buffer2()'hp marker
         Delays 1
         PAGE.SHOW 16, 112, scrnbuff()
       NEXT
       enemyhp = enemyhp - 1
       damage = damage - 1
     END IF
  LOOP UNTIL damage <= 0 OR enemyhp <= 0

 END IF

END SUB

REM $DYNAMIC
SUB AutoScrollMap (oldx, oldy, newx, newy, ID)

 move = 4  'map scroll speed
 x = oldx
 y = oldy
 nx = newx
 ny = newy

 DrawHexMap x, y, ID
 PutChara x, y
 Delays 1
 PAGE.SHOW 16, 24, scrnbuff()

 'scrolling start
 DO
   a$ = INKEY$
   IF x = nx AND y = ny THEN
     control = NOT control
   ELSE
     x = x + SGN(nx - x) * move
     y = y + SGN(ny - y) * move
     IF ABS(x - nx) < move THEN x = nx
     IF ABS(y - ny) < move THEN y = ny
   END IF

   DrawHexMap x, y, ID
   PutChara x, y
   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()
 LOOP UNTIL (x = nx AND y = ny)

END SUB

REM $STATIC
SUB Battle (ID, enemyid, battleresult)

 enemyhp = VAL(MID$("13206786789", enemyid + 1, 1)) + 7
 enemyhp = enemyhp + INT(RND * 3): IF enemyhp > 16 THEN enemyhp = 16

 enemyclass = VAL(MID$("00001111112", enemyid + 1, 1))

 'battle frame A
 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()
 'page.fill 204, scrnbuff()
 sprite.put 0, 0, 0, buffer0()     'bg

 sprite.draw 0, 23, 45, buffer1()  'player
 sprite.draw 0, 110, 45, buffer2() 'enemy
 PAGE.SHOW 16, 24, scrnbuff()

 'battle frame B
 LoadTileSet 9, ID, enemyid
 PAGE.CREATE 104, 64, scrnbuff()
 PAGE.ACTIVE scrnbuff()
 sprite.put 0, 0, 0, buffer0()
 sprite.draw 0, (enemyhp - 1) * 6, 10, buffer2()'hp marker
 sprite.draw enemyclass, 0, 39 + enemyclass * 8, buffer1() 'class bar
 PAGE.SHOW 16, 112, scrnbuff()
 
 'battle frame C
 RouletteMenu -1, -1
 fade00

 youwin = false
 youlose = false

 SELECT CASE enemyid
 CASE 0 TO 3, 10
   item = INT(RND * 16) + 1
 CASE 4 TO 9
   item = enemyid + 13
 END SELECT

DO

 PlayerBtlMenu ID, enemyid, menuresult

 SELECT CASE menuresult
 CASE 1:  'use magic stone!!

   'calc magic damage ..
   damage = BattleDamage(enemyhp, HpColor(enemyhp)) * -(enemyid <> 10)

   player(ID).mstone = 0
   DrawStatus ID
   'enemy hit animation
   BattleMagic ID, enemyid, -damage
   'animate panel
   AnimPanel enemyid, enemyhp, damage
   'enemy death...
   IF enemyhp = 0 THEN
     BattleEnemyDeath ID, enemyid, item
     youwin = true
   END IF

 CASE 0: 'fight using roulette
         
   RouletteMenu ID, result

   LoadTileSet 8, ID, enemyid
   PAGE.CREATE 160, 88, scrnbuff()
   PAGE.ACTIVE scrnbuff()

   SELECT CASE result
   CASE 0, 1, 3, 5
    
    IF player(ID).AI > 0 THEN
     menux = 32 + 5
     menuy = 16
    
     'page.fill 204, scrnbuff()
     sprite.put 0, 0, 0, buffer0()     'bg
     sprite.draw 0, 23, 45, buffer1()  'player
     sprite.draw 0, 110, 45, buffer2() 'enemy
     sprite.draw 1, menux, menuy, buffer3()
     PAGE.SHOW 16, 24, scrnbuff()
    END IF
   
   'calc magic damage
   damage = BattleDamage(enemyhp, result)
 
   'enemy hit animation
   BattlePlayerAttack ID, enemyid, -damage
 
   'animate panel
   AnimPanel enemyid, enemyhp, damage

   'enemy death
   IF enemyhp = 0 THEN
     BattleEnemyDeath ID, enemyid, item
     youwin = true
   END IF
  
   'enemy turn
   CASE 2, 4
     'page.fill 204, scrnbuff()
     sprite.put 0, 0, 0, buffer0()     'bg
     sprite.draw 0, 23, 45, buffer1()  'player
     sprite.draw 0, 110, 45, buffer2() 'enemy
     PAGE.SHOW 16, 24, scrnbuff()
     Delays 30
     menux = VAL(MID$("5760576051575151575755", enemyid * 2 + 1, 2))
     menuy = 16
     'page.fill 204, scrnbuff()
     sprite.put 0, 0, 0, buffer0()     'bg
     sprite.draw 0, 23, 45, buffer1()  'player
     sprite.draw 0, 110, 45, buffer2() 'enemy
     sprite.draw 3, menux, menuy, buffer3()
     PAGE.SHOW 16, 24, scrnbuff()
     Delays 60


   'calc damage
   atkelem = EnemyAtkElem(enemyhp)
   atkstr = EnemySTR(enemyid, enemyhp)
   damage = atkstr
  
   itemused = 0

IF enemyid < 10 THEN

'normal-mid boss only
   SELECT CASE atkelem
   CASE 1 '    0=none 1=r 2=y 3=b 4=p
     IF player(ID).dagger THEN
       IF VAL(MID$("3150", player(ID).dagger, 1)) = HpColor(enemyhp) THEN
         damage = 0
         itemused = atkelem
         player(ID).dagger = 0
       END IF
     END IF
   CASE 2 '
     IF player(ID).sword THEN
       IF VAL(MID$("3150", player(ID).sword, 1)) = HpColor(enemyhp) THEN
         damage = 0
         itemused = atkelem
         player(ID).sword = 0
       END IF
     END IF
   CASE 3 '
     IF player(ID).axe THEN
       IF VAL(MID$("3150", player(ID).axe, 1)) = HpColor(enemyhp) THEN
         damage = 0
         itemused = atkelem
         player(ID).axe = 0
       END IF
     END IF
   END SELECT
 ELSE

'boss attack/counter with dragon=slayer
  SELECT CASE HpColor(enemyhp)
  CASE 0 'purple  1       5
    IF player(ID).dslayer = 1 OR player(ID).dslayer = 5 THEN
      damage = 0
      itemused = 1
    END IF
  CASE 1 'yellow      3     6
    IF player(ID).dslayer = 3 OR player(ID).dslayer = 6 THEN
      damage = 0
      itemused = 1
    END IF
 
  CASE 3 'red       2       6
    IF player(ID).dslayer = 2 OR player(ID).dslayer = 6 THEN
      damage = 0
      itemused = 1
    END IF
  CASE 5 'blue          4 5
    IF player(ID).dslayer = 4 OR player(ID).dslayer = 5 THEN
      damage = 0
      itemused = 1
    END IF
 
  END SELECT

 END IF

   BattleEnemyAttack ID, enemyid, -damage, itemused

   player(ID).hp = player(ID).hp - damage
   IF player(ID).hp < 0 THEN player(ID).hp = 0

   DrawStatus ID
   
   'use elixir
   IF player(ID).hp = 0 THEN
     IF player(ID).elixir THEN
       player(ID).elixir = 0
       BattleElixir ID, enemyid
       player(ID).hp = 10
       DrawStatus ID
     ELSE 'or just dead
       BattlePlayerDeath ID, enemyid
       youlose = true
     END IF
   END IF
 
   END SELECT

 END SELECT

 endofbattle = true

LOOP UNTIL youwin OR youlose

'if win, get item
'if lose, full HP + start from castle

 IF youwin THEN
   IF enemyid < 10 THEN
     SELECT CASE item
     CASE 1 TO 3: player(ID).gp = player(ID).gp + 1
     CASE 4 TO 8: player(ID).gp = player(ID).gp + 5
     CASE 9: player(ID).mstone = 1
     CASE 10: player(ID).elixir = 1
     CASE 11 TO 12: player(ID).dagger = INT(RND * 4) + 1
     CASE 13 TO 14: player(ID).sword = INT(RND * 4) + 1
     CASE 15 TO 16: player(ID).axe = INT(RND * 4) + 1

     CASE 17 TO 22:
       player(ID).dslayer = item - 16
       IF player(ID).aicommand = 2 THEN player(ID).aicommand = 3

     END SELECT
     IF player(ID).gp >= 10 THEN
       player(ID).gp = 10
       IF player(ID).aicommand = 0 THEN player(ID).aicommand = 1
     END IF
     DrawStatus ID
   END IF
 END IF

 PAGE.ACTIVE scrnbuff()

 Delays 60 * 2

 fadeff

 IF youwin THEN battleresult = win ELSE battleresult = lose

END SUB

FUNCTION BattleDamage (hp, clr)

 BattleDamage = INSTR(18 - hp, "53105301353015103510", LTRIM$(STR$(clr))) - (17 - hp)

END FUNCTION

SUB BattleElixir (ID, enemyid)

 'battle frame A
 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 animctr = 0

 playerptn = 0
 enemyptn = 0

 DO
   'page.fill 204, scrnbuff()
   sprite.put 0, 0, 0, buffer0()     'bg

   animctr = animctr + 1

   'elixir init
   IF animctr = 90 THEN
     elixir = true
     elixirptn = 0
     elixirdy = -6
     elixiry = 0
     elixirdelay = 0
     elixirctr = 0
   END IF

   'player ptn calc
   IF animctr >= 60 AND animctr <= 190 THEN playerptn = 2 ELSE playerptn = 0
   sprite.draw playerptn, 23, 45, buffer1()   'player
   sprite.draw enemyptn, 110 + enemydx, 45, buffer2()'enemy

   IF elixir THEN
     elixirdelay = (elixirdelay + 1) MOD 4
     IF elixirdelay = 0 THEN
      
       elixirctr = elixirctr + 1
       IF elixirctr = 30 THEN elixir = false
       elixirptn = (elixirptn + 1) MOD 4
       'arc calc
       IF elixirctr < 10 THEN
         elixirdy = elixirdy + 1 + (elixirdy = 2)
         IF elixirctr = 9 THEN
           spark = true
           sparkctr = 0
           sparkx = 0
           sparky = 0
           sparkptn = 0
         END IF
       ELSEIF elixirctr >= 12 THEN
         elixir = false
         elixirdy = 0
       ELSE
         elixirdy = 0
       END IF
       elixiry = elixiry + elixirdy
     END IF
     sprite.draw 54, 36, 51 + elixiry, itembuff()
   END IF

   IF spark THEN
     sparkdelay = (sparkdelay + 1) MOD 4
     IF sparkdelay = 0 THEN
       sparkctr = sparkctr + 1
       sparkptn = (sparkptn + 1) MOD 4
      
       IF sparkctr >= 5 THEN
         sparkx = sparkx - 1
         sparky = sparky + 1
       END IF
       IF sparkctr = 20 THEN spark = false
       IF sparkctr = 18 THEN
         bounce = true
         bouncex = 25
         bouncey = 70
         bouncectr = 1
       END IF
     END IF
     sprite.draw 34 + (sparkptn + 0) MOD 4, 35 + sparkx, 42 + sparky * .5, buffer6()
     sprite.draw 34 + (sparkptn + 1) MOD 4, 35 + sparkx, 42 + sparky, buffer6()
     sprite.draw 34 + (sparkptn + 2) MOD 4, 35 + sparkx, 42 + sparky * 1.5, buffer6()
     sprite.draw 34 + (sparkptn + 3) MOD 4, 35 + sparkx * 1.5, 42 + sparky * .5, buffer6()
     sprite.draw 34 + (sparkptn + 4) MOD 4, 35 + sparkx, 42 + sparky, buffer6()
     sprite.draw 34 + (sparkptn + 5) MOD 4, 35 + sparkx * .5, 42 + sparky * 1.5, buffer6()
   END IF

   IF bounce THEN
     bouncedelay = (bouncedelay + 1) MOD 4
     IF bouncedelay = 0 THEN
       bouncectr = bouncectr + 1
       IF bouncectr = 18 THEN
         bounce = false
         endanim = true
       END IF
     END IF
     BounceFX bouncex - 4, bouncey, 1, bouncectr
     BounceFX bouncex + 4, bouncey, 0, bouncectr
   END IF
 
   IF endanim THEN
     enddelay = enddelay + 1
     IF enddelay > 60 THEN
       endofanimation = true
       'page.fill 204, scrnbuff()
       sprite.put 0, 0, 0, buffer0()     'bg
       sprite.draw playerptn, 23, 45, buffer1()   'player
       sprite.draw enemyptn, 110 + enemydx, 45, buffer2()'enemy
     END IF
   END IF

   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

 LOOP UNTIL endofanimation

END SUB

SUB BattleEnemyAttack (ID, enemyid, damage, item)

 'battle frame A
 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 animctr = 0
 playerctr = 0

 DO
   animctr = animctr + 1
   IF animctr = 500 THEN endofanimation = true

   enemydelay = (enemydelay + 1) MOD 4
  
   IF enemydelay = 0 THEN
     enemyctr = enemyctr + 1

     IF enemyctr <= VAL(MID$("1528231514141414141414", enemyid * 2 + 1, 2)) THEN
       SELECT CASE enemyid                '12345678901234567890123456789
       CASE 0: enemyptn = VAL("&h" + MID$("033333445555550", enemyctr, 1))
       CASE 1: enemyptn = VAL("&h" + MID$("0334444444444545454544444330", enemyctr, 1))
       CASE 2: enemyptn = VAL("&h" + MID$("03334444556677889999990", enemyctr, 1))
       CASE 3: enemyptn = VAL("&h" + MID$("033333445555550", enemyctr, 1))
      
       CASE 4 TO 10: enemyptn = VAL("&h" + MID$("03333334444440", enemyctr, 1))
       END SELECT
    
       'projectile start counter
       IF enemyctr = VAL(MID$("0818150808080808080808", enemyid * 2 + 1, 2)) THEN
         'init projectile
         proj = true
         projctr = 0
         projptn = 0
         projx = VAL(MID$("5349475547544747545451", enemyid * 2 + 1, 2)) + 50 + 2
         projy = VAL(MID$("4743565652525252525251", enemyid * 2 + 1, 2))
       END IF

     END IF
   END IF


   'bg
   'page.fill 204 * 1, scrnbuff()
   sprite.put 0, 0, 0, buffer0()     'bg

   'player shake
   IF playershake THEN
     playerdelay = (playerdelay + 1) MOD 4
     IF playerdelay = 0 THEN
       playerctr = playerctr + 1
       IF playerctr <= 8 THEN playerdx = -(playerctr AND 1) * 4
       IF playerctr > 8 + 8 THEN
         playershake = false
         playerdx = 0
         playerptn = 0
       END IF
     END IF
   END IF
  
   'chara-A
   sprite.draw playerptn, 23 + playerdx, 45, buffer1()        'player normal

   'chara-B
   sprite.draw enemyptn, 110, 45, buffer2() 'enemy


   IF proj THEN
     projctr = projctr + 1
   
     projx = projx - VAL(MID$("22222222222", enemyid + 1, 1))  'opt later

     projdelay = (projdelay + 1) MOD VAL(MID$("44344444444", enemyid + 1, 1))
     IF projdelay = 0 THEN
       'calc position, pattern
       SELECT CASE enemyid
       CASE 0
       CASE 1: projptn = (projptn + 1) MOD 2
       CASE 2: projdyctr = (projdyctr + 1) MOD 12  '18
         projdy = VAL(MID$("210001234443", projdyctr + 1, 1)) - 2
       CASE 3 TO 10: projptn = (projptn + 1) MOD 2

       END SELECT

       IF enemyid = 10 AND item AND projctr >= VAL(MID$("3940403936403636404039", enemyid * 2 + 1, 2)) - 12 + 6 THEN
         barrier = true
       END IF

     END IF
   
     'end of projectile : shake init, bounce init
     IF projctr = VAL(MID$("3940403936403636404039", enemyid * 2 + 1, 2)) THEN
       proj = false
      
       IF NOT barrier THEN
         playershake = true
         playerptn = 1
         playerctr = 0
         playerdx = 0
       END IF

       bounce = true
       bouncex = 25
       bouncey = 70
       bouncectr = 1

       IF item > 0 AND enemyid < 10 THEN
         itemarc = true
         itemseg = 4 * (item - 1) + 1
         itemdy = -7
         itemx = 22
         itemy = 20 - 7
       END IF

       sun = true
       sunctr = 0
       sunx = VAL(MID$("2828282828282828282828", enemyid * 2 + 1, 2))
       suny = VAL(MID$("5250515850505050505049", enemyid * 2 + 1, 2))

     END IF

     sprite.draw projptn, projx, projy + projdy * 2, bufferB()
 
   END IF


   IF itemarc THEN
     itemdelay = (itemdelay + 1) MOD 6
     IF itemdelay = 0 THEN
       itemctr = itemctr + 1
       IF itemctr < 27 THEN
         itemx = itemx - 2
         itemdy = itemdy + 1: IF itemdy = 8 THEN itemdy = -5
         itemy = itemy + itemdy
         itemptn = (itemptn + 1) MOD 4
       END IF
     END IF
     sprite.draw itemseg + itemptn, itemx, 40 + itemy, buffer6()
   END IF

   'barrier
   IF barrier THEN
     barrierdelay = (barrierdelay + 1) MOD 2
     IF barrierdelay = 0 THEN
       barrierptn = barrierptn + 1
     END IF
     IF barrierptn >= 3 AND barrierptn < 7 + 3 THEN sprite.draw barrierptn - 3, 23 - 5 + 1, 46, bufferC()
     IF barrierptn = 20 THEN barrier = false
  
     FOR i = 0 TO 6
       sprite.draw i, 23 - 5 - 1 + 1, 46, bufferC()
     NEXT
   END IF

   IF sun THEN
     sundelay = (sundelay + 1) MOD 4
     IF sundelay = 0 THEN
       sunptn = sunptn + 1
       IF sunptn = 3 THEN sun = false
     END IF
     sprite.draw 13 + sunptn, sunx, suny, buffer6()
   END IF
  
   IF bounce THEN
     bouncedelay = (bouncedelay + 1) MOD 4
     IF bouncedelay = 0 THEN
       bouncectr = bouncectr + 1
       IF bouncectr = 18 THEN
         bounce = false
         endanim = true
       END IF
     END IF
     BounceFX bouncex, bouncey, damage, bouncectr
   END IF
  
   IF endanim THEN
     enddelay = enddelay + 1
     IF enddelay >= 60 THEN
       endofanimation = true
       'page.fill 204, scrnbuff()
       sprite.put 0, 0, 0, buffer0()     'bg
       sprite.draw playerptn, 23 + playerdx, 45, buffer1()  'player normal
       sprite.draw enemyptn, 110, 45, buffer2() 'enemy
     END IF
   END IF

   'output
   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

 LOOP UNTIL endofanimation

END SUB

SUB BattleEnemyDeath (ID, enemyid, itemid)

 'battle frame A
 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 animctr = 0
                   
 itemptn = VAL(MID$("0053535347474747475554505051515252293031323334", itemid * 2 + 1, 2))

 DO

   deathdelay = (deathdelay + 1) MOD 8
   IF deathdelay = 0 THEN
     animctr = animctr + 1
 
     IF animctr <= VAL(MID$("1722150514141414141416", enemyid * 2 + 1, 2)) THEN
       SELECT CASE enemyid
       CASE 0: enemyptn = VAL("&h" + MID$("01222345555556778", animctr, 1))
       CASE 1: enemyptn = VAL("&h" + MID$("0111123334456777789abc", animctr, 1))
       CASE 2: enemyptn = VAL("&h" + MID$("01111123456789a", animctr, 1))
       CASE 3: enemyptn = VAL("&h" + MID$("01223", animctr, 1))
       CASE 4 TO 9: enemyptn = VAL("&h" + MID$("03333334444440", animctr, 1))
       CASE 10: enemyptn = VAL("&h" + MID$("0111123333455555", animctr, 1))
                IF animctr = 16 THEN endanim = true
       END SELECT
     END IF

     IF animctr = VAL(MID$("1808070708080808080850", enemyid * 2 + 1, 2)) THEN
       itemarc = true
       itemdy = -8 - (enemyid > 3) * 5

       itemx = 23 + VAL(MID$("3032333514221414212119", enemyid * 2 + 1, 2))     'caution "crash"
       itemy = 20 + 11 * (enemyid > 3)
   
     END IF
   END IF

   'page.fill 204, scrnbuff()
   sprite.put 0, 0, 0, buffer0()     'bg
   sprite.draw 0, 23, 45, buffer1()   'player normal
   sprite.draw enemyptn, 98 - 12 * (enemyid > 3) + 12 * (enemyid = 10), 45, buffer5()'enemy death

   IF itemarc THEN
     itemdelay = (itemdelay + 1) MOD 4
     IF itemdelay = 0 THEN
       itemctr = itemctr + 1
       IF itemctr < 27 + (enemyid > 3) * 11 THEN
         itemx = itemx - 2
         itemdy = itemdy + 1: IF itemdy = 8 + (enemyid > 3) * 2 THEN itemdy = -5 - (enemyid > 3) * 2
         itemy = itemy + itemdy
       END IF
  
       IF itemctr = 27 THEN endanim = true
  
     END IF
     sprite.draw itemptn, 60 + itemx, 40 + itemy, itembuff()
   END IF

   IF endanim THEN
     enddelay = enddelay + 1
     IF enddelay >= 60 THEN
       endofanimation = true
       'page.fill 204, scrnbuff()
       sprite.put 0, 0, 0, buffer0()     'bg
       sprite.draw 0, 23, 45, buffer1()   'player normal
       sprite.draw enemyptn, 98 - 12 * (enemyid > 3) + 12 * (enemyid = 10), 45, buffer5()'enemy death
     END IF
   END IF

   PAGE.SHOW 16, 24, scrnbuff()
   Delays 1

 LOOP UNTIL endofanimation

END SUB

SUB BattleMagic (ID, enemyid, damage)

 'battle frame A
 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 animctr = 0

 playerptn = 0
 enemyptn = 0

 stone = false
 enemyshake = false

 DO
   'page.fill 204, scrnbuff()
   sprite.put 0, 0, 0, buffer0()     'bg

   animctr = animctr + 1

   'stone init
   IF animctr = 90 THEN
     stone = true
     stoneptn = 0
     stonedy = -6
     stoney = 0
     stonedelay = 0
     stonectr = 0
   END IF

   'lit bolt init
   IF animctr = 210 THEN
     lit = true '
     litx = 120
     litctr = 0 'lifetile
   END IF

   'enemy shake init
   IF animctr = 210 THEN
     enemyshake = true
     enemyptn = 1
     enemyctr = 0
     enemydx = 0
   END IF

   'player ptn calc
   IF animctr >= 60 AND animctr <= 190 THEN playerptn = 2 ELSE playerptn = 0
   sprite.draw playerptn, 23, 45, buffer1()   'player

   'enemy shake calc
   IF enemyshake THEN
     enemydelay = (enemydelay + 1) MOD 4
     IF enemydelay = 0 THEN
       enemydx = (enemyctr AND 1) * 4
       enemyctr = enemyctr + 1
       IF enemyctr >= 8 THEN
         enemyshake = false
         enemydx = 0
       END IF
     END IF
   END IF
   IF animctr = 280 THEN enemyptn = 0
   sprite.draw enemyptn, 110 + enemydx, 45, buffer2()'enemy

   'litbolt calc
   IF lit THEN
     litdelay = (litdelay + 1) MOD 4
     IF litdelay = 0 THEN
       litctr = litctr + 1
       litptn = VAL(MID$("011232300", litctr, 1))
       IF litctr = 9 THEN
         lit = false
         'bounce init
         bounce = true
         bouncex = 120
         bouncey = 70
         bouncectr = 1
       END IF

       IF litctr = 1 THEN 'lit hit ground... ground fx init!
         SELECT CASE enemyid
         CASE 7: splash = true
               splashptn = 0
         CASE ELSE: dust = true
               dustctr = 0
         END SELECT
      
       END IF
     END IF
     sprite.draw litptn, litx, 42, buffer8()
     sprite.draw litptn, litx, 42 - 34, buffer8()
     sprite.draw litptn, litx, 42 - 34 - 34, buffer8()
   END IF

   IF splash THEN
     splashdelay = (splashdelay + 1) MOD 4
     IF splashdelay = 0 THEN
       splashptn = splashptn + 1
       IF splashptn = 4 THEN
         splash = false
       END IF

     END IF
     sprite.draw splashptn + 4, litx + 3, 51, buffer7()
   END IF

   IF dust THEN
     dustdelay = (dustdelay + 1) MOD 4
     IF dustdelay = 0 THEN
       dustptn = dustptn + 1
       IF dustptn = 3 THEN dust = false
     END IF
     sprite.draw dustptn, litx - 2, 64, buffer7()
   END IF

   IF stone THEN
     stonedelay = (stonedelay + 1) MOD 4
     IF stonedelay = 0 THEN
       stonectr = stonectr + 1
       IF stonectr = 30 THEN stone = false
       stoneptn = (stoneptn + 1) MOD 4
       'arc calc
       IF stonectr < 10 THEN
         stonedy = stonedy + 1 + (stonedy = 2)
       ELSEIF stonectr >= 20 THEN
         stonedy = -stonectr + 7
       ELSE
         stonedy = 0
       END IF
       stoney = stoney + stonedy
     END IF
     'stone+trail
     sprite.draw 21 + stoneptn, 36, 51 + stoney, buffer6()
     IF stonectr >= 19 - 5 THEN sprite.draw 17 + stoneptn, 36, 51 + stoney + 6, buffer6()
     IF stonectr >= 20 THEN sprite.draw 17 + (stoneptn + 1) MOD 4, 36, 51 + stoney + 18, buffer6()
   END IF

   IF bounce THEN
     bouncedelay = (bouncedelay + 1) MOD 4
     IF bouncedelay = 0 THEN
       bouncectr = bouncectr + 1
       IF bouncectr = 18 THEN
         bounce = false
         endanim = true
       END IF
     END IF

     BounceFX bouncex, bouncey, damage, bouncectr
   END IF
  
   IF endanim THEN
     enddelay = enddelay + 1
     IF enddelay > 60 THEN
       endofanimation = true
       'page.fill 204, scrnbuff()
       sprite.put 0, 0, 0, buffer0()     'bg
       sprite.draw playerptn, 23, 45, buffer1()   'player
       sprite.draw enemyptn, 110 + enemydx, 45, buffer2()'enemy
     END IF
   END IF

   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

 LOOP UNTIL endofanimation

END SUB

SUB BattlePlayerAttack (ID, enemyid, damage)

 'battle frame A
 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 animctr = 0
 playerctr = 0

 DO
   animctr = animctr + 1
   IF animctr = 500 THEN endofanimation = true

   playerdelay = (playerdelay + 1) MOD 4
   IF playerdelay = 0 THEN
     playerctr = playerctr + 1
    
     IF playerctr <= VAL(MID$("15182711", ID * 2 + 1, 2)) THEN
       SELECT CASE ID                      '12345678901234567890123456789
       CASE 0: playerptn = VAL("&h" + MID$("033333445555550", playerctr, 1))
       CASE 1: playerptn = VAL("&h" + MID$("033333444444444330", playerctr, 1))
       CASE 2: playerptn = VAL("&h" + MID$("033445566777778888899aaaab0", playerctr, 1))
       CASE 3: playerptn = VAL("&h" + MID$("03333344440", playerctr, 1))
       END SELECT
    
       'projectile start counter
       IF playerctr = VAL(MID$("08082208", ID * 2 + 1, 2)) THEN
         'init projectile
         proj = true
         projctr = 0
         projptn = 0
         projx = VAL(MID$("50383835", ID * 2 + 1, 2))
         projy = VAL(MID$("47475556", ID * 2 + 1, 2))
       END IF

     END IF
   END IF

   'bg
   'page.fill 204, scrnbuff()
   sprite.put 0, 0, 0, buffer0()     'bg

   'chara-A
   sprite.draw playerptn, 23, 45, buffer1()          'player normal

   IF enemyshake THEN
     enemydelay = (enemydelay + 1) MOD 4
     IF enemydelay = 0 THEN
       enemyctr = enemyctr + 1
      
       IF enemyctr <= 8 THEN enemydx = (enemyctr AND 1) * 4
      
       IF enemyctr > 8 + 8 THEN
         enemyshake = false
         enemydx = 0
         enemyptn = 0
       END IF
     END IF
   END IF
   'IF animctr = 280 THEN enemyptn = 0
   'chara-B
   sprite.draw enemyptn, 110 + enemydx, 45, buffer2()'enemy
  
   IF proj THEN
     projctr = projctr + 1
    
     projx = projx + VAL(MID$("2222", ID + 1, 1))  'opt later

     projdelay = (projdelay + 1) MOD VAL(MID$("4434", ID + 1, 1))
     IF projdelay = 0 THEN
       'calc position, pattern
       SELECT CASE ID
       CASE 0
       CASE 1: projptn = (projptn + 1) MOD 2
       CASE 2: projptn = (projptn + 1) MOD 8
       CASE 3: projptn = (projptn + 1) MOD 2
       END SELECT

     END IF
    
     'end of projectile : shakeinit, bounce init
     IF projctr = VAL(MID$("36364036", ID * 2 + 1, 2)) + (enemyid > 3) * 4 THEN
       proj = false         '   --
       enemyshake = true
       enemyptn = 1
       enemyctr = 0
       enemydx = 0

       bounce = true
       bouncex = 120
       bouncey = 70
       bouncectr = 1
      
       sun = true
       sunctr = 0
       sunx = 90 + VAL(MID$("29303030", ID * 2 + 1, 2)) + (enemyid > 3) * 4
       suny = VAL(MID$("52505158", ID * 2 + 1, 2)) + (enemyid > 3) * 4

     END IF

     sprite.draw projptn, projx, projy, bufferA()
  
   END IF
      
   IF sun THEN
     sundelay = (sundelay + 1) MOD 4
     IF sundelay = 0 THEN
       sunptn = sunptn + 1
       IF sunptn = 3 THEN sun = false
     END IF
     sprite.draw 13 + sunptn, sunx, suny, buffer6()
   END IF

   IF bounce THEN
     bouncedelay = (bouncedelay + 1) MOD 4
     IF bouncedelay = 0 THEN
       bouncectr = bouncectr + 1
       IF bouncectr = 18 THEN
         bounce = false
         endanim = true
       END IF
     END IF
     BounceFX bouncex, bouncey, damage, bouncectr
   END IF
  
   IF endanim THEN
     enddelay = enddelay + 1
     IF enddelay >= 60 THEN
       endofanimation = true
       'page.fill 204, scrnbuff()
       sprite.put 0, 0, 0, buffer0()     'bg
       sprite.draw playerptn, 23, 45, buffer1()          'player normal
       sprite.draw enemyptn, 110 + enemydx, 45, buffer2()'enemy
      END IF
   END IF

   'output
   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

 LOOP UNTIL endofanimation

END SUB

SUB BattlePlayerDeath (ID, enemyid)

 'battle frame A
 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 animctr = 0

 DO
   deathdelay = (deathdelay + 1) MOD 8
   IF deathdelay = 0 THEN
     animctr = animctr + 1

     IF animctr = 60 THEN endofanimation = true

     IF animctr <= VAL(MID$("07121225", ID * 2 + 1, 2)) THEN
       SELECT CASE ID                      '1234567
       CASE 0: playerptn = VAL("&h" + MID$("0111223", animctr, 1))
       CASE 1: playerptn = VAL("&h" + MID$("011123333345", animctr, 1))
       CASE 2: playerptn = VAL("&h" + MID$("011123456545", animctr, 1))
       CASE 3: playerptn = VAL("&h" + MID$("01123344445454545454", animctr, 1))
               playerptn = VAL("&h" + MID$("0123455567788889898989898", animctr, 1))
       END SELECT                          '
     ELSE

       endanim = true

     END IF
   END IF
  
   'page.fill 204, scrnbuff()
   sprite.put 0, 0, 0, buffer0()     'bg
   sprite.draw playerptn, 0, 45, buffer4()   'player death
   sprite.draw 0, 110, 45, buffer2()'enemy normal

   IF endanim THEN
     enddelay = enddelay + 1
     IF enddelay >= 60 THEN endofanimation = true
   END IF
  
   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()
 
 LOOP UNTIL endofanimation

END SUB

REM $DYNAMIC
SUB BGM (N)

 'not used in this game. sorry

 SELECT CASE N
 CASE 0: 'BGM #1
 CASE 1: 'BGM #2
 CASE 2: 'BGM #3
 CASE 3: 'BGM #4
 END SELECT

END SUB

REM $STATIC
SUB BossAction (x, y)

 player(4).dir = (player(4).dir + 6 + (INT(RND * 2) * 2 - 1)) MOD 6
 SetStareZone

 DrawHexMap x, y, 4
 PutChara x, y
 Delays 1
 PAGE.SHOW 16, 24, scrnbuff()
 Delays 120

END SUB

SUB BounceFX (x, y, num, ctr)

 num$ = STR$(num)
 IF num > 0 THEN num$ = "+" + LTRIM$(num$)
 IF ABS(num) > 9 THEN num$ = " ?"

 dy = -VAL("&h" + MID$("06ab6020000000000000", ctr, 1))

 font.draw x - 1, y + dy, 64, fontbuff(), num$
 font.draw x + 1, y + dy, 64, fontbuff(), num$
 font.draw x, y - 1 + dy, 64, fontbuff(), num$
 font.draw x, y + 1 + dy, 64, fontbuff(), num$

 font.draw x, y + dy, 0, fontbuff(), num$

END SUB

SUB CleanUp

 END 'ha ha ha

END SUB

SUB ClearBuffer

 DO: LOOP UNTIL INKEY$ = ""

END SUB

SUB Delays (N)

 IF NOT speedup THEN
   FOR i = 1 TO N
     WAIT &H3DA, 8
     WAIT &H3DA, 8, 8
   NEXT
 END IF

END SUB

REM $DYNAMIC
FUNCTION Dist (x1, y1, X2, Y2)

 absX = ABS(x1 - X2)
 absY = ABS(y1 - Y2)

 IF absY = 0 OR (absY <= absX \ 2) THEN
   Dist = absX
 ELSEIF (x1 AND 1) THEN
   Dist = absY + (absX - (y1 >= Y2)) \ 2
 ELSE
   Dist = absY + (absX - (y1 < Y2)) \ 2
 END IF

END FUNCTION

SUB DrawHexMap (x, y, ID)

 '-< clear doublebuffer >-
 PAGE.CLEAR scrnbuff()

 r = 23

 FOR j = 0 TO 8
  
   'draw even number of block
   FOR i = 0 TO 8 STEP 2
     IF map(i, j).txt <> &HF THEN
       IF map(i, j).txt < 9 THEN
         sprite.draw 1 * (map(i, j).txt), i * 46 + x, j * 46 + (i AND 1) * 23 + y, buffer0()
       ELSE
         sprite.draw 1 * (map(i, j).txt - 9), i * 46 + x, j * 46 + (i AND 1) * 23 + y, buffer1()
       END IF
     END IF
   NEXT

   'draw odd number of block
   FOR i = 1 TO 8 STEP 2
     IF map(i, j).txt <> &HF THEN
       IF map(i, j).txt < 9 THEN
         sprite.draw 1 * (map(i, j).txt), i * 46 + x, j * 46 + (i AND 1) * 23 + y, buffer0()
       ELSE
         sprite.draw 1 * (map(i, j).txt - 9), i * 46 + x, j * 46 + (i AND 1) * 23 + y, buffer1()
       END IF
     END IF
   NEXT

   'draw mid boss barrier(blue things) or D.stare zone(red things)
   FOR i = 0 TO 8
    
     IF map(i, j).dsz = 1 THEN
       sprite.draw 6, i * 46 + x, j * 46 + (i AND 1) * 23 + y, buffer1()
     END IF
    
     'add barrier(and icon too)
     IF map(i, j).typ >= 2 AND map(i, j).typ <= 7 THEN
       IF ID > -1 THEN
         IF player(ID).dslayer + 1 <> map(i, j).typ THEN 'draw barrier+icon
           'draw icon
           sprite.put 22 + map(i, j).typ - 1, i * 46 + x + 29, j * 46 + (i AND 1) * 23 + y + 28, itembuff()
           'draw barrier
           sprite.draw 7, i * 46 + x, j * 46 + (i AND 1) * 23 + y, buffer1()
            
           IF player(ID).item = map(i, j).typ - 1 THEN
             sprite.draw 8, i * 46 + x, j * 46 + (i AND 1) * 23 + y, buffer1()
           END IF
         END IF
       END IF
     END IF
   NEXT

 NEXT

END SUB

REM $STATIC
SUB DrawStatus (N)

 IF N = -1 THEN
   'simple recursion will display all status
   FOR i = 0 TO 3
     DrawStatus i
   NEXT
 ELSE
   REDIM statbuff(0)
   PAGE.CREATE 16 * 5, 16 * 2, statbuff()
   PAGE.ACTIVE statbuff()

   'heart
   sprite.put 36, 0 * 16, 0, itembuff()
  
   'hp player(n).hp = 9
   sprite.put player(N).hp, 1 * 16, 0, itembuff()

   'coin
   sprite.put 37, 2 * 16, 0, itembuff()

   'GP
   sprite.put player(N).gp, 3 * 16, 0, itembuff()

   IF player(N).dslayer <> 0 THEN
     sprite.put 28 + player(N).dslayer, 4 * 16, 0, itembuff()
   ELSEIF player(N).item <> 0 THEN
     sprite.put 22 + player(N).item, 4 * 16, 0, itembuff()
   ELSE 'draw empty frame
     sprite.put 35, 4 * 16, 0, itembuff()
   END IF

   'dagger: player(n).dagger = 1
   x = player(N).dagger
   sprite.put ((((x - 1) * 3 + 11) * -(x > 0)) - ((x = 0) * 35)), 0, 16, itembuff()

   'sword: player(n).sword = 3
   x = player(N).sword
   sprite.put ((((x - 1) * 3 + 12) * -(x > 0)) - ((x = 0) * 35)), 16, 16, itembuff()

   'axe: player(n).axe = 4
   x = player(N).axe
   sprite.put ((((x - 1) * 3 + 13) * -(x > 0)) - ((x = 0) * 35)), 32, 16, itembuff()

   'elixir player(n).elixir = 0
   sprite.put (35 - (player(N).elixir > 0) * 3), 3 * 16, 16, itembuff()

   'magical stone player(n).mstone = 1
   sprite.put (35 - (player(N).mstone > 0) * 4), 4 * 16, 16, itembuff()

   Delays 1
   PAGE.SHOW 224, 24 + N * 40, statbuff()
  
   ERASE statbuff

 END IF

END SUB

FUNCTION EnemyAtkElem (hp)

 EnemyAtkElem = VAL(MID$("1111112222233333", hp, 1))

END FUNCTION

FUNCTION EnemySTR (enemyid, hp)

 enemyclass = VAL(MID$("00001111112", enemyid + 1, 1))
 EnemySTR = VAL(MID$("111112222233334422223333344445553334444555566666", enemyclass * 16 + hp, 1))

END FUNCTION

SUB fade00

 'color to black 0,0,0
 FOR i = 0 TO 63
   WAIT &H3DA, 8
   palette.fade -1, -1, -1, PAL()
 NEXT

END SUB

SUB fadeff

 '0 to color
 FOR i = 0 TO 63
   WAIT &H3DA, 8
   palette.fade 1, 1, 1, PAL()
 NEXT

END SUB

FUNCTION HexDirScan (x, y, range, ID)

 ' unfinished roiutine...but it is better than recursive one.
 ' x = scanning area
 ' y = scanning area
 ' dir = scanning direction
 ' range1 = turn point. if this = 0 then end all.
 ' range2 = scanning step.
 '
 result = -1
 IF Scan(x, y, 0, range, ID) <> 0 THEN
   result = 0
 ELSEIF Scan(x, y, 1, range, ID) <> 0 THEN
   result = 1
 ELSEIF Scan(x, y, 2, range, ID) <> 0 THEN
   result = 2
 ELSEIF Scan(x, y, 3, range, ID) <> 0 THEN
   result = 3
 ELSEIF Scan(x, y, 4, range, ID) <> 0 THEN
   result = 4
 ELSEIF Scan(x, y, 5, range, ID) <> 0 THEN
   result = 5
 END IF

 HexDirScan = result

END FUNCTION

FUNCTION HpColor (hp)

 HpColor = VAL(MID$("53105301353015100135", 17 - hp, 1))

END FUNCTION

SUB InitStatus

 'initialization for this demo
 player(0).Names = "Rom     "
 player(1).Names = "Cindy   "
 player(2).Names = "Change-V"
 player(3).Names = "Cookie  "
 player(3).Names = "Saurdox "

 player(0).idx = 2: player(0).idy = 0
 player(1).idx = 2: player(1).idy = 0
 player(2).idx = 2: player(2).idy = 0
 player(3).idx = 2: player(3).idy = 0
 player(4).idx = 4: player(4).idy = 4
 player(4).dir = 2

 FOR i = 0 TO 4
   UpdateCharaPos i
 NEXT

 'Rom
 player(0).hp = 5
 player(0).gp = 10 * 0
 player(0).elixir = 1
 player(0).mstone = 0
 player(0).item = 0
 player(0).dslayer = 0
 player(0).dagger = 0
 player(0).sword = 0
 player(0).axe = 0
 player(0).AIlevel = 0
 player(0).aicommand = 0 'barrier

 'Cindy
 player(1).hp = 6
 player(1).gp = 0
 player(1).elixir = 0
 player(1).mstone = 1
 player(1).item = 0
 player(1).dslayer = 0
 player(1).dagger = 0
 player(1).sword = 0
 player(1).axe = 0
 player(1).AIlevel = 0
 player(1).aicommand = 0

 'Change-V
 player(2).hp = 7
 player(2).gp = 0
 player(2).elixir = 0
 player(2).mstone = 0
 player(2).item = 0
 player(2).dslayer = 0
 player(2).dagger = 0
 player(2).sword = 0
 player(2).axe = 1
 player(2).AIlevel = 0
 player(2).aicommand = 0

 'Cookie
 player(3).hp = 6
 player(3).gp = 5
 player(3).elixir = 0
 player(3).mstone = 0
 player(3).item = 0
 player(3).dslayer = 0
 player(3).dagger = 0
 player(3).sword = 0
 player(3).axe = 0
 player(3).AIlevel = 0
 player(3).aicommand = 0

'initialize map property
'< texture map ID >
FOR i = 0 TO 8: map(i, 0).txt = VAL("&h" + MID$("FF899BFFF", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 1).txt = VAL("&h" + MID$("F99A9D9BF", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 2).txt = VAL("&h" + MID$("9A9C99A99", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 3).txt = VAL("&h" + MID$("999012999", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 4).txt = VAL("&h" + MID$("9DA5639AC", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 5).txt = VAL("&h" + MID$("A99D4C999", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 6).txt = VAL("&h" + MID$("9B9A99A99", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 7).txt = VAL("&h" + MID$("FFB9997FF", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 8).txt = VAL("&h" + MID$("FFFFAFFFF", i + 1, 1)): NEXT

'< ground type ID >
FOR i = 0 TO 8: map(i, 0).typ = VAL("&h" + MID$("000111000", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 1).typ = VAL("&h" + MID$("011111110", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 2).typ = VAL("&h" + MID$("111111111", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 3).typ = VAL("&h" + MID$("111234111", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 4).typ = VAL("&h" + MID$("111785111", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 5).typ = VAL("&h" + MID$("111161111", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 6).typ = VAL("&h" + MID$("111111111", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 7).typ = VAL("&h" + MID$("001111900", i + 1, 1)): NEXT
FOR i = 0 TO 8: map(i, 8).typ = VAL("&h" + MID$("000010000", i + 1, 1)): NEXT

talk$(0) = "Help Help "
talk$(1) = "Heeeelp ! "
talk$(2) = "          "
talk$(3) = "I've lost "
talk$(4) = "my pet    "
talk$(5) = "dragon.   "
talk$(6) = "          "
talk$(7) = "If you    "
talk$(8) = "catch him "
talk$(9) = "back,     "
talk$(10) = "I will    "
talk$(11) = "give you a"
talk$(12) = "treasure. "
talk$(13) = "          "
talk$(14) = "Need      "
talk$(15) = "something "
talk$(16) = "before you"
talk$(17) = "go?       "
talk$(18) = "          "
talk$(19) = "          "
talk$(20) = "          "
talk$(21) = "          "

END SUB

SUB Intro

 LoadTileSet 2, 0, 0'load intro set
                               
 '-< display frames >-
 DEF SEG = &HA000
 BLOAD path$ + gfxpath + "frame.scr"
 DEF SEG

 'init big double buffer
 PAGE.CREATE 160, 152, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 'display intro BG
 sprite.put 0, 0, 0, buffer0()
 PAGE.SHOW 16, 24, scrnbuff()
 fadeff

 'output balloon
 sprite.draw 0, 70, 2, buffer1()
 PAGE.SHOW 16, 24, scrnbuff()

 'resize double buffer(into balloon)
 PAGE.CREATE 80, 31, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 'display some text
 page.fill 204, scrnbuff()
 Talk1 0, 0, 0
 PAGE.SHOW 90, 29, scrnbuff()
 Delays 60

 'text scroll start
 delayctr = 2
 FOR i = 0 TO 150
 
   a$ = INKEY$
   IF a$ = " " THEN delayctr = 1 ' speed up if user hits space key
 
   'erase old text
   page.fill 204, scrnbuff()
   'draw new text
   Talk1 0, 0, -i
 
   Delays delayctr - ((i MOD 10) = 1) * (30 * -(delayctr <> 1))
   PAGE.SHOW 90, 29, scrnbuff()
 
 NEXT
 
 Delays 60

 'resize to full-frame double buffer
 PAGE.CREATE 160, 152, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 'redraw introBG to erase balloon!!
 sprite.put 0, 0, 0, buffer0()
 PAGE.SHOW 16, 24, scrnbuff()
 Delays 60

 'player select start(default = Change-V)
 playerid = 2 ' 2 = change V
 DO: LOOP UNTIL INKEY$ = ""
 DO:
   a$ = INKEY$:
   IF a$ = CHR$(0) + "K" THEN playerid = (playerid + 3) MOD 4
   IF a$ = CHR$(0) + "M" THEN playerid = (playerid + 1) MOD 4

   sprite.put 0, 0, 0, buffer0()

   'draw item balloon
   sprite.draw 0, playerid * 32 + 32, 58, buffer2()
   sprite.draw 40 + playerid, playerid * 32 + 40, 64, itembuff()

   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

 LOOP UNTIL a$ = CHR$(27) OR a$ = " " OR a$ = CHR$(13)

 FOR i = 0 TO 3
   player(i).AI = (INT(RND * 3) + 1) * -(playerid <> i)
 NEXT

 fade00

END SUB

SUB LastMinuteUpdate1 (x, y)

 STATIC N
 N = 2 '(boss)jump at start...(1=blink, 2=jump, 3=giggle, 4=dizzy)

 FOR i = 1 TO 40
   SELECT CASE N
   CASE 1: player(4).dir = VAL("&H" + MID$("2222662266222222662266222222222222222222", i, 1))
   CASE 2: player(4).dir = VAL("&H" + MID$("2222777777777788778877777788778877777222", i, 1))
   CASE 3: player(4).dir = VAL("&H" + MID$("22229999999999AA99AA99AA99AA99AA99AA9922", i, 1))
   CASE 4: player(4).dir = VAL("&H" + MID$("2222BBBBCCCCBBBBCCCCBBBBCCCCBBBBCCCC2222", i, 1))
   END SELECT

   DrawHexMap x, y, 4
   PutChara x, y
   Delays 4
   PAGE.SHOW 16, 24, scrnbuff()
 NEXT

END SUB

SUB LMUshoptalk (selection)
    
 sprite.draw 0, 70, 2, buffer2()
 draw.boxfill 74, 6, 74 + 72 + 6, 6 + 28, 204 + 1 * 0
 SELECT CASE selection
 CASE 0
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Exit      "
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), ""
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), ""
 CASE 1
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Elixir"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), "10 GP"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "(Revive)"
 CASE 2
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Water"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), " 8 GP"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "(Desert)"
 CASE 3
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Food"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), " 9 GP"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "(Forest)"
 CASE 4
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Glove"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), " 8 GP"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "(Snow)"
 CASE 5
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Boat"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), " 9 GP"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "(Swamp)"
 CASE 6
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Rope"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), "10 GP"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "(Mountain)"
 CASE 7
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Torch"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), "10 GP"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "(Cave)"
 CASE 8
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Sorry. You"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), "don't have"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "enough GP"
 CASE 9
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "can't buy"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), CHR$(129) + "Elixir" + CHR$(130)
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "twice"
 CASE 10
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "thank you"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), ""
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), ""
 CASE 11
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "Bye"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), "come again"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), ""
 CASE 12
   font.draw 74, 6 + 0 * 10, 0, fontbuff(), "You don't"
   font.draw 74, 6 + 1 * 10, 0, fontbuff(), "need items"
   font.draw 74, 6 + 2 * 10, 0, fontbuff(), "anymore"
 END SELECT

END SUB

SUB LoadConfig

 OPEN setupfilename FOR INPUT AS #1
 INPUT #1, dummy$, path$
 INPUT #1, dummy$, musics
 INPUT #1, dummy$, sounds
 INPUT #1, dummy$, bloods
 CLOSE #1
 musics = false
 sounds = false

END SUB

SUB LoadTileSet (N, playerid, extra)

 REDIM buffer0(0) AS INTEGER: REDIM buffer1(0) AS INTEGER
 REDIM buffer2(0) AS INTEGER: REDIM buffer3(0) AS INTEGER
 REDIM buffer4(0) AS INTEGER: REDIM buffer5(0) AS INTEGER
 REDIM buffer6(0) AS INTEGER: REDIM buffer7(0) AS INTEGER
 REDIM buffer8(0) AS INTEGER: REDIM buffer9(0) AS INTEGER
 REDIM bufferA(0) AS INTEGER: REDIM bufferB(0) AS INTEGER
 REDIM bufferC(0) AS INTEGER
 REDIM tempbuff(0)  AS INTEGER

 SELECT CASE N

 CASE 0: 'init default tiles
   PALETTE.LOAD path$ + gfxpath + "minirpg1.pal", PAL()
   palette.set PAL()
   IMAGE.LOAD path$ + gfxpath + "jsvfont.SPR", tempbuff(): SPRITE.LOAD tempbuff(), fontbuff()
   IMAGE.LOAD path$ + gfxpath + "items.SPR", tempbuff(): SPRITE.LOAD tempbuff(), itembuff()
 CASE 1: ' title
   IMAGE.LOAD path$ + gfxpath + "anykey.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
 CASE 2: 'intro
   IMAGE.LOAD path$ + gfxpath + "intro.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
   IMAGE.LOAD path$ + gfxpath + "balun1.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer1()
   IMAGE.LOAD path$ + gfxpath + "balun2.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer2()

 CASE 3: 'map with boss animations
   IMAGE.LOAD path$ + gfxpath + "hextile0.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
   IMAGE.LOAD path$ + gfxpath + "hextile1.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer1()
   IMAGE.LOAD path$ + gfxpath + "map-drgn.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer2()

 CASE 4: 'map with chara + user-2line-menu
   IMAGE.LOAD path$ + gfxpath + "hextile0.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
   IMAGE.LOAD path$ + gfxpath + "hextile1.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer1()
   IMAGE.LOAD path$ + gfxpath + "map-drgn.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer2()
  
   'menu balloon
   IMAGE.LOAD path$ + gfxpath + "balun3.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer3()
   IMAGE.LOAD path$ + gfxpath + "quit.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer4()

 CASE 5: 'roulette + arrow+ powerbar
   IMAGE.LOAD path$ + gfxpath + "wheel.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
   IMAGE.LOAD path$ + gfxpath + "arrow.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer1()
   IMAGE.LOAD path$ + gfxpath + "power.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer2()

 CASE 6: 'move + arrow
   IMAGE.LOAD path$ + gfxpath + "hextile0.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
   IMAGE.LOAD path$ + gfxpath + "hextile1.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer1()
   IMAGE.LOAD path$ + gfxpath + "map-drgn.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer2()
   IMAGE.LOAD path$ + gfxpath + "move.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer3()

   SELECT CASE playerid
   CASE 0: IMAGE.LOAD path$ + gfxpath + "map-rom.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "map-cndy.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "map-chv.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "map-cuky.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), buffer4()
  
   IMAGE.LOAD path$ + gfxpath + "balun5.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer5()
   IMAGE.LOAD path$ + gfxpath + "balun6.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer6()

 CASE 7: 'shopping [0,2,4]
   IMAGE.LOAD path$ + gfxpath + "shop.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
   IMAGE.LOAD path$ + gfxpath + "shopitem.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer1()
  
   IMAGE.LOAD path$ + gfxpath + "balun1.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer2()
   SELECT CASE playerid
   CASE 0: IMAGE.LOAD path$ + gfxpath + "map-rom.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "map-cndy.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "map-chv.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "map-cuky.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), buffer4()

 CASE 8: 'battle frame-A 'bg, chara A/B projectile/object, balloon

   'load BG
   SELECT CASE extra
   CASE 0 TO 3: IMAGE.LOAD path$ + gfxpath + "grass.SPR", tempbuff():
   CASE 4: IMAGE.LOAD path$ + gfxpath + "sand.SPR", tempbuff():
   CASE 5: IMAGE.LOAD path$ + gfxpath + "forest.SPR", tempbuff():
   CASE 6: IMAGE.LOAD path$ + gfxpath + "snow.SPR", tempbuff():
   CASE 7: IMAGE.LOAD path$ + gfxpath + "swamp.SPR", tempbuff():
   CASE 8: IMAGE.LOAD path$ + gfxpath + "mountain.SPR", tempbuff():
   CASE 9: IMAGE.LOAD path$ + gfxpath + "cave.SPR", tempbuff():
   CASE 10: IMAGE.LOAD path$ + gfxpath + "bone.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), buffer0()
   
   SELECT CASE playerid
   CASE 0: IMAGE.LOAD path$ + gfxpath + "atk-rom.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "atk-cndy.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "atk-chv.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "atk-cuky.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), buffer1()

   'load enemy
   SELECT CASE extra
   CASE 0: IMAGE.LOAD path$ + gfxpath + "atk-skul.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "atk-wwiz.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "atk-jsv.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "atk-bwiz.SPR", tempbuff():
   CASE 4: IMAGE.LOAD path$ + gfxpath + "atk-mid1.SPR", tempbuff():
   CASE 5: IMAGE.LOAD path$ + gfxpath + "atk-mid2.SPR", tempbuff():
   CASE 6: IMAGE.LOAD path$ + gfxpath + "atk-mid3.SPR", tempbuff():
   CASE 7: IMAGE.LOAD path$ + gfxpath + "atk-mid4.SPR", tempbuff():
   CASE 8: IMAGE.LOAD path$ + gfxpath + "atk-mid5.SPR", tempbuff():
   CASE 9: IMAGE.LOAD path$ + gfxpath + "atk-mid6.SPR", tempbuff():
   CASE 10: IMAGE.LOAD path$ + gfxpath + "atk-boss.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), buffer2()
   
   IMAGE.LOAD path$ + gfxpath + "balun9.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer3()

   'death player
   SELECT CASE playerid
   CASE 0: IMAGE.LOAD path$ + gfxpath + "end-rom.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "end-cndy.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "end-chv.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "end-cuky.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), buffer4()
  
   'load enemydeath
   SELECT CASE extra
   CASE 0: IMAGE.LOAD path$ + gfxpath + "end-skul.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "end-wwiz.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "end-jsv.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "end-bwiz.SPR", tempbuff():
 
   CASE 4: IMAGE.LOAD path$ + gfxpath + "atk-mid1.SPR", tempbuff():
   CASE 5: IMAGE.LOAD path$ + gfxpath + "atk-mid2.SPR", tempbuff():
   CASE 6: IMAGE.LOAD path$ + gfxpath + "atk-mid3.SPR", tempbuff():
   CASE 7: IMAGE.LOAD path$ + gfxpath + "atk-mid4.SPR", tempbuff():
   CASE 8: IMAGE.LOAD path$ + gfxpath + "atk-mid5.SPR", tempbuff():
   CASE 9: IMAGE.LOAD path$ + gfxpath + "atk-mid6.SPR", tempbuff():
   CASE 10: IMAGE.LOAD path$ + gfxpath + "end-boss.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), buffer5()
  
   'all FX
   IMAGE.LOAD path$ + gfxpath + "obj00.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer6()
   IMAGE.LOAD path$ + gfxpath + "obj01.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer7()
   IMAGE.LOAD path$ + gfxpath + "obj02.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer8()
   IF extra = 10 THEN IMAGE.LOAD path$ + gfxpath + "obj03.SPR", tempbuff(): SPRITE.LOAD tempbuff(), bufferC()
   IMAGE.LOAD path$ + gfxpath + "obj03.SPR", tempbuff(): SPRITE.LOAD tempbuff(), bufferC()
   
   'player projectile
   SELECT CASE playerid
   CASE 0: IMAGE.LOAD path$ + gfxpath + "proj00.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "proj01.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "proj02.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "proj03.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), bufferA()
 
   'enemy projectile
   SELECT CASE extra
   CASE 0: IMAGE.LOAD path$ + gfxpath + "proj04.SPR", tempbuff():
   CASE 1: IMAGE.LOAD path$ + gfxpath + "proj05.SPR", tempbuff():
   CASE 2: IMAGE.LOAD path$ + gfxpath + "proj06.SPR", tempbuff():
   CASE 3: IMAGE.LOAD path$ + gfxpath + "proj07.SPR", tempbuff():
   CASE 4 TO 10: IMAGE.LOAD path$ + gfxpath + "proj08.SPR", tempbuff():
   END SELECT
   SPRITE.LOAD tempbuff(), bufferB()

 CASE 9 'battle frame-B 'status, stat-bar
   IMAGE.LOAD path$ + gfxpath + "stat.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer0()
   IMAGE.LOAD path$ + gfxpath + "statbar.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer1()
   IMAGE.LOAD path$ + gfxpath + "marker.SPR", tempbuff(): SPRITE.LOAD tempbuff(), buffer2()

 END SELECT

 ERASE tempbuff

END SUB

SUB Main (beatgame)

 DrawStatus -1

 LoadTileSet 3, 0, 0
 PAGE.CREATE 160, 152, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 'starting point(castle)
 turnidx = 2
 turnidy = 0

 x = MapRelx(turnidx, turnidy)
 y = MapRelY(turnidx, turnidy)

 DrawHexMap x, y, turn
 PutChara x, y

 Delays 1
 PAGE.SHOW 16, 24, scrnbuff()

 fadeff

 bossStareTimer = 1
 FOR i = 0 TO 3
   IF player(i).AI = 0 THEN turn = i - 1
 NEXT

 Delays 120 * 0

 DO
   LoadTileSet 3, 0, 0
   PAGE.CREATE 160, 152, scrnbuff()
   PAGE.ACTIVE scrnbuff()

   PAGE.CLEAR scrnbuff()
  
   DrawHexMap x, y, turn
   PutChara x, y
  
   ' boss turn
   bossStareTimer = bossStareTimer - 1
   IF bossStareTimer = 0 THEN
     bossStareTimer = 3 + INT(RND * 5)
    
     ' move to boss position
     targetidx = player(4).idx
     targetidy = player(4).idy
  
     AutoScrollMap MapRelx(turnidx, turnidy), MapRelY(turnidx, turnidy), MapRelx(targetidx, targetidy), MapRelY(targetidx, targetidy), 4
   
     'update current turn position
     turnidx = targetidx
     turnidy = targetidy
    
     'update map offset
     x = MapRelx(turnidx, turnidy)
     y = MapRelY(turnidx, turnidy)
 
     IF NOT bossblink THEN
       bossblink = NOT bossblink
       LastMinuteUpdate1 x, y 'boss animation(1 time only)
     ELSE 'boss rotation
       BossAction x, y
     END IF

   END IF
  
   'player turn
   turn = (turn + 1) MOD 4

'  LOCATE 1, 1
'  PRINT MID$("ROM-----Cindy---Change-VCookie--", turn * 8 + 1, 8)
'  PRINT "ai : "; player(turn).aicommand
'  IF player(turn).aicommand = 0 THEN PRINT "random move----"
'  IF player(turn).aicommand = 1 THEN PRINT "go to shop-----"
'  IF player(turn).aicommand = 2 THEN PRINT "go to barrier--"
'  IF player(turn).aicommand = 3 THEN PRINT "go to finalboss"

   targetidx = player(turn).idx
   targetidy = player(turn).idy

   AutoScrollMap MapRelx(turnidx, turnidy), MapRelY(turnidx, turnidy), MapRelx(targetidx, targetidy), MapRelY(targetidx, targetidy), turn
  
   'update current turn position
  
   turnidx = targetidx
   turnidy = targetidy
   
   'update map offset
   x = MapRelx(turnidx, turnidy)
   y = MapRelY(turnidx, turnidy)

   'get player(user and AI) input
   IF map(player(turn).idx, player(turn).idy).dsz = 1 THEN 'shock& skip turn
     PlayerShock x, y, turn
   ELSE

     PlayerMapMenu x, y, turn, menuselection
   
     SELECT CASE menuselection

     CASE 0 'walk
       RouletteMenu turn, rouletteresult
       Delays 30
     
       charadir = 3 'chara faces down at start
      
       turnremain = rouletteresult MOD 3 + 1
      
       DO ' walking(max 3 times) start
         MoveChara x, y, charadir, turn, turnremain
     
         turnidx = player(turn).idx
         turnidy = player(turn).idy

         turnremain = turnremain - 1

         DrawStatus -1

         'walked 1 step. check for event tile/DSZ
         'reset remaining step, reset AI command tile(after getting DS)...etc
         IF map(turnidx, turnidy).typ = 9 THEN 'step on shop tile
           turnremain = 0 'stop walking
           Shop turn
       
           LoadTileSet 3, 0, 0
           PAGE.CREATE 160, 152, scrnbuff()
           PAGE.ACTIVE scrnbuff()
           fade00
           DrawHexMap x, y, turn
           PutChara x, y
           Delays 1
           PAGE.SHOW 16, 24, scrnbuff()
           fadeff

         END IF
        
         'step on barrier
         IF player(turn).aicommand = 2 THEN
           IF map(turnidx, turnidy).typ = player(turn).item + 1 THEN
             IF player(turn).dslayer = 0 THEN
               turnremain = 0 'stop walking
             ELSE 'yes dslayer . on empty barrier. goto boss
               player(turn).aicommand = 3
             END IF
           END IF
         END IF
        
         'step on boss tile
         IF player(turn).aicommand = 3 THEN
           IF map(turnidx, turnidy).typ = 8 THEN
             turnremain = 0 'stop walking
             player(turn).aicommand = 2
           END IF
         END IF
        
         'step on DSZ tile
         stepondsz = false
         IF map(turnidx, turnidy).dsz = 1 THEN 'shock& skip turn
           PlayerShock x, y, turn
           turnremain = 0
           stepondsz = true
           charadir = 3 'chara faces down at start
         END IF
        

         'update map offset to new location
         x = MapRelx(turnidx, turnidy)
         y = MapRelY(turnidx, turnidy)
      
       LOOP UNTIL turnremain = 0


       'battle init
       'normal = ground 1
       'mid boss = ground 2-7
       'final boss= ground 8

       LoadTileSet 6, turn, 0
       PAGE.CREATE 160, 152, scrnbuff()
       PAGE.ACTIVE scrnbuff()

       ground = map(turnidx, turnidy).typ
 
       SELECT CASE ground
       CASE 1
         Delays 30
         menux = 72 - 20 * (turn = 1 OR turn = 3)
         menuy = 22 - 18 * (turn = 2 OR turn = 3)
         DrawHexMap x, y, turn
         WalkChara x, y, charadir, turn, -1
         sprite.draw 0, menux, menuy, buffer6()
         Delays 1
         PAGE.SHOW 16, 24, scrnbuff()
         Delays 60
         fadeff
      
         oldenemyid = enemyid
         enemyid = INT(RND * 4)
         IF oldenemyid = enemyid THEN enemyid = (enemyid + 2) MOD 4

         'need battle result!!
         Battle turn, enemyid, battleresult

         '< if battle result=lost then reset position, hp... else give item >
         IF battleresult = lose THEN
           player(turn).idx = 2
           player(turn).idy = 0
           player(turn).dir = 0
           player(turn).hp = 10
           UpdateCharaPos (turn)
           turnidx = player(turn).idx
           turnidy = player(turn).idy
           x = MapRelx(turnidx, turnidy)
           y = MapRelY(turnidx, turnidy)
           charadir = 3
         END IF

         LoadTileSet 6, turn, 0
         PAGE.CREATE 160, 152, scrnbuff()
         PAGE.ACTIVE scrnbuff()
      
         DrawHexMap x, y, turn
      
         WalkChara x, y, charadir, turn, -1
      
         Delays 1
         PAGE.SHOW 16, 24, scrnbuff()
      
         fade00

       CASE 2 TO 8
         IF ground = 8 OR player(turn).dslayer = 0 THEN

           Delays 30
           menux = 72 - 20 * (turn = 1 OR turn = 3)
           menuy = 22 - 18 * (turn = 2 OR turn = 3)
           DrawHexMap x, y, turn
           WalkChara x, y, charadir, turn, -1
           sprite.draw 0, menux, menuy, buffer6()
           Delays 1
           PAGE.SHOW 16, 24, scrnbuff()
           Delays 60
           fadeff

           enemyid = ground + 2

           Battle turn, enemyid, battleresult
 
           '< if battle result=lost then reset position, hp... else give item>
           IF battleresult = lose THEN
             player(turn).idx = 2
             player(turn).idy = 0
             player(turn).dir = 0
             player(turn).hp = 10
             UpdateCharaPos (turn)
             turnidx = player(turn).idx
             turnidy = player(turn).idy
             x = MapRelx(turnidx, turnidy)
             y = MapRelY(turnidx, turnidy)
             charadir = 3
           ELSE
             IF enemyid = 10 THEN
               beatgame = true
               winnerID = turn
               winnerAI = player(turn).AI
               wid = turn
             END IF
           END IF

           LoadTileSet 6, turn, 0
           PAGE.CREATE 160, 152, scrnbuff()
           PAGE.ACTIVE scrnbuff()
     
           DrawHexMap x, y, turn

           WalkChara x, y, charadir, turn, -1

           Delays 1
           PAGE.SHOW 16, 24, scrnbuff()
     
           'end of battle. white to color map screen
           IF NOT beatgame THEN fade00

         END IF
       END SELECT
      
       'set default sprite set
       player(turn).dir = 0

     CASE 1 'rest...
      
       RouletteMenu turn, rouletteresult
       Delays 30
       recover = rouletteresult MOD 3 + 1
      
       LoadTileSet 3, 0, 0
       PAGE.CREATE 160, 152, scrnbuff()
       PAGE.ACTIVE scrnbuff()

       FOR i = 1 TO 12
         DrawHexMap x, y, turn
         PutChara x, y
         
         bouncex = 61 - 22 * (turn = 1 OR turn = 3)
         bouncey = 48 + 0 - 18 * (turn = 2 OR turn = 3)

         BounceFX bouncex, bouncey, recover, i

         Delays 1
         PAGE.SHOW 16, 24, scrnbuff()
      
         Delays 4

       NEXT

       player(turn).hp = player(turn).hp + recover
       IF player(turn).hp >= 10 THEN player(turn).hp = 10
       DrawStatus turn

     CASE 2: quit = true
    
     END SELECT
  
   END IF

 LOOP UNTIL INKEY$ = CHR$(27) OR quit OR beatgame

 IF NOT beatgame THEN fade00 'if beat game, exit while white

END SUB

FUNCTION MapIDx (x, y)

 MapIDx = x * 46

END FUNCTION

FUNCTION MapIDy (x, y)

 MapIDy = y * 46 + (x AND 1) * 23

END FUNCTION

FUNCTION MapRelx (x, y)

 MapRelx = 51 - x * 46

END FUNCTION

FUNCTION MapRelY (x, y)

 MapRelY = 53 - y * 46 - (x AND 1) * 23

END FUNCTION

SUB MoveChara (x, y, charadir, ID, roulette)

 'load tile set
 LoadTileSet 6, ID, 0
 PAGE.CREATE 160, 152, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 'starting point(castle)
 turnidx = player(ID).idx
 turnidy = player(ID).idy

 'reset mapx,y
 x = MapRelx(turnidx, turnidy)
 y = MapRelY(turnidx, turnidy)

 'drawmap, put chara
 DrawHexMap x, y, ID
 WalkChara x, y, charadir, ID, -1
 Delays 1
 PAGE.SHOW 16, 24, scrnbuff()

 'set arrow dir
 arrowdir = charadir

 AI = player(ID).AI

   'select direction : user control
   DO
     a$ = INKEY$
     ' if ai = user then input
     '  else check ai-command, if target then calc dir<dir(x,y)> else rnd
    
     IF AI = 0 THEN 'user input
       IF a$ = CHR$(0) + "K" THEN arrowdir = VAL(MID$("503454", arrowdir + 1, 1))
       IF a$ = CHR$(0) + "M" THEN arrowdir = VAL(MID$("121230", arrowdir + 1, 1))
       IF a$ = CHR$(0) + "P" THEN arrowdir = VAL(MID$("323334", arrowdir + 1, 1))
       IF a$ = CHR$(0) + "H" THEN arrowdir = VAL(MID$("001050", arrowdir + 1, 1))
     ELSE
       'CPU AI, check command for dir/random

       'simple random move
       SELECT CASE player(ID).aicommand
       CASE 0 'no target... random move
         a$ = CHR$(0) + MID$("KMPH", INT(RND * 4) + 1, 1)
         IF a$ = CHR$(0) + "K" THEN arrowdir = VAL(MID$("503454", arrowdir + 1, 1))
         IF a$ = CHR$(0) + "M" THEN arrowdir = VAL(MID$("121230", arrowdir + 1, 1))
         IF a$ = CHR$(0) + "P" THEN arrowdir = VAL(MID$("323334", arrowdir + 1, 1))
         IF a$ = CHR$(0) + "H" THEN arrowdir = VAL(MID$("001050", arrowdir + 1, 1))

         'set AI command... set target tile id
         '@battle ) after battle, add money. if $10 then set ai command=1(shopping)
         '
         '@shop ) in shop, if buy item, set aicommand=2(look for place to use the item)
         '        stop walk
         '
         '@main ) after step on barrier, check DS. if no have fight boss . after
         '        mid-battle, set command = 3(goto final boss). stop walk
         '
         '@main ) if have DS, set command=3(no fight). cont walk
      
       CASE 1 'enough money... look for shop
         arrowdir = ABS(HexDirScan(turnidx, turnidy, 10, 9))
      
       CASE 2 ' bought item. goto barrier with item(don't know midboss dead)
         target = player(ID).item
         arrowdir = ABS(HexDirScan(turnidx, turnidy, 10, target + 1))
      
       CASE 3 'beat mid-boss..(when step on barrier) goto final boss
         target = 8
         arrowdir = ABS(HexDirScan(turnidx, turnidy, 10, target))

     END SELECT

   END IF

   DO
     'clip(calculate 'out of range')
     clipx = Nextx(player(ID).idx, player(ID).idy, arrowdir)
     clipy = Nexty(player(ID).idx, player(ID).idy, arrowdir)
    
     canwalk = false
 
     IF clipx >= 0 AND clipy >= 0 AND clipx <= 8 AND clipy <= 8 THEN

       'check walkable tile
       IF map(clipx, clipy).typ = 1 THEN canwalk = true 'normal
       IF map(clipx, clipy).typ = 9 THEN canwalk = true 'shop
       IF map(clipx, clipy).typ = 8 THEN canwalk = true 'final boss
      
       'barrier with item
       IF map(clipx, clipy).typ = player(ID).item + 1 THEN canwalk = true
       IF map(clipx, clipy).typ = player(ID).dslayer + 1 THEN canwalk = true
    
      
       ok = true
       'if npc and target ok
       IF AI > 0 AND player(ID).aicommand >= 1 THEN

         'if nextpanel > barrier then turn L/R
         IF map(clipx, clipy).typ >= 2 AND map(clipx, clipy).typ <= 7 THEN
          
           'if item=barrier then no turn else turn R/L
           IF player(ID).item = map(clipx, clipy).typ - 1 THEN
             'ok = true
           ELSE
             arrowdir = (arrowdir + 5) MOD 6
             ok = false
           END IF
         ELSE
          'ok = true
         END IF
       ELSE
        'ok = true
       END IF
     ELSE
       'out of range. works only with NPC
       IF AI > 0 THEN
         ok = false
         arrowdir = (arrowdir + 3) MOD 6 'reverse dir
       ELSE
         ok = true
       END IF
     END IF
   LOOP UNTIL ok
  
   ok = (a$ = CHR$(13) OR a$ = " ") AND canwalk OR (AI > 0 AND canwalk)

   DrawHexMap x, y, ID

   'add arrow
   arrowx = VAL(MID$("699494694444", arrowdir * 2 + 1, 2))
   arrowy = VAL(MID$("405479937954", arrowdir * 2 + 1, 2))
   sprite.draw ((arrowdir + 1) * -(canwalk)), arrowx, arrowy, buffer3()
   WalkChara x, y, arrowdir, ID, -1

   'add word balloon(n-steps)
   menux = 72 - 20 * (ID = 1 OR ID = 3)
   menuy = 12 - 18 * (ID = 2 OR ID = 3)
   sprite.draw -(roulette > 1), menux, menuy, buffer5()
   font.draw menux + 5, menuy + 7, 0, fontbuff(), RIGHT$(STR$(roulette), 1)
 
   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

   'show enemy move little bit more
   IF (AI > 0) THEN Delays 20: IF canwalk THEN Delays 40

 LOOP UNTIL ok

 'direction already calculated.
 'next step : move

 'walking
 charadir = arrowdir
 WalkChara x, y, charadir, ID, arrowdir

 'reset charax,y with idx,idy value
 player(ID).idx = clipx
 player(ID).idy = clipy
 UpdateCharaPos ID

 Delays 10

END SUB

FUNCTION NextSy (x, y, dir)
'y is inversed

 SELECT CASE dir
   CASE 0, 3: NextSy = y + SGN(dir - 1)
   CASE 1, 5: NextSy = y - 1 + ((x AND 1) XOR 1)
   CASE 2, 4: NextSy = y + 1 - ((x AND 1))
 END SELECT

END FUNCTION

FUNCTION Nextx (x, y, dir)

 SELECT CASE dir
   CASE 0, 3: Nextx = x
   CASE 1, 2: Nextx = x + 1
   CASE 4, 5: Nextx = x - 1
 END SELECT

END FUNCTION

FUNCTION Nexty (x, y, dir)

 SELECT CASE dir
   CASE 0, 3: Nexty = y + SGN(dir - 1)
   CASE 1, 5: Nexty = y - 1 + ((x AND 1))
   CASE 2, 4: Nexty = y + 1 - ((x AND 1) XOR 1)
 END SELECT

END FUNCTION

SUB Pause (a$)

 IF a$ = "" THEN
   DO: LOOP UNTIL INKEY$ <> ""
 ELSE
   DO: LOOP UNTIL INKEY$ = a$
 END IF

END SUB

SUB PlayerBtlMenu (ID, enemyid, selection)

 LoadTileSet 8, ID, enemyid
 PAGE.CREATE 160, 88, scrnbuff()
 PAGE.ACTIVE scrnbuff()
 AI = player(ID).AI

 menux = 32 + 5
 menuy = 16

 selection = 0
 bary = 0

 control = true

 Delays 60
 ClearBuffer

 IF AI = 0 THEN 'user
   DO
     a$ = INKEY$

     IF control THEN
       IF a$ = CHR$(0) + "H" AND selection = 1 THEN 'move up
         control = NOT control
         move = 11
         selection = 0
       END IF
     
       IF a$ = CHR$(0) + "P" AND selection = 0 THEN 'move dn
         control = NOT control
         move = 11
         selection = 1
       END IF
     ELSE
       move = move - 1
       IF move = 0 THEN control = NOT control
       bary = bary + (selection * 2 - 1)

       'move bar'
     END IF
  
     'outupt
     page.fill 204, scrnbuff()
     sprite.put 0, 0, 0, buffer0()     'bg
     sprite.draw 0, 23, 45, buffer1()  'player
     sprite.draw 0, 110, 45, buffer2() 'enemy
  
     sprite.draw 0, menux, menuy, buffer3()

     draw.boxfill menux + 3, menuy + 3 + bary, menux + 53, menuy + 13 + bary, 64

     'draw font
     font.draw menux + 5, menuy + 4, -(183 * (NOT control OR selection = 1)), fontbuff(), "Attack"
     font.draw menux + 5, menuy + 15, -(183 * ((NOT control OR selection = 0) OR player(ID).mstone = 0)), fontbuff(), "Magic"

     Delays 1
     PAGE.SHOW 16, 24, scrnbuff()

     ok = ((a$ = " " OR a$ = CHR$(13)) AND control)

     IF selection = 1 AND player(ID).mstone = 0 THEN ok = false

   LOOP UNTIL ok

   'flash needed!!
   FOR i = 1 TO 6
     control = NOT control
     'page.fill 204, scrnbuff()
     sprite.put 0, 0, 0, buffer0()     'bg
     sprite.draw 0, 23, 45, buffer1()  'player
     sprite.draw 0, 110, 45, buffer2() 'enemy
     sprite.draw 0, menux, menuy, buffer3()
     draw.boxfill menux + 3, menuy + 3 + bary, menux + 53, menuy + 13 + bary, 64
     'draw font
     font.draw menux + 5, menuy + 4, -(183 * (NOT control OR selection = 1)), fontbuff(), "Attack"
     font.draw menux + 5, menuy + 15, -(183 * ((NOT control OR selection = 0) OR player(ID).mstone = 0)), fontbuff(), "Magic"
     Delays 10
     PAGE.SHOW 16, 24, scrnbuff()
   NEXT

   Delays 10

 ELSE
   selection = -(player(ID).mstone = 1 AND RND > .5)  ' 50% magic attack(NPC)

   'page.fill 204, scrnbuff()
   sprite.put 0, 0, 0, buffer0()     'bg
   sprite.draw 0, 23, 45, buffer1()  'player
   sprite.draw 0, 110, 45, buffer2() 'enemy

   sprite.draw selection + 1, menux, menuy, buffer3()
    
   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

   Delays 60

 END IF

END SUB

SUB PlayerMapMenu (x, y, ID, selection)

 LoadTileSet 4, 0, 0
 PAGE.CREATE 160, 152, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 AI = player(ID).AI

 menux = 72 - 20 * (ID = 1 OR ID = 3)
 menuy = 12 - 18 * (ID = 2 OR ID = 3)
 
 selection = 0
 bary = 0

 control = true

 Delays 60

 IF AI = 0 THEN 'user
   DO
     a$ = INKEY$

     IF a$ = CHR$(27) THEN
       QuitMenu x, y, ID, quit
     END IF

     IF a$ = CHR$(0) + ";" THEN
       speedup = NOT speedup
       LOCATE 1, 1: PRINT "Speed ";
       PRINT MID$("NormalUp    ", speedup * -6 + 1, 6)
       FOR i = 1 TO 60: WAIT &H3DA, 8: WAIT &H3DA, 8, 8: NEXT
       LOCATE 1, 1: PRINT STRING$(16, 32)
     END IF

     IF NOT quit THEN

       IF control THEN
         IF a$ = CHR$(0) + "H" AND selection = 1 THEN 'move up
           control = NOT control
           move = 11
           selection = 0
         END IF
      
         IF a$ = CHR$(0) + "P" AND selection = 0 THEN 'move dn
           control = NOT control
           move = 11
           selection = 1
         END IF
       ELSE
         move = move - 1
         IF move = 0 THEN control = NOT control
         bary = bary + (selection * 2 - 1)

         'move bar'
       END IF
    
       DrawHexMap x, y, ID
       PutChara x, y
       sprite.draw 0, menux, menuy, buffer3() 'draw balloon

       draw.boxfill menux + 3, menuy + 4 + bary, menux + 37, menuy + 14 + bary, 64

       'draw font
       font.draw menux + 5, menuy + 5, -(183 * (NOT control OR selection = 1)), fontbuff(), "Move"
       font.draw menux + 5, menuy + 16, -(183 * (NOT control OR selection = 0)), fontbuff(), "Rest"
    
       Delays 1
       PAGE.SHOW 16, 24, scrnbuff()

     END IF
   LOOP UNTIL (a$ = " " OR a$ = CHR$(13)) AND control OR quit

   IF NOT quit THEN

     'flash selection several times
     FOR i = 1 TO 6
       control = NOT control
    
       DrawHexMap x, y, ID
       PutChara x, y
       sprite.draw 0, menux, menuy, buffer3() 'draw balloon

       draw.boxfill menux + 3, menuy + 4 + bary, menux + 37, menuy + 14 + bary, 64

       'draw font
       font.draw menux + 5, menuy + 5, -(183 * (NOT control OR selection = 1)), fontbuff(), "Move"
       font.draw menux + 5, menuy + 16, -(183 * (NOT control OR selection = 0)), fontbuff(), "Rest"
   
       Delays 10
       PAGE.SHOW 16, 24, scrnbuff()
     NEXT
  
     Delays 10

   END IF

 ELSE 'CPU AI

   SELECT CASE AI
  
   CASE 1: 'rnd
     selection = -(RND < .3) '66% move
  
   CASE 2:
     IF player(ID).hp <= 4 THEN
       selection = 1
     ELSE
       selection = -(RND < .3) '66% move
     END IF
  
   CASE 3:
     IF player(ID).hp <= 6 THEN
       selection = 1
     ELSE
       selection = -(RND < .3) '66% move
     END IF
   END SELECT

   DrawHexMap x, y, ID
   PutChara x, y
   sprite.draw 1, menux, menuy, buffer3() 'draw balloon

   'draw font
   font.draw menux + 5, menuy + 16, 0, fontbuff(), MID$("MoveRest", selection * 4 + 1, 4)
  
   Delays 10
   PAGE.SHOW 16, 24, scrnbuff()
   Delays 60
  
 END IF

 IF quit THEN selection = 2

END SUB

SUB PlayerShock (x, y, ID)

 LoadTileSet 3, 0, 0
 PAGE.CREATE 160, 152, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 FOR i = 1 TO 8
   DrawHexMap x, y, ID

   player(ID).dir = (player(ID).dir MOD 2) + 1
   PutChara x, y
   Delays 10
   PAGE.SHOW 16, 24, scrnbuff()
 NEXT

 player(ID).dir = 0

END SUB

SUB ProcessCmdLine

 ' sorry. all of these are not used in this game
 a$ = COMMAND$
 IF INSTR(a$, "-NOMUSIC") THEN musics = false
 IF INSTR(a$, "-NOSOUND") THEN sounds = false
 IF INSTR(a$, "-NOBLOOD") THEN bloods = false

END SUB

SUB PutChara (x, y)

 SortSpriteY
 FOR i = 0 TO 4
   ID = ysort(i).ID
   spr = ID * 3 + player(ID).dir
   sprite.draw spr, x + player(ID).x, y + player(ID).y, buffer2()
 NEXT

END SUB

SUB QuitMenu (x, y, ID, quit)

 DrawHexMap x, y, ID
 PutChara x, y
 sprite.put 0, 0, 0, buffer4()
 Delays 1
 PAGE.SHOW 16, 24, scrnbuff()

 menux = 32
 menuy = 8

 selection = 1
 bary = 0 + 11
 control = true

 ok = true

 DO
   a$ = INKEY$
  
   IF control THEN
     IF a$ = CHR$(0) + "H" AND selection = 1 THEN 'move up
       control = NOT control
       move = 11
       selection = 0
     END IF

     IF a$ = CHR$(0) + "P" AND selection = 0 THEN 'move dn
       control = NOT control
       move = 11
       selection = 1
     END IF
   ELSE
     move = move - 1
     IF move = 0 THEN control = NOT control
     bary = bary + (selection * 2 - 1)
   END IF

   DrawHexMap x, y, ID
   PutChara x, y
  
   sprite.put 0, 0, 0, buffer4()

   draw.boxfill menux + 0, menuy + 4 + bary, menux + 37, menuy + 14 + bary, 64

   'draw font
   font.draw menux + 8, menuy + 5, -(183 * (NOT control OR selection = 1)), fontbuff(), "YES"
   font.draw menux + 8 + 4, menuy + 16, -(183 * (NOT control OR selection = 0)), fontbuff(), "NO"

   Delays 1
   PAGE.SHOW 16, 24, scrnbuff()

 LOOP UNTIL (a$ = " " OR a$ = CHR$(13) OR a$ = CHR$(27)) AND control

 IF a$ = " " OR a$ = CHR$(13) THEN
   FOR i = 1 TO 6
     control = NOT control
   
     DrawHexMap x, y, ID
     PutChara x, y
     sprite.put 0, 0, 0, buffer4()

     draw.boxfill menux + 0, menuy + 4 + bary, menux + 37, menuy + 14 + bary, 64

     'draw font
     font.draw menux + 8, menuy + 5, -(183 * (NOT control OR selection = 1)), fontbuff(), "YES"
     font.draw menux + 8 + 4, menuy + 16, -(183 * (NOT control OR selection = 0)), fontbuff(), "NO"
  
     Delays 10
     PAGE.SHOW 16, 24, scrnbuff()
   NEXT
 END IF

 quit = selection = 0 AND (a$ = " " OR a$ = CHR$(13))

END SUB

SUB RouletteMenu (ID, result)

 STATIC arrowangle

 LoadTileSet 5, 0, 0
 PAGE.CREATE 56, 64, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 power = 0
 powerdir = 1

 sprite.draw 0, 0, 0, buffer0()
 sprite.draw arrowangle, 13, 12, buffer1()
 sprite.draw power, 35, 57, buffer2()

 PAGE.SHOW 16 + 104, 12 + 100, scrnbuff()

IF ID > -1 THEN

 Delays 60

 AI = player(ID).AI

 'power bar timer(AI/player)
 IF AI > 0 THEN
   powertimer = 20 + INT(RND * 40)
 ELSE
   powertimer = 0
 END IF

 '-< power bar part >-
 DO: LOOP UNTIL INKEY$ = ""

 DO
   a$ = INKEY$
  
   IF AI THEN powertimer = powertimer - 1

   powerdelay = (powerdelay + 1) MOD 4
   IF powerdelay = 0 THEN
     power = power + powerdir
     IF power = 0 OR power = 5 THEN powerdir = -powerdir
   END IF

   '-< clear doublebuffer >-
   sprite.draw 0, 0, 0, buffer0()
   sprite.draw arrowangle, 13, 12, buffer1()
   sprite.draw power, 35, 57, buffer2()

   Delays 1
   PAGE.SHOW 16 + 104, 12 + 100, scrnbuff()

 LOOP UNTIL ((a$ = " " OR a$ = CHR$(13)) AND AI = 0) OR powertimer < 0

 '-< spinning part >-
 IF NOT quit THEN
   arrowcounter = 12 + (2 * power) * 12 + INT(RND * 12)
   arrowstep1 = INT(arrowcounter / 5 * 3)
   arrowstep2 = INT(arrowcounter / 10 * 1)
   arrowdelay = 1
 
   DO

     IF arrowcounter = arrowstep1 THEN arrowdelay = 2
     IF arrowcounter = arrowstep2 THEN arrowdelay = 8
 
     arrowdelayctr = (arrowdelayctr + 1) MOD arrowdelay
     IF arrowdelayctr = 0 THEN
       arrowangle = (arrowangle + 1) MOD 12
       arrowcounter = arrowcounter - 1
     END IF
 
     sprite.draw 0, 0, 0, buffer0()
     sprite.draw arrowangle, 13, 12, buffer1()
     sprite.draw power, 35, 57, buffer2()
      
     Delays 1
     PAGE.SHOW 16 + 104, 12 + 100, scrnbuff()

   LOOP UNTIL arrowcounter = 0
 END IF

 result = arrowangle \ 2

END IF

END SUB

FUNCTION Scan (x, y, dir, range, ID)

 scanx = x
 scany = y

 result = 0

 FOR turnpoint = range TO 1 STEP -1
   FOR steps = turnpoint TO 1 STEP -1
     scanx = Nextx(scanx, scany, dir)
     scany = NextSy(scanx, scany, dir)
     IF scanx >= 0 AND scany >= 0 AND scanx <= 8 AND scany <= 8 THEN
       result = result - (map(scanx, scany).typ = ID)
     END IF
   NEXT
   dir = (dir + 2) MOD 6
 NEXT

 Scan = result

END FUNCTION

SUB SE (N)

 'sorry. sound effects are not used in this game
 SELECT CASE N
 CASE 1: 'sound effect #1
 CASE 2: 'sound effect #2
 CASE 3: 'sound effect #3
 CASE 4: 'sound effect #4
 END SELECT

END SUB

SUB SetStareZone

 'clear zone
 FOR j = 0 TO 8
   FOR i = 0 TO 8
     map(i, j).dsz = 0
   NEXT
 NEXT

 dir = player(4).dir
 mx = player(4).idx: my = player(4).idy

 mx = Nextx(mx, my, dir)
 my = NextSy(mx, my, dir) ' invY

 lx = player(4).idx: ly = player(4).idy
 lx = Nextx(lx, ly, (dir + 5) MOD 6)
 ly = NextSy(lx, ly, (dir + 5) MOD 6)

 rx = player(4).idx: ry = player(4).idy
 rx = Nextx(rx, ry, (dir + 1) MOD 6)
 ry = NextSy(rx, ry, (dir + 1) MOD 6)

 FOR i = 1 TO 10

   IF Dist(4, 4, mx, my) < 5 THEN map(mx, my).dsz = 1
   mx = Nextx(mx, my, dir)
   my = NextSy(mx, my, dir)

   IF Dist(4, 4, lx, ly) < 5 THEN map(lx, ly).dsz = 1
   lx = Nextx(lx, ly, dir)
   ly = NextSy(lx, ly, dir)
 
   IF Dist(4, 4, rx, ry) < 5 THEN map(rx, ry).dsz = 1
   rx = Nextx(rx, ry, dir)
   ry = NextSy(rx, ry, dir)

 NEXT

END SUB

SUB Shop (ID)

 LoadTileSet 7, ID, 0'load intro set
 selection = 0
 cursorx = 43
 cursory = 80

 fade00
  
 '-< display frames >-
 DEF SEG = &HA000
 BLOAD path$ + gfxpath + "frame.scr"
 DEF SEG
 DrawStatus -1

 'init big double buffer
 PAGE.CREATE 160, 152, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 'display shop BG
 sprite.put 0, 0, 0, buffer0()
 sprite.draw selection, 36 + selection * 15, 67, buffer1()
 sprite.draw 48 - moving, cursorx, cursory + bouncey, itembuff()
 sprite.draw 0, 70, 100, buffer4()
 PAGE.SHOW 16, 24, scrnbuff()
 fadeff
 Delays 60

 'display some text
 sprite.draw 0, 70, 2, buffer2()
 draw.boxfill 74, 6, 74 + 72 + 6, 6 + 28, 204 + 1 * 0
 font.draw 74, 6 + 0 * 10, 0, fontbuff(), "I am CANDY"
 font.draw 74, 6 + 1 * 10, 0, fontbuff(), "May I"
 font.draw 74, 6 + 2 * 10, 0, fontbuff(), "help you?"
 PAGE.SHOW 16, 24, scrnbuff()
 Delays 100
 sprite.put 0, 0, 0, buffer0()
 sprite.draw selection, 36 + selection * 15, 67, buffer1()
 sprite.draw 48 - moving, cursorx, cursory + bouncey, itembuff()
 sprite.draw 0, 70, 100, buffer4()
 PAGE.SHOW 16, 24, scrnbuff()
 Delays 100

 'if ai=cpu then select item, get target item id

 AI = player(ID).AI

 target = VAL(MID$("00243567", AI * 2 + INT(RND * 2) + 1, 1))

 DO
   done = false
   moving = false
   DO
  
     'BG
     sprite.put 0, 0, 0, buffer0()
     sprite.draw 0, 70, 100, buffer4()

     a$ = INKEY$

     IF NOT moving THEN
       IF AI <> 0 THEN
         a$ = AiShopInput$(selection, target)
       END IF
   
       IF a$ = CHR$(0) + "K" AND selection > 0 THEN cursordir = -1: cursormove = 15: moving = true
       IF a$ = CHR$(0) + "M" AND selection < 7 THEN cursordir = 1: cursormove = 15: moving = true
    
       IF AI = 0 THEN LMUshoptalk selection
    
       IF a$ = " " OR a$ = CHR$(13) THEN
         target = 0
         done = true
         ok = false

         IF player(ID).dslayer > 0 AND selection > 1 THEN
           LMUshoptalk 12 'don't need item
         ELSEIF player(ID).elixir = 1 AND selection = 1 THEN
           LMUshoptalk 9 'can't buy 2 elixir
         ELSE
           IF player(ID).gp < VAL("&H" + MID$("0A8989AA", selection + 1, 1)) THEN
             LMUshoptalk 8 'not enough money
           ELSE
             'check double item. add info
             SELECT CASE selection
             CASE 0: ok = true: quit = true
             CASE 1:
               IF player(ID).elixir = 0 THEN ok = true
             CASE 2 TO 7: ok = true
             END SELECT
           END IF
         END IF
       END IF

       sprite.draw selection, 36 + selection * 15, 67, buffer1()
  
     ELSE
       cursormove = cursormove - 1
       IF cursormove = 0 THEN
         moving = false
         selection = (selection + 8 + cursordir) MOD 8
       END IF
       cursorx = cursorx + cursordir
       bouncey = VAL(MID$("012333333333321", cursormove + 1, 1))
     END IF

     sprite.draw 48 - moving, cursorx, cursory + bouncey, itembuff()

     Delays 1
     PAGE.SHOW 16, 24, scrnbuff()

   LOOP UNTIL done

   IF ok THEN
     IF AI <> 0 AND selection > -1 THEN
       LMUshoptalk selection
       sprite.draw 48 - moving, cursorx, cursory + bouncey, itembuff()
       Delays 1
       PAGE.SHOW 16, 24, scrnbuff()
       Delays 100
     END IF
   
     FOR i = 0 TO 5
       sprite.put 0, 0, 0, buffer0()
      
       LMUshoptalk 10 - (selection = 0)'thankyou or bye
  
       sprite.draw 0, 70, 100, buffer4()
       IF (i AND 1) THEN sprite.draw selection, 36 + selection * 15, 67, buffer1()
       sprite.draw 48, cursorx, cursory + bouncey, itembuff()
       Delays 1
       PAGE.SHOW 16, 24, scrnbuff()
       Delays 10
     NEXT

     SELECT CASE selection
     CASE IS = 0: quit = true
     CASE 1: 'elixir
       player(ID).gp = player(ID).gp - 10
       player(ID).elixir = player(ID).elixir XOR 1
       'reset ai(back to moneyless)
       IF player(ID).aicommand = 1 THEN player(ID).aicommand = 0

     CASE 2 TO 7 'buy item
       player(ID).gp = player(ID).gp - VAL("&H" + MID$("0A8989AA", selection + 1, 1))
       player(ID).item = selection - 1
       player(ID).aicommand = 2 'goto barrier with item

     END SELECT

     DrawStatus ID
     PAGE.ACTIVE scrnbuff()
   ELSE
     'couldn't buy... wait for message
     Delays 1
     PAGE.SHOW 16, 24, scrnbuff()
     Delays 60
   END IF

 LOOP UNTIL quit '(exit the shop)

END SUB

SUB SortSpriteY

 'register chara + boss
 FOR i = 0 TO 4
   ysort(i).ID = i
   ysort(i).y = player(i).y
 NEXT

 'simple bubble sort!!(yep! I use BUBBLE SORT!)
 FOR j = 0 TO 4
   FOR i = 0 TO 4
     IF ysort(i).y > ysort(j).y THEN
       SWAP ysort(i).ID, ysort(j).ID
       SWAP ysort(i).y, ysort(j).y
     END IF
   NEXT
 NEXT

END SUB

SUB Talk1 (x, y, N)
' hardwired talk routine for this demo.(planning to change again.. not now.)

 FOR i = 0 TO 18
   font.draw x, y + i * 10 + N + 1, 0, fontbuff(), talk$(i)
 NEXT

END SUB

SUB Title (result)

 LoadTileSet 1, 0, 0'load title set

 DEF SEG = &HA000
 BLOAD path$ + gfxpath + "title.scr"
 DEF SEG
 PAGE.CREATE 119, 9, scrnbuff()
 PAGE.ACTIVE scrnbuff()

 blinkctr = 0
 blink = 0

 fadeff

 DO
   a$ = INKEY$

   blinkctr = (blinkctr + 1) MOD 30
   IF blinkctr = 0 THEN blink = (blink + 1) MOD 2
 
   sprite.put blink, 0, 0, buffer0()
   Delays 1
   PAGE.SHOW 167, 150, scrnbuff()

 LOOP UNTIL a$ <> ""

 result = (a$ = CHR$(27))

 fade00

END SUB

SUB UpdateCharaPos (N)

 'call this sub after moving into another hextile

 player(N).x = MapIDx(player(N).idx, player(N).idy)
 player(N).y = MapIDy(player(N).idx, player(N).idy)

 'adjust little bit!!
 player(N).x = player(N).x - 2 * (N = 0 OR N = 2)
 player(N).x = player(N).x - 22 * (N = 1 OR N = 3)
 player(N).y = player(N).y + 12 * (N = 0 OR N = 1)
 player(N).y = player(N).y - 6 * (N = 2 OR N = 3)

 ' adjust boss position
 IF N = 4 THEN
   player(N).x = player(N).x + 13
   player(N).y = player(N).y - 3
 END IF

END SUB

SUB WalkChara (mapx, mapy, charadir, ID, dir)

 UpdateCharaPos ID

 animstep = 1

 IF dir > -1 THEN

   FOR j = 1 TO 23

     animdir = VAL(MID$("022466", dir + 1, 1))
     animstepdelay = (animstepdelay + 1) MOD 4
     IF animstepdelay = 0 THEN animstep = (animstep + 1) MOD 2

     SELECT CASE dir
     CASE 0: mapy = mapy + 2:
         player(ID).y = player(ID).y - 2
     CASE 1: mapx = mapx - 2: mapy = mapy + 1
         player(ID).x = player(ID).x + 2: player(ID).y = player(ID).y - 1
     CASE 2: mapx = mapx - 2: mapy = mapy - 1
         player(ID).x = player(ID).x + 2: player(ID).y = player(ID).y + 1
     CASE 3: mapy = mapy - 2
         player(ID).y = player(ID).y + 2
     CASE 4: mapx = mapx + 2: mapy = mapy - 1
         player(ID).x = player(ID).x - 2: player(ID).y = player(ID).y + 1
     CASE 5: mapx = mapx + 2: mapy = mapy + 1
         player(ID).x = player(ID).x - 2: player(ID).y = player(ID).y - 1
     END SELECT

     DrawHexMap mapx, mapy, ID

     'output chara
     SortSpriteY
     FOR i = 0 TO 4
       sortedid = ysort(i).ID
  
       IF sortedid = ID THEN 'walking char
         spr = animdir + animstep
         sprite.draw spr, mapx + player(sortedid).x, mapy + player(sortedid).y, buffer4()
       ELSE
         spr = sortedid * 3 + player(sortedid).dir
         sprite.draw spr, mapx + player(sortedid).x, mapy + player(sortedid).y, buffer2()
       END IF
     NEXT

     Delays 2
     PAGE.SHOW 16, 24, scrnbuff()
  
   NEXT

 ELSE

   'output nonmoving chara
   SortSpriteY
   FOR i = 0 TO 4
     sortedid = ysort(i).ID
     IF sortedid = ID THEN 'walking chara(without animation)
       animdir = VAL(MID$("022466", charadir + 1, 1))
       spr = animdir
       sprite.draw spr, mapx + player(sortedid).x, mapy + player(sortedid).y, buffer4()
     ELSE
       spr = sortedid * 3 + player(sortedid).dir
       sprite.draw spr, mapx + player(sortedid).x, mapy + player(sortedid).y, buffer2()
     END IF
   NEXT

 END IF

END SUB

